/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.commons.io;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Optional;
import java.util.function.UnaryOperator;
import lombok.NonNull;
import org.apache.causeway.commons.functional.Try;
import org.apache.causeway.commons.io.DataSink;
import org.apache.causeway.commons.io.DataSource;
import org.springframework.lang.Nullable;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;

public final class YamlUtils {
    public static <T> Try<T> tryRead(@NonNull Class<T> mappedType, @Nullable String stringUtf8) {
        if (mappedType == null) {
            throw new NullPointerException("mappedType is marked non-null but is null");
        }
        return YamlUtils.tryRead(mappedType, DataSource.ofStringUtf8(stringUtf8));
    }

    public static <T> Try<T> tryRead(@NonNull Class<T> mappedType, @NonNull DataSource source) {
        if (mappedType == null) {
            throw new NullPointerException("mappedType is marked non-null but is null");
        }
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        return source.tryReadAll(is -> Try.call(() -> YamlUtils.createMapper(mappedType, new YamlCustomizer[0]).load(is)));
    }

    public static void write(@Nullable Object pojo, @NonNull DataSink sink, YamlCustomizer ... customizers) {
        if (sink == null) {
            throw new NullPointerException("sink is marked non-null but is null");
        }
        if (pojo == null) {
            return;
        }
        sink.writeAll(os -> Try.run(() -> YamlUtils.createMapper(pojo.getClass(), customizers).dump(pojo, (Writer)new OutputStreamWriter((OutputStream)os))));
    }

    @Nullable
    public static String toStringUtf8(@Nullable Object pojo, YamlCustomizer ... customizers) {
        return pojo != null ? YamlUtils.createMapper(pojo.getClass(), customizers).dump(pojo) : null;
    }

    public static DumperOptions allowReadOnlyProperties(DumperOptions opts) {
        opts.setAllowReadOnlyProperties(true);
        return opts;
    }

    private static Yaml createMapper(Class<?> mappedType, YamlCustomizer ... customizers) {
        Yaml mapper = new Yaml((BaseConstructor)new Constructor(mappedType));
        DumperOptions options = new DumperOptions();
        options.setIndent(2);
        options.setLineBreak(DumperOptions.LineBreak.UNIX);
        for (YamlCustomizer customizer : customizers) {
            options = Optional.ofNullable((DumperOptions)customizer.apply(options)).orElse(options);
        }
        return mapper;
    }

    private YamlUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    @FunctionalInterface
    public static interface YamlCustomizer
    extends UnaryOperator<DumperOptions> {
    }
}

