/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.commons.io;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.module.jaxb.JaxbAnnotationModule;
import java.util.List;
import java.util.Optional;
import java.util.function.UnaryOperator;
import lombok.NonNull;
import org.apache.causeway.commons.functional.Try;
import org.apache.causeway.commons.io.DataSink;
import org.apache.causeway.commons.io.DataSource;
import org.springframework.lang.Nullable;

public final class JsonUtils {
    public static <T> Try<T> tryRead(@NonNull Class<T> mappedType, @Nullable String stringUtf8, JsonCustomizer ... customizers) {
        if (mappedType == null) {
            throw new NullPointerException("mappedType is marked non-null but is null");
        }
        return JsonUtils.tryRead(mappedType, DataSource.ofStringUtf8(stringUtf8), customizers);
    }

    public static <T> Try<T> tryRead(@NonNull Class<T> mappedType, @NonNull DataSource source, JsonCustomizer ... customizers) {
        if (mappedType == null) {
            throw new NullPointerException("mappedType is marked non-null but is null");
        }
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        return source.tryReadAll(is -> Try.call(() -> JsonUtils.createMapper(customizers).readValue(is, mappedType)));
    }

    public static <T> Try<List<T>> tryReadAsList(@NonNull Class<T> elementType, @NonNull DataSource source, JsonCustomizer ... customizers) {
        if (elementType == null) {
            throw new NullPointerException("elementType is marked non-null but is null");
        }
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        return source.tryReadAll(is -> Try.call(() -> {
            ObjectMapper mapper = JsonUtils.createMapper(customizers);
            CollectionType listFactory = mapper.getTypeFactory().constructCollectionType(List.class, elementType);
            return (List)mapper.readValue(is, (JavaType)listFactory);
        }));
    }

    public static void write(@Nullable Object pojo, @NonNull DataSink sink, JsonCustomizer ... customizers) {
        if (sink == null) {
            throw new NullPointerException("sink is marked non-null but is null");
        }
        if (pojo == null) {
            return;
        }
        sink.writeAll(os -> Try.run(() -> JsonUtils.createMapper(customizers).writeValue(os, pojo)));
    }

    @Nullable
    public static String toStringUtf8(@Nullable Object pojo, JsonCustomizer ... customizers) {
        return pojo != null ? JsonUtils.createMapper(customizers).writeValueAsString(pojo) : null;
    }

    public static ObjectMapper indentedOutput(ObjectMapper mapper) {
        return mapper.enable(SerializationFeature.INDENT_OUTPUT);
    }

    public static ObjectMapper onlyIncludeNonNull(ObjectMapper mapper) {
        return mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }

    public static ObjectMapper jaxbAnnotationSupport(ObjectMapper mapper) {
        return mapper.registerModule((Module)new JaxbAnnotationModule());
    }

    private static ObjectMapper createMapper(JsonCustomizer ... customizers) {
        ObjectMapper mapper = new ObjectMapper();
        for (JsonCustomizer customizer : customizers) {
            mapper = Optional.ofNullable((ObjectMapper)customizer.apply(mapper)).orElse(mapper);
        }
        return mapper;
    }

    private JsonUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    @FunctionalInterface
    public static interface JsonCustomizer
    extends UnaryOperator<ObjectMapper> {
    }
}

