/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.commons.internal.reflection;

import java.beans.BeanInfo;
import java.beans.FeatureDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.NonNull;
import org.apache.causeway.commons.collections.Can;
import org.apache.causeway.commons.functional.Try;
import org.apache.causeway.commons.internal.base._NullSafe;
import org.apache.causeway.commons.internal.base._Strings;
import org.apache.causeway.commons.internal.collections._Arrays;
import org.apache.causeway.commons.internal.context._Context;
import org.apache.causeway.commons.internal.functions._Predicates;
import org.springframework.core.ResolvableType;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.lang.Nullable;
import org.springframework.util.ClassUtils;

public final class _Reflect {
    public static boolean methodsSame(Method a, Method b) {
        if (!a.getName().equals(b.getName())) {
            return false;
        }
        if (a.getParameterCount() != b.getParameterCount()) {
            return false;
        }
        if (!_Arrays.testAllMatch(a.getParameters(), b.getParameters(), (p1, p2) -> p1.getType().equals(p2.getType()))) {
            return false;
        }
        return a.getReturnType().isAssignableFrom(b.getReturnType()) || b.getReturnType().isAssignableFrom(a.getReturnType());
    }

    public static Method methodsWhichIsOverridingTheOther(Method a, Method b) {
        Class<?> bType;
        Class<?> aType = a.getDeclaringClass();
        if (aType.equals(bType = b.getDeclaringClass())) {
            Class<?> bReturn;
            Class<?> aReturn = a.getReturnType();
            if (aReturn.equals(bReturn = b.getReturnType())) {
                return b;
            }
            return aReturn.isAssignableFrom(bReturn) ? b : a;
        }
        return aType.isAssignableFrom(bType) ? b : a;
    }

    public static int methodWeakCompare(Method a, Method b) {
        int c = a.getName().compareTo(b.getName());
        if (c != 0) {
            return c;
        }
        c = Integer.compare(a.getParameterCount(), b.getParameterCount());
        if (c != 0) {
            return c;
        }
        Parameter[] paramsA = a.getParameters();
        Parameter[] paramsB = b.getParameters();
        for (int i = 0; i < a.getParameterCount(); ++i) {
            c = _Reflect.typesCompare(paramsA[i].getType(), paramsB[i].getType());
            if (c == 0) continue;
            return c;
        }
        c = _Reflect.typesCompare(a.getReturnType(), b.getReturnType());
        if (c != 0) {
            return a.getReturnType().isAssignableFrom(b.getReturnType()) || b.getReturnType().isAssignableFrom(a.getReturnType()) ? 0 : c;
        }
        return 0;
    }

    public static int typesCompare(Class<?> a, Class<?> b) {
        return a.getName().compareTo(b.getName());
    }

    public static boolean canAccess(@Nullable AccessibleObject member, @Nullable Object obj) {
        return member != null && member.canAccess(obj);
    }

    public static boolean isPublicNonSynthetic(@Nullable Member member) {
        return member != null && Modifier.isPublic(member.getModifiers()) && !member.isSynthetic();
    }

    public static <T extends Member> Predicate<T> withName(@NonNull String memberName) {
        if (memberName == null) {
            throw new NullPointerException("memberName is marked non-null but is null");
        }
        return m -> m != null && memberName.equals(m.getName());
    }

    public static <T extends Member> Predicate<T> withPrefix(@NonNull String prefix) {
        if (prefix == null) {
            throw new NullPointerException("prefix is marked non-null but is null");
        }
        return m -> m != null && m.getName().startsWith(prefix);
    }

    public static Predicate<Method> withMethodParametersCount(int count) {
        return m -> m != null && m.getParameterTypes().length == count;
    }

    public static <T> Predicate<Field> withTypeAssignableTo(@NonNull Class<T> type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        return f -> f != null && type.isAssignableFrom(f.getType());
    }

    public static Stream<Field> streamFields(@Nullable Class<?> type, boolean ignoreAccess) {
        if (type == null) {
            return Stream.empty();
        }
        if (ignoreAccess) {
            return _NullSafe.stream(type.getDeclaredFields());
        }
        return _NullSafe.stream(type.getFields());
    }

    public static Stream<Field> streamAllFields(@Nullable Class<?> type, boolean ignoreAccess) {
        return _Reflect.streamTypeHierarchy(type, InterfacePolicy.EXCLUDE).filter(t -> !Object.class.equals(t)).flatMap(t -> _Reflect.streamFields(t, ignoreAccess));
    }

    public static Stream<Method> streamMethods(@Nullable Class<?> type, boolean ignoreAccess) {
        if (type == null) {
            return Stream.empty();
        }
        if (ignoreAccess) {
            return _NullSafe.stream(type.getDeclaredMethods());
        }
        return _NullSafe.stream(type.getMethods());
    }

    public static Stream<Method> streamInheritedMethods(Method method) {
        return _Reflect.streamAllMethods(method.getDeclaringClass(), true).filter(candidateMethod -> _Reflect.methodsSame(candidateMethod, method));
    }

    public static Stream<Method> streamAllMethods(@Nullable Class<?> type, boolean ignoreAccess) {
        return _Reflect.streamTypeHierarchy(type, InterfacePolicy.INCLUDE).filter(t -> !t.equals(Object.class)).flatMap(t -> _Reflect.streamMethods(t, ignoreAccess));
    }

    public static Stream<Class<?>> streamTypeHierarchy(@Nullable Class<?> type, @NonNull InterfacePolicy interfacePolicy) {
        if (interfacePolicy == null) {
            throw new NullPointerException("interfacePolicy is marked non-null but is null");
        }
        return interfacePolicy.isIncludeInterfaces() ? Stream.concat(Stream.iterate(type, Objects::nonNull, Class::getSuperclass), ClassUtils.getAllInterfacesForClassAsSet(type).stream()) : Stream.iterate(type, Objects::nonNull, Class::getSuperclass);
    }

    public static <T extends Annotation> T getAnnotation(Class<?> cls, Class<T> annotationClass) {
        Class<?>[] interfaces;
        if (cls == null) {
            return null;
        }
        T annotation = cls.getAnnotation(annotationClass);
        if (annotation != null) {
            return annotation;
        }
        Class<?> superclass = cls.getSuperclass();
        if (superclass != null) {
            try {
                T annotationFromSuperclass = _Reflect.getAnnotation(superclass, annotationClass);
                if (annotationFromSuperclass != null) {
                    return annotationFromSuperclass;
                }
            }
            catch (SecurityException annotationFromSuperclass) {
                // empty catch block
            }
        }
        for (Class<?> iface : interfaces = cls.getInterfaces()) {
            T annotationFromInterface = _Reflect.getAnnotation(iface, annotationClass);
            if (annotationFromInterface == null) continue;
            return annotationFromInterface;
        }
        return null;
    }

    public static <A extends Annotation> A getAnnotation(@NonNull Method method, @NonNull Class<A> annotationCls, boolean searchSupers, boolean ignoreAccess) {
        if (method == null) {
            throw new NullPointerException("method is marked non-null but is null");
        }
        if (annotationCls == null) {
            throw new NullPointerException("annotationCls is marked non-null but is null");
        }
        if (!ignoreAccess && !_Reflect.isPublicNonSynthetic(method)) {
            return null;
        }
        if (searchSupers) {
            return (A)AnnotationUtils.findAnnotation((Method)method, annotationCls);
        }
        return (A)AnnotationUtils.getAnnotation((Method)method, annotationCls);
    }

    public static boolean containsAnnotation(@Nullable Class<?> cls, @Nullable String annotationName) {
        if (cls == null || _Strings.isEmpty(annotationName)) {
            return false;
        }
        for (Annotation annot : cls.getAnnotations()) {
            if (!annot.annotationType().getName().equals(annotationName)) continue;
            return true;
        }
        return false;
    }

    public static Stream<PropertyDescriptor> streamGetters(@NonNull Class<?> cls) {
        if (cls == null) {
            throw new NullPointerException("cls is marked non-null but is null");
        }
        return Stream.of(Introspector.getBeanInfo(cls, Object.class).getPropertyDescriptors()).filter(pd -> pd.getReadMethod() != null);
    }

    public static Map<String, Method> getGettersByName(@NonNull Class<?> cls) {
        if (cls == null) {
            throw new NullPointerException("cls is marked non-null but is null");
        }
        return _Reflect.streamGetters(cls).collect(Collectors.toMap(FeatureDescriptor::getName, PropertyDescriptor::getReadMethod));
    }

    public static Method getGetter(Class<?> cls, String propertyName) throws IntrospectionException {
        BeanInfo beanInfo = Introspector.getBeanInfo(cls);
        for (PropertyDescriptor pd : beanInfo.getPropertyDescriptors()) {
            if (!pd.getName().equals(propertyName)) continue;
            return pd.getReadMethod();
        }
        return null;
    }

    public static Object readFromGetterOn(@NonNull Method getter, @NonNull Object target) {
        if (getter == null) {
            throw new NullPointerException("getter is marked non-null but is null");
        }
        if (target == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        return getter.invoke(target, new Object[0]);
    }

    public static Method getSetter(Class<?> cls, String propertyName) throws IntrospectionException {
        BeanInfo beanInfo = Introspector.getBeanInfo(cls);
        for (PropertyDescriptor pd : beanInfo.getPropertyDescriptors()) {
            if (!pd.getName().equals(propertyName)) continue;
            return pd.getWriteMethod();
        }
        return null;
    }

    public static void writeToSetterOn(@NonNull Method setter, @NonNull Object target, @NonNull Object value) {
        if (setter == null) {
            throw new NullPointerException("setter is marked non-null but is null");
        }
        if (target == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        setter.invoke(target, value);
    }

    public static Object getFieldOn(@NonNull Field field, @NonNull Object target) throws IllegalArgumentException, IllegalAccessException {
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        if (target == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        if (_Reflect.canAccess(field, target)) {
            return field.get(target);
        }
        try {
            field.setAccessible(true);
            Object object = field.get(target);
            return object;
        }
        finally {
            field.setAccessible(false);
        }
    }

    public static void setFieldOn(@NonNull Field field, @NonNull Object target, Object fieldValue) throws IllegalArgumentException, IllegalAccessException {
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        if (target == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        if (_Reflect.canAccess(field, target)) {
            field.set(target, fieldValue);
            return;
        }
        try {
            field.setAccessible(true);
            field.set(target, fieldValue);
        }
        finally {
            field.setAccessible(false);
        }
    }

    public static Try<Object> invokeMethodOn(@NonNull Method method, @NonNull Object target, Object ... args) {
        if (method == null) {
            throw new NullPointerException("method is marked non-null but is null");
        }
        if (target == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        return Try.call(() -> {
            if (_Reflect.canAccess(method, target)) {
                return method.invoke(target, args);
            }
            try {
                method.setAccessible(true);
                Object object = method.invoke(target, args);
                return object;
            }
            finally {
                method.setAccessible(false);
            }
        });
    }

    public static <T> Try<T> invokeConstructor(@NonNull Constructor<T> constructor, Object ... args) {
        if (constructor == null) {
            throw new NullPointerException("constructor is marked non-null but is null");
        }
        return Try.call(() -> {
            if (_Reflect.canAccess(constructor, null)) {
                return constructor.newInstance(args);
            }
            try {
                constructor.setAccessible(true);
                Object t = constructor.newInstance(args);
                return t;
            }
            finally {
                constructor.setAccessible(false);
            }
        });
    }

    public static Can<Constructor<?>> getDeclaredConstructors(Class<?> cls) {
        return Can.ofArray(cls.getDeclaredConstructors());
    }

    public static Can<Constructor<?>> getPublicConstructors(Class<?> cls) {
        return Can.ofArray(cls.getConstructors());
    }

    public static Optional<Method> lookupRegularMethodForSynthetic(@NonNull Method syntheticMethod) {
        if (syntheticMethod == null) {
            throw new NullPointerException("syntheticMethod is marked non-null but is null");
        }
        if (!syntheticMethod.isSynthetic()) {
            return Optional.of(syntheticMethod);
        }
        return _Reflect.streamTypeHierarchy(syntheticMethod.getDeclaringClass(), InterfacePolicy.INCLUDE).flatMap(type -> _NullSafe.stream(type.getDeclaredMethods())).filter(_Reflect.methodMatcherOnNameAndSignature(syntheticMethod)).filter(method -> !method.isSynthetic()).findFirst();
    }

    private static Predicate<Method> methodMatcherOnNameAndSignature(@NonNull Method ref) {
        if (ref == null) {
            throw new NullPointerException("ref is marked non-null but is null");
        }
        Class[] refSignature = ref.getParameterTypes();
        return other -> !ref.getName().equals(other.getName()) ? false : Arrays.equals(refSignature, other.getParameterTypes());
    }

    public static String methodToShortString(@NonNull Method method) {
        if (method == null) {
            throw new NullPointerException("method is marked non-null but is null");
        }
        return method.getName() + "(" + Stream.of(method.getParameterTypes()).map(parameterType -> parameterType.getTypeName()).collect(Collectors.joining(", ")) + ")";
    }

    public static boolean isNonStaticInnerMethod(@NonNull Method method) {
        if (method == null) {
            throw new NullPointerException("method is marked non-null but is null");
        }
        return ClassUtils.isInnerClass(method.getDeclaringClass());
    }

    private _Reflect() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static final class Filter {
        public static Predicate<Method> isGetter() {
            return method -> method != null && method.getParameterCount() == 0 && method.getReturnType() != Void.TYPE && (method.getName().startsWith("get") || method.getName().startsWith("is") && method.getReturnType() == Boolean.TYPE);
        }

        public static Predicate<Method> hasReturnType(Class<?> expectedReturnType) {
            return method -> expectedReturnType.isAssignableFrom(method.getReturnType());
        }

        public static Predicate<Method> hasReturnTypeAnyOf(Can<Class<?>> allowedReturnTypes) {
            return method -> allowedReturnTypes.stream().anyMatch(allowedReturnType -> allowedReturnType.isAssignableFrom(method.getReturnType()));
        }

        public static Predicate<Executable> isPublic() {
            return ex -> Modifier.isPublic(ex.getModifiers());
        }

        public static Predicate<Executable> paramCount(int paramCount) {
            return ex -> ex.getParameterCount() == paramCount;
        }

        public static Predicate<Executable> paramAssignableFrom(int paramIndex, Class<?> paramType) {
            return ex -> ex.getParameterTypes()[paramIndex].isAssignableFrom(paramType);
        }

        public static Predicate<Executable> paramSignatureMatch(Class<?>[] matchingParamTypes) {
            return ex -> {
                if (matchingParamTypes != null) {
                    Class<?>[] parameterTypes = ex.getParameterTypes();
                    if (matchingParamTypes.length != parameterTypes.length) {
                        return false;
                    }
                    for (int c = 0; c < matchingParamTypes.length; ++c) {
                        if (matchingParamTypes[c] == null || matchingParamTypes[c] == parameterTypes[c]) continue;
                        return false;
                    }
                }
                return true;
            };
        }

        public static Predicate<Executable> paramAssignableFromValue(int paramIndex, @Nullable Object value) {
            if (value == null) {
                return _Predicates.alwaysTrue();
            }
            return ex -> ex.getParameterTypes()[paramIndex].isAssignableFrom(value.getClass());
        }

        private Filter() {
            throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
        }
    }

    public static final class ConstructorAndImplementingClass {
        @NonNull
        private final Constructor<?> constructor;
        @NonNull
        private final Class<?> implementingClass;

        public Try<ConstructorAndImplementingClass> adopt(@NonNull ClassLoader classLoader) {
            if (classLoader == null) {
                throw new NullPointerException("classLoader is marked non-null but is null");
            }
            try {
                Class<?> ownerReloaded = Class.forName(this.implementingClass.getName(), true, classLoader);
                Constructor<?> methodReloaded = ownerReloaded.getConstructor(this.constructor.getParameterTypes());
                return Try.success(ConstructorAndImplementingClass.of(methodReloaded, ownerReloaded));
            }
            catch (Throwable e) {
                return Try.failure(e);
            }
        }

        public Try<ConstructorAndImplementingClass> adoptIntoDefaultClassLoader() {
            return this.adopt(_Context.getDefaultClassLoader());
        }

        public Class<?> resolveFirstGenericTypeArgumentOnParameter(int paramIndex) {
            return ConstructorAndImplementingClass.genericTypeArg(ResolvableType.forConstructorParameter(this.constructor, (int)paramIndex, this.implementingClass)).toClass();
        }

        private static ResolvableType genericTypeArg(ResolvableType nonScalar) {
            ResolvableType genericTypeArg = nonScalar.isArray() ? nonScalar.getComponentType() : nonScalar.getGeneric(new int[]{0});
            return genericTypeArg;
        }

        private ConstructorAndImplementingClass(@NonNull Constructor<?> constructor, @NonNull Class<?> implementingClass) {
            if (constructor == null) {
                throw new NullPointerException("constructor is marked non-null but is null");
            }
            if (implementingClass == null) {
                throw new NullPointerException("implementingClass is marked non-null but is null");
            }
            this.constructor = constructor;
            this.implementingClass = implementingClass;
        }

        public static ConstructorAndImplementingClass of(@NonNull Constructor<?> constructor, @NonNull Class<?> implementingClass) {
            if (constructor == null) {
                throw new NullPointerException("constructor is marked non-null but is null");
            }
            if (implementingClass == null) {
                throw new NullPointerException("implementingClass is marked non-null but is null");
            }
            return new ConstructorAndImplementingClass(constructor, implementingClass);
        }

        @NonNull
        public Constructor<?> getConstructor() {
            return this.constructor;
        }

        @NonNull
        public Class<?> getImplementingClass() {
            return this.implementingClass;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ConstructorAndImplementingClass)) {
                return false;
            }
            ConstructorAndImplementingClass other = (ConstructorAndImplementingClass)o;
            Constructor<?> this$constructor = this.getConstructor();
            Constructor<?> other$constructor = other.getConstructor();
            if (this$constructor == null ? other$constructor != null : !((Object)this$constructor).equals(other$constructor)) {
                return false;
            }
            Class<?> this$implementingClass = this.getImplementingClass();
            Class<?> other$implementingClass = other.getImplementingClass();
            return !(this$implementingClass == null ? other$implementingClass != null : !this$implementingClass.equals(other$implementingClass));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Constructor<?> $constructor = this.getConstructor();
            result = result * 59 + ($constructor == null ? 43 : ((Object)$constructor).hashCode());
            Class<?> $implementingClass = this.getImplementingClass();
            result = result * 59 + ($implementingClass == null ? 43 : $implementingClass.hashCode());
            return result;
        }

        public String toString() {
            return "_Reflect.ConstructorAndImplementingClass(constructor=" + this.getConstructor() + ", implementingClass=" + this.getImplementingClass() + ")";
        }
    }

    public static final class MethodAndImplementingClass {
        @NonNull
        private final Method method;
        @NonNull
        private final Class<?> implementingClass;

        public Try<MethodAndImplementingClass> adopt(@NonNull ClassLoader classLoader) {
            if (classLoader == null) {
                throw new NullPointerException("classLoader is marked non-null but is null");
            }
            try {
                Class<?> ownerReloaded = Class.forName(this.implementingClass.getName(), true, classLoader);
                Method methodReloaded = ownerReloaded.getMethod(this.method.getName(), this.method.getParameterTypes());
                return Try.success(MethodAndImplementingClass.of(methodReloaded, ownerReloaded));
            }
            catch (Throwable e) {
                return Try.failure(e);
            }
        }

        public Try<MethodAndImplementingClass> adoptIntoDefaultClassLoader() {
            return this.adopt(_Context.getDefaultClassLoader());
        }

        public Class<?> resolveFirstGenericTypeArgumentOnMethodReturn() {
            return MethodAndImplementingClass.genericTypeArg(ResolvableType.forMethodReturnType((Method)this.method, this.implementingClass)).toClass();
        }

        public Class<?> resolveFirstGenericTypeArgumentOnParameter(int paramIndex) {
            return MethodAndImplementingClass.genericTypeArg(ResolvableType.forMethodParameter((Method)this.method, (int)paramIndex, this.implementingClass)).toClass();
        }

        private static ResolvableType genericTypeArg(ResolvableType nonScalar) {
            ResolvableType genericTypeArg = nonScalar.isArray() ? nonScalar.getComponentType() : nonScalar.getGeneric(new int[]{0});
            return genericTypeArg;
        }

        private MethodAndImplementingClass(@NonNull Method method, @NonNull Class<?> implementingClass) {
            if (method == null) {
                throw new NullPointerException("method is marked non-null but is null");
            }
            if (implementingClass == null) {
                throw new NullPointerException("implementingClass is marked non-null but is null");
            }
            this.method = method;
            this.implementingClass = implementingClass;
        }

        public static MethodAndImplementingClass of(@NonNull Method method, @NonNull Class<?> implementingClass) {
            if (method == null) {
                throw new NullPointerException("method is marked non-null but is null");
            }
            if (implementingClass == null) {
                throw new NullPointerException("implementingClass is marked non-null but is null");
            }
            return new MethodAndImplementingClass(method, implementingClass);
        }

        @NonNull
        public Method getMethod() {
            return this.method;
        }

        @NonNull
        public Class<?> getImplementingClass() {
            return this.implementingClass;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MethodAndImplementingClass)) {
                return false;
            }
            MethodAndImplementingClass other = (MethodAndImplementingClass)o;
            Method this$method = this.getMethod();
            Method other$method = other.getMethod();
            if (this$method == null ? other$method != null : !((Object)this$method).equals(other$method)) {
                return false;
            }
            Class<?> this$implementingClass = this.getImplementingClass();
            Class<?> other$implementingClass = other.getImplementingClass();
            return !(this$implementingClass == null ? other$implementingClass != null : !this$implementingClass.equals(other$implementingClass));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Method $method = this.getMethod();
            result = result * 59 + ($method == null ? 43 : ((Object)$method).hashCode());
            Class<?> $implementingClass = this.getImplementingClass();
            result = result * 59 + ($implementingClass == null ? 43 : $implementingClass.hashCode());
            return result;
        }

        public String toString() {
            return "_Reflect.MethodAndImplementingClass(method=" + this.getMethod() + ", implementingClass=" + this.getImplementingClass() + ")";
        }
    }

    public static enum InterfacePolicy {
        EXCLUDE,
        INCLUDE;


        public boolean isIncludeInterfaces() {
            return this == INCLUDE;
        }
    }

    public static enum TypeHierarchyPolicy {
        EXCLUDE,
        INCLUDE;


        public boolean isIncludeTypeHierarchy() {
            return this == INCLUDE;
        }
    }
}

