/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.commons.internal.reflection;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.util.Optional;
import lombok.NonNull;
import org.apache.causeway.commons.internal.base._NullSafe;
import org.apache.causeway.commons.internal.exceptions._Exceptions;
import org.apache.causeway.commons.internal.reflection._Annotations;
import org.apache.causeway.commons.internal.reflection._Reflect;

public final class _MethodFacades {
    public static MethodFacade paramsAsTuple(@NonNull Method method, @NonNull Constructor<?> patConstructor) {
        if (method == null) {
            throw new NullPointerException("method is marked non-null but is null");
        }
        if (patConstructor == null) {
            throw new NullPointerException("patConstructor is marked non-null but is null");
        }
        return new ParamsAsTupleMethod(patConstructor, _MethodFacades.regularMethodForSyntheticElseFail(method));
    }

    public static MethodFacade regular(Method method) {
        return new RegularMethod(_MethodFacades.regularMethodForSyntheticElseFail(method));
    }

    private static Method regularMethodForSyntheticElseFail(Method method) {
        return _Reflect.lookupRegularMethodForSynthetic(method).orElseThrow(() -> _Exceptions.illegalArgument("cannot resolve syntetic method %s to a regular one", method));
    }

    private _MethodFacades() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    private static final class ParamsAsTupleMethod
    implements MethodFacade {
        private final Constructor<?> patConstructor;
        private final Method method;

        @Override
        public Class<?>[] getParameterTypes() {
            return this.patConstructor.getParameterTypes();
        }

        @Override
        public Class<?> getParameterType(int paramNum) {
            return this.patConstructor.getParameterTypes()[paramNum];
        }

        @Override
        public int getParameterCount() {
            return this.patConstructor.getParameterCount();
        }

        @Override
        public Class<?> getReturnType() {
            return this.method.getReturnType();
        }

        @Override
        public String getName() {
            return this.method.getName();
        }

        @Override
        public String getParameterName(int paramNum) {
            return this.patConstructor.getParameters()[paramNum].getName();
        }

        @Override
        public Class<?> getDeclaringClass() {
            return this.method.getDeclaringClass();
        }

        @Override
        public Optional<Method> asMethod() {
            return Optional.empty();
        }

        @Override
        public Method asMethodForIntrospection() {
            return this.method;
        }

        @Override
        public Executable asExecutable() {
            return this.patConstructor;
        }

        @Override
        public Object[] getArguments(Object[] executionParameters) {
            return new Object[]{this.patConstructor.newInstance(executionParameters)};
        }

        @Override
        public <A extends Annotation> Optional<A> synthesize(Class<A> annotationType) {
            return _Annotations.synthesize(this.method, annotationType);
        }

        @Override
        public <A extends Annotation> Optional<A> synthesizeOnParameter(Class<A> annotationType, int paramNum) {
            return _Annotations.synthesize(this.patConstructor.getParameters()[paramNum], annotationType);
        }

        @Override
        public boolean isAnnotatedAsNullable() {
            return _NullSafe.stream(this.method.getAnnotations()).map(annot -> annot.annotationType().getSimpleName()).anyMatch(name -> name.equals("Nullable"));
        }

        public String toString() {
            return this.method.toString();
        }

        public ParamsAsTupleMethod(Constructor<?> patConstructor, Method method) {
            this.patConstructor = patConstructor;
            this.method = method;
        }

        public Constructor<?> getPatConstructor() {
            return this.patConstructor;
        }

        public Method getMethod() {
            return this.method;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ParamsAsTupleMethod)) {
                return false;
            }
            ParamsAsTupleMethod other = (ParamsAsTupleMethod)o;
            Constructor<?> this$patConstructor = this.getPatConstructor();
            Constructor<?> other$patConstructor = other.getPatConstructor();
            if (this$patConstructor == null ? other$patConstructor != null : !((Object)this$patConstructor).equals(other$patConstructor)) {
                return false;
            }
            Method this$method = this.getMethod();
            Method other$method = other.getMethod();
            return !(this$method == null ? other$method != null : !((Object)this$method).equals(other$method));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Constructor<?> $patConstructor = this.getPatConstructor();
            result = result * 59 + ($patConstructor == null ? 43 : ((Object)$patConstructor).hashCode());
            Method $method = this.getMethod();
            result = result * 59 + ($method == null ? 43 : ((Object)$method).hashCode());
            return result;
        }
    }

    private static final class RegularMethod
    implements MethodFacade {
        private final Method method;

        @Override
        public Class<?> getDeclaringClass() {
            return this.method.getDeclaringClass();
        }

        @Override
        public int getParameterCount() {
            return this.method.getParameterCount();
        }

        @Override
        public Class<?>[] getParameterTypes() {
            return this.method.getParameterTypes();
        }

        @Override
        public Class<?> getParameterType(int paramNum) {
            return this.method.getParameterTypes()[paramNum];
        }

        @Override
        public String getName() {
            return this.method.getName();
        }

        @Override
        public Class<?> getReturnType() {
            return this.method.getReturnType();
        }

        @Override
        public Optional<Method> asMethod() {
            return Optional.of(this.method);
        }

        @Override
        public Executable asExecutable() {
            return this.method;
        }

        @Override
        public <A extends Annotation> Optional<A> synthesize(Class<A> annotationType) {
            return _Annotations.synthesize(this.method, annotationType);
        }

        @Override
        public Method asMethodForIntrospection() {
            return this.method;
        }

        @Override
        public String getParameterName(int paramNum) {
            return this.method.getParameters()[paramNum].getName();
        }

        @Override
        public <A extends Annotation> Optional<A> synthesizeOnParameter(Class<A> annotationType, int paramNum) {
            return _Annotations.synthesize(this.method.getParameters()[paramNum], annotationType);
        }

        @Override
        public Object[] getArguments(Object[] executionParameters) {
            return executionParameters;
        }

        @Override
        public boolean isAnnotatedAsNullable() {
            return _NullSafe.stream(this.method.getAnnotations()).map(annot -> annot.annotationType().getSimpleName()).anyMatch(name -> name.equals("Nullable"));
        }

        public String toString() {
            return this.method.toString();
        }

        public RegularMethod(Method method) {
            this.method = method;
        }

        public Method getMethod() {
            return this.method;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RegularMethod)) {
                return false;
            }
            RegularMethod other = (RegularMethod)o;
            Method this$method = this.getMethod();
            Method other$method = other.getMethod();
            return !(this$method == null ? other$method != null : !((Object)this$method).equals(other$method));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Method $method = this.getMethod();
            result = result * 59 + ($method == null ? 43 : ((Object)$method).hashCode());
            return result;
        }
    }

    public static interface MethodFacade {
        public Class<?>[] getParameterTypes();

        public Class<?> getParameterType(int var1);

        public int getParameterCount();

        public Class<?> getReturnType();

        public String getName();

        public String getParameterName(int var1);

        public Class<?> getDeclaringClass();

        public Optional<Method> asMethod();

        public Method asMethodForIntrospection();

        public Executable asExecutable();

        public Object[] getArguments(Object[] var1);

        public <A extends Annotation> Optional<A> synthesize(Class<A> var1);

        public <A extends Annotation> Optional<A> synthesizeOnParameter(Class<A> var1, int var2);

        default public Method asMethodElseFail() {
            return this.asMethod().orElseThrow(() -> _Exceptions.unrecoverable("Framework Bug: unexpeced method-facade, regular variant expected: %s", this.asMethodForIntrospection()));
        }

        public boolean isAnnotatedAsNullable();
    }
}

