/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.commons.internal.reflection;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.causeway.commons.collections.Can;
import org.apache.causeway.commons.internal._Constants;
import org.apache.causeway.commons.internal.base._Casts;
import org.apache.causeway.commons.internal.base._Strings;
import org.apache.causeway.commons.internal.collections._Arrays;
import org.apache.causeway.commons.internal.context._Context;
import org.apache.causeway.commons.internal.reflection._Annotations;
import org.apache.causeway.commons.internal.reflection._Reflect;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.lang.Nullable;
import org.springframework.util.ReflectionUtils;

public final class _ClassCache
implements AutoCloseable {
    private final Map<Class<?>, ClassModel> inspectedTypes = new HashMap();

    public static _ClassCache getInstance() {
        return _Context.computeIfAbsent(_ClassCache.class, _ClassCache::new);
    }

    public static void invalidate() {
        _Context.put(_ClassCache.class, new _ClassCache(), true);
    }

    public void add(Class<?> type) {
        this.inspectType(type);
    }

    public boolean hasJaxbRootElementSemantics(Class<?> type) {
        return this.inspectType(type).hasJaxbRootElementSemantics;
    }

    public <T> Stream<Constructor<T>> streamPublicConstructors(Class<T> type) {
        return (Stream)_Casts.uncheckedCast(this.inspectType(type).publicConstructorsByKey.values().stream());
    }

    public <T> Stream<Constructor<T>> streamPublicConstructorsWithInjectSemantics(Class<T> type) {
        return (Stream)_Casts.uncheckedCast(this.inspectType(type).constructorsWithInjectSemanticsByKey.values().stream());
    }

    public Optional<Constructor<?>> lookupPublicConstructor(Class<?> type, Class<?>[] paramTypes) {
        return Optional.ofNullable(this.lookupConstructor(false, type, paramTypes));
    }

    public Stream<Method> streamPostConstructMethods(Class<?> type) {
        return this.inspectType(type).postConstructMethodsByKey.values().stream();
    }

    public Method lookupPublicMethod(Class<?> type, String name, Class<?>[] paramTypes) {
        return this.lookupMethod(false, type, name, paramTypes);
    }

    public Method lookupPublicOrDeclaredMethod(Class<?> type, String name, Class<?>[] paramTypes) {
        return this.lookupMethod(true, type, name, paramTypes);
    }

    public Stream<Method> streamPublicMethods(Class<?> type) {
        return this.inspectType(type).publicMethodsByKey.values().stream();
    }

    public Stream<Method> streamPublicOrDeclaredMethods(Class<?> type) {
        ClassModel classModel = this.inspectType(type);
        return Stream.concat(classModel.publicMethodsByKey.values().stream(), classModel.nonPublicDeclaredMethodsByKey.values().stream());
    }

    public Stream<Method> streamDeclaredMethods(Class<?> type) {
        return this.inspectType(type).declaredMethods.stream();
    }

    public Stream<Field> streamDeclaredFields(Class<?> type) {
        return this.inspectType(type).declaredFields.stream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Stream<Method> streamDeclaredMethodsHaving(Class<?> type, String attributeName, Predicate<Method> filter) {
        ClassModel classModel = this.inspectType(type);
        Map<String, Can<Method>> map = classModel.declaredMethodsByAttribute;
        synchronized (map) {
            return classModel.declaredMethodsByAttribute.computeIfAbsent(attributeName, key -> classModel.declaredMethods.filter(filter)).stream();
        }
    }

    public Optional<Method> getterForField(Class<?> type, Field field) {
        String capitalizedFieldName = _Strings.capitalize(field.getName());
        return Stream.of("get", "is").map(prefix -> prefix + capitalizedFieldName).map(methodName -> this.lookupPublicOrDeclaredMethod(type, (String)methodName, _Constants.emptyClasses)).filter(_Reflect.Filter.isGetter()).findFirst();
    }

    public Optional<Field> fieldForGetter(Class<?> type, Method getterCandidate) {
        return Optional.ofNullable(_ClassCache.findFieldForGetter(getterCandidate));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws Exception {
        Map<Class<?>, ClassModel> map = this.inspectedTypes;
        synchronized (map) {
            this.inspectedTypes.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClassModel inspectType(Class<?> type) {
        Map<Class<?>, ClassModel> map = this.inspectedTypes;
        synchronized (map) {
            return this.inspectedTypes.computeIfAbsent(type, __ -> {
                Object key;
                Constructor<?>[] publicConstr = type.getConstructors();
                Field[] declaredFields = type.getDeclaredFields();
                Can<Method> declaredMethods = Can.ofStream(_Reflect.streamAllMethods(type, true));
                Method[] publicMethods = type.getMethods();
                ClassModel model = new ClassModel(Can.ofArray(declaredFields), declaredMethods, _Annotations.isPresent(type, XmlRootElement.class));
                for (Constructor<?> constr : publicConstr) {
                    key = ConstructorKey.of(type, constr);
                    model.publicConstructorsByKey.put((ConstructorKey)key, constr);
                    if (!this.isInjectSemantics(constr)) continue;
                    model.constructorsWithInjectSemanticsByKey.put((ConstructorKey)key, constr);
                }
                for (Method method : declaredMethods) {
                    MethodKey key2;
                    Method methodToKeep;
                    if (Modifier.isStatic(method.getModifiers()) || !this.isPostConstruct(methodToKeep = _ClassCache.putIntoMapHonoringOverridingRelation(model.nonPublicDeclaredMethodsByKey, key2 = MethodKey.of(type, method), method))) continue;
                    model.postConstructMethodsByKey.put(key2, methodToKeep);
                }
                for (Method method : publicMethods) {
                    if (Modifier.isStatic(method.getModifiers())) continue;
                    key = MethodKey.of(type, method);
                    _ClassCache.putIntoMapHonoringOverridingRelation(model.publicMethodsByKey, (MethodKey)key, method);
                    model.nonPublicDeclaredMethodsByKey.remove(key);
                }
                return model;
            });
        }
    }

    private static Method putIntoMapHonoringOverridingRelation(Map<MethodKey, Method> map, MethodKey key, Method method) {
        Method methodWithSameKey = map.get(key);
        Method methodToKeep = methodWithSameKey == null ? method : _Reflect.methodsWhichIsOverridingTheOther(methodWithSameKey, method);
        map.put(key, methodToKeep);
        return methodToKeep;
    }

    private boolean isInjectSemantics(Constructor<?> con) {
        return _Annotations.synthesize(con, Inject.class).isPresent() || _Annotations.synthesize(con, Autowired.class).map(annot -> annot.required()).orElse(false) != false;
    }

    private boolean isPostConstruct(Method method) {
        return Void.TYPE.equals(method.getReturnType()) && method.getParameterCount() == 0 ? _Annotations.synthesize(method, PostConstruct.class).isPresent() : false;
    }

    private Constructor<?> lookupConstructor(boolean includeDeclaredConstructors, Class<?> type, Class<?>[] paramTypes) {
        ClassModel model = this.inspectType(type);
        ConstructorKey key = ConstructorKey.of(type, _Arrays.emptyToNull(paramTypes));
        Constructor<?> publicConstructor = model.publicConstructorsByKey.get(key);
        if (publicConstructor != null) {
            return publicConstructor;
        }
        return null;
    }

    private Method lookupMethod(boolean includeDeclaredMethods, Class<?> type, String name, Class<?>[] paramTypes) {
        ClassModel model = this.inspectType(type);
        MethodKey key = MethodKey.of(type, name, _Arrays.emptyToNull(paramTypes));
        Method publicMethod = model.publicMethodsByKey.get(key);
        if (publicMethod != null) {
            return publicMethod;
        }
        if (includeDeclaredMethods) {
            return model.nonPublicDeclaredMethodsByKey.get(key);
        }
        return null;
    }

    private static Field findFieldForGetter(Method getterCandidate) {
        if (ReflectionUtils.isObjectMethod((Method)getterCandidate)) {
            return null;
        }
        String fieldNameCandidate = _ClassCache.fieldNameForGetter(getterCandidate);
        if (fieldNameCandidate == null) {
            return null;
        }
        Class<?> declaringClass = getterCandidate.getDeclaringClass();
        return ReflectionUtils.findField(declaringClass, (String)fieldNameCandidate);
    }

    private static String fieldNameForGetter(Method getter) {
        if (getter.getParameterCount() > 0) {
            return null;
        }
        if (getter.getReturnType() == Void.TYPE) {
            return null;
        }
        String methodName = getter.getName();
        String fieldName = null;
        if (methodName.startsWith("is") && methodName.length() > 2) {
            fieldName = methodName.substring(2);
        } else if (methodName.startsWith("get") && methodName.length() > 3) {
            fieldName = methodName.substring(3);
        } else {
            return null;
        }
        return _Strings.decapitalize(fieldName);
    }

    private _ClassCache() {
    }

    private static final class MethodKey {
        private final Class<?> type;
        private final String name;
        @Nullable
        private final Class<?>[] paramTypes;

        public static MethodKey of(Class<?> type, Method method) {
            return MethodKey.of(type, method.getName(), _Arrays.emptyToNull(method.getParameterTypes()));
        }

        private MethodKey(Class<?> type, String name, @Nullable Class<?>[] paramTypes) {
            this.type = type;
            this.name = name;
            this.paramTypes = paramTypes;
        }

        public static MethodKey of(Class<?> type, String name, @Nullable Class<?>[] paramTypes) {
            return new MethodKey(type, name, paramTypes);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MethodKey)) {
                return false;
            }
            MethodKey other = (MethodKey)o;
            Class<?> this$type = this.type;
            Class<?> other$type = other.type;
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            String this$name = this.name;
            String other$name = other.name;
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            return Arrays.deepEquals(this.paramTypes, other.paramTypes);
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Class<?> $type = this.type;
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            String $name = this.name;
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            result = result * 59 + Arrays.deepHashCode(this.paramTypes);
            return result;
        }
    }

    private static final class ConstructorKey {
        private final Class<?> type;
        @Nullable
        private final Class<?>[] paramTypes;

        public static ConstructorKey of(Class<?> type, Constructor<?> constructor) {
            return ConstructorKey.of(type, _Arrays.emptyToNull(constructor.getParameterTypes()));
        }

        private ConstructorKey(Class<?> type, @Nullable Class<?>[] paramTypes) {
            this.type = type;
            this.paramTypes = paramTypes;
        }

        public static ConstructorKey of(Class<?> type, @Nullable Class<?>[] paramTypes) {
            return new ConstructorKey(type, paramTypes);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ConstructorKey)) {
                return false;
            }
            ConstructorKey other = (ConstructorKey)o;
            Class<?> this$type = this.type;
            Class<?> other$type = other.type;
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            return Arrays.deepEquals(this.paramTypes, other.paramTypes);
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Class<?> $type = this.type;
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            result = result * 59 + Arrays.deepHashCode(this.paramTypes);
            return result;
        }
    }

    private static class ClassModel {
        private final Can<Field> declaredFields;
        private final Can<Method> declaredMethods;
        private final Map<ConstructorKey, Constructor<?>> publicConstructorsByKey = new HashMap();
        private final Map<ConstructorKey, Constructor<?>> constructorsWithInjectSemanticsByKey = new HashMap();
        private final Map<MethodKey, Method> publicMethodsByKey = new HashMap<MethodKey, Method>();
        private final Map<MethodKey, Method> postConstructMethodsByKey = new HashMap<MethodKey, Method>();
        private final Map<MethodKey, Method> nonPublicDeclaredMethodsByKey = new HashMap<MethodKey, Method>();
        private final Map<String, Can<Method>> declaredMethodsByAttribute = new HashMap<String, Can<Method>>();
        private final boolean hasJaxbRootElementSemantics;

        public ClassModel(Can<Field> declaredFields, Can<Method> declaredMethods, boolean hasJaxbRootElementSemantics) {
            this.declaredFields = declaredFields;
            this.declaredMethods = declaredMethods;
            this.hasJaxbRootElementSemantics = hasJaxbRootElementSemantics;
        }
    }
}

