/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.commons.internal.html;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.causeway.commons.internal.base._NullSafe;
import org.apache.causeway.commons.internal.base._Strings;

public final class _BootstrapBadge {
    private final String caption;
    private final String faIcon;
    private final String tooltip;
    private final List<String> cssClasses;

    public String toHtml() {
        StringBuilder sb = new StringBuilder();
        sb.append("<span ").append("class=\"").append(this.classesLiteral()).append("\"");
        if (_Strings.isNotEmpty(this.getTooltip())) {
            sb.append(" data-bs-container=\"body\" data-bs-toggle=\"tooltip\" title=\"" + this.getTooltip() + "\"");
        }
        sb.append(">");
        if (_Strings.isNotEmpty(this.getFaIcon())) {
            sb.append("<i class=\"").append(this.getFaIcon()).append("\"></i>");
        }
        sb.append(this.getCaption()).append("</span>");
        return sb.toString();
    }

    private String classesLiteral() {
        return Stream.concat(Stream.of("badge", "bg-light"), _NullSafe.stream(this.cssClasses)).collect(Collectors.joining(" "));
    }

    _BootstrapBadge(String caption, String faIcon, String tooltip, List<String> cssClasses) {
        this.caption = caption;
        this.faIcon = faIcon;
        this.tooltip = tooltip;
        this.cssClasses = cssClasses;
    }

    public static _BootstrapBadgeBuilder builder() {
        return new _BootstrapBadgeBuilder();
    }

    public String getCaption() {
        return this.caption;
    }

    public String getFaIcon() {
        return this.faIcon;
    }

    public String getTooltip() {
        return this.tooltip;
    }

    public List<String> getCssClasses() {
        return this.cssClasses;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof _BootstrapBadge)) {
            return false;
        }
        _BootstrapBadge other = (_BootstrapBadge)o;
        String this$caption = this.getCaption();
        String other$caption = other.getCaption();
        if (this$caption == null ? other$caption != null : !this$caption.equals(other$caption)) {
            return false;
        }
        String this$faIcon = this.getFaIcon();
        String other$faIcon = other.getFaIcon();
        if (this$faIcon == null ? other$faIcon != null : !this$faIcon.equals(other$faIcon)) {
            return false;
        }
        String this$tooltip = this.getTooltip();
        String other$tooltip = other.getTooltip();
        if (this$tooltip == null ? other$tooltip != null : !this$tooltip.equals(other$tooltip)) {
            return false;
        }
        List<String> this$cssClasses = this.getCssClasses();
        List<String> other$cssClasses = other.getCssClasses();
        return !(this$cssClasses == null ? other$cssClasses != null : !((Object)this$cssClasses).equals(other$cssClasses));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $caption = this.getCaption();
        result = result * 59 + ($caption == null ? 43 : $caption.hashCode());
        String $faIcon = this.getFaIcon();
        result = result * 59 + ($faIcon == null ? 43 : $faIcon.hashCode());
        String $tooltip = this.getTooltip();
        result = result * 59 + ($tooltip == null ? 43 : $tooltip.hashCode());
        List<String> $cssClasses = this.getCssClasses();
        result = result * 59 + ($cssClasses == null ? 43 : ((Object)$cssClasses).hashCode());
        return result;
    }

    public String toString() {
        return "_BootstrapBadge(caption=" + this.getCaption() + ", faIcon=" + this.getFaIcon() + ", tooltip=" + this.getTooltip() + ", cssClasses=" + this.getCssClasses() + ")";
    }

    public static class _BootstrapBadgeBuilder {
        private String caption;
        private String faIcon;
        private String tooltip;
        private ArrayList<String> cssClasses;

        _BootstrapBadgeBuilder() {
        }

        public _BootstrapBadgeBuilder caption(String caption) {
            this.caption = caption;
            return this;
        }

        public _BootstrapBadgeBuilder faIcon(String faIcon) {
            this.faIcon = faIcon;
            return this;
        }

        public _BootstrapBadgeBuilder tooltip(String tooltip) {
            this.tooltip = tooltip;
            return this;
        }

        public _BootstrapBadgeBuilder cssClass(String cssClass) {
            if (this.cssClasses == null) {
                this.cssClasses = new ArrayList();
            }
            this.cssClasses.add(cssClass);
            return this;
        }

        public _BootstrapBadgeBuilder cssClasses(Collection<? extends String> cssClasses) {
            if (cssClasses == null) {
                throw new NullPointerException("cssClasses cannot be null");
            }
            if (this.cssClasses == null) {
                this.cssClasses = new ArrayList();
            }
            this.cssClasses.addAll(cssClasses);
            return this;
        }

        public _BootstrapBadgeBuilder clearCssClasses() {
            if (this.cssClasses != null) {
                this.cssClasses.clear();
            }
            return this;
        }

        public _BootstrapBadge build() {
            List<String> cssClasses;
            switch (this.cssClasses == null ? 0 : this.cssClasses.size()) {
                case 0: {
                    cssClasses = Collections.emptyList();
                    break;
                }
                case 1: {
                    cssClasses = Collections.singletonList(this.cssClasses.get(0));
                    break;
                }
                default: {
                    cssClasses = Collections.unmodifiableList(new ArrayList<String>(this.cssClasses));
                }
            }
            return new _BootstrapBadge(this.caption, this.faIcon, this.tooltip, cssClasses);
        }

        public String toString() {
            return "_BootstrapBadge._BootstrapBadgeBuilder(caption=" + this.caption + ", faIcon=" + this.faIcon + ", tooltip=" + this.tooltip + ", cssClasses=" + this.cssClasses + ")";
        }
    }
}

