/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.commons.internal.hardening;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Optional;
import org.apache.causeway.commons.internal.base._Strings;
import org.jsoup.Jsoup;
import org.jsoup.safety.Safelist;
import org.springframework.lang.Nullable;

public class _Hardening {
    public static Optional<URL> toUrlWithXssGuard(@Nullable String untrustedUrl) {
        if (_Strings.isEmpty(untrustedUrl)) {
            return Optional.empty();
        }
        if (_Strings.condenseWhitespaces(untrustedUrl.toLowerCase(), "").contains("javascript:")) {
            throw new IllegalArgumentException("Not parseable as an URL ('" + untrustedUrl + "').");
        }
        try {
            return Optional.of(new URL(untrustedUrl));
        }
        catch (MalformedURLException ex) {
            throw new IllegalArgumentException("Not parseable as an URL ('" + untrustedUrl + "').", ex);
        }
    }

    public static String toSafeHtml(@Nullable String untrustedHtml) {
        if (_Strings.isEmpty(untrustedHtml)) {
            return untrustedHtml;
        }
        return Jsoup.clean((String)untrustedHtml, (Safelist)Safelist.basic());
    }
}

