/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.commons.internal.binding;

import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import org.apache.causeway.commons.internal.base._Lazy;
import org.apache.causeway.commons.internal.binding._BindableAbstract;

public class _Observables {
    public static <T> LazyObservable<T> lazy(Supplier<T> factory) {
        return new LazyObservable<T>(factory);
    }

    public static BooleanObservable lazyBoolean(BooleanSupplier factory) {
        return new BooleanObservable(factory);
    }

    public static class BooleanObservable
    extends LazyObservable<Boolean> {
        public BooleanObservable(BooleanSupplier factory) {
            super(() -> factory.getAsBoolean());
        }

        public boolean booleanValue() {
            return (Boolean)super.getValue();
        }
    }

    public static class LazyObservable<T>
    extends _BindableAbstract<T> {
        private final _Lazy<T> lazyValue;

        public LazyObservable(Supplier<T> factory) {
            this.lazyValue = _Lazy.threadSafe(factory);
        }

        @Override
        public T getValue() {
            return this.lazyValue.get();
        }

        public void invalidate() {
            this.lazyValue.clear();
            super.fireValueChanged();
        }

        @Override
        public void setValue(T newValue) {
        }
    }
}

