/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.commons.internal.assertions;

import java.util.Objects;
import java.util.function.Supplier;
import lombok.NonNull;
import org.apache.causeway.commons.internal.base._NullSafe;
import org.apache.causeway.commons.internal.base._Strings;
import org.apache.causeway.commons.internal.exceptions._Exceptions;
import org.apache.causeway.commons.internal.primitives._Ints;
import org.apache.causeway.commons.internal.primitives._Longs;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.lang.Nullable;

public final class _Assert {
    private static final Logger log = LogManager.getLogger(_Assert.class);

    public static void assertTrue(boolean condition) {
        _Assert.assertTrue(condition, (String)null);
    }

    public static void assertTrue(boolean condition, String message) {
        if (!condition) {
            _Assert.fail(message, true, false);
        }
    }

    public static void assertTrue(boolean condition, Supplier<String> lazyMessage) {
        if (!condition) {
            _Assert.fail(lazyMessage.get(), true, false);
        }
    }

    public static void assertFalse(boolean condition) {
        _Assert.assertFalse(condition, (String)null);
    }

    public static void assertFalse(boolean condition, String message) {
        if (condition) {
            _Assert.fail(message, false, true);
        }
    }

    public static void assertFalse(boolean condition, Supplier<String> lazyMessage) {
        if (condition) {
            _Assert.fail(lazyMessage.get(), true, false);
        }
    }

    public static void assertNull(Object object) {
        _Assert.assertNull(object, (String)null);
    }

    public static void assertNull(Object object, String message) {
        if (object != null) {
            _Assert.fail(message, "null", "not null");
        }
    }

    public static void assertNull(Object object, Supplier<String> lazyMessage) {
        if (object != null) {
            _Assert.fail(lazyMessage.get(), "null", "not null");
        }
    }

    public static void assertNotNull(Object object) {
        _Assert.assertNotNull(object, (String)null);
    }

    public static void assertNotNull(Object object, String message) {
        if (object == null) {
            _Assert.fail(message, "not null", "null");
        }
    }

    public static void assertNotNull(Object object, Supplier<String> lazyMessage) {
        if (object == null) {
            _Assert.fail(lazyMessage.get(), "not null", "null");
        }
    }

    public static <T> T assertSameObject(T left, Object right) {
        _Assert.assertTrue(left == right);
        return left;
    }

    public static <T> T assertSameObject(T left, Object right, String msg) {
        _Assert.assertTrue(left == right, msg);
        return left;
    }

    public static <T> T assertSameObject(T left, Object right, Supplier<String> lazyMessage) {
        _Assert.assertTrue(left == right, lazyMessage);
        return left;
    }

    public static void assertEquals(Object left, Object right) {
        _Assert.assertEquals(left, right, (String)null);
    }

    public static void assertEquals(Object left, Object right, String message) {
        if (!Objects.equals(left, right)) {
            _Assert.fail(message, left, right);
        }
    }

    public static void assertEquals(Object left, Object right, Supplier<String> lazyMessage) {
        if (!Objects.equals(left, right)) {
            _Assert.fail(lazyMessage.get(), left, right);
        }
    }

    public static void assertRangeContains(_Ints.Range range, int value, String message) {
        if (!range.contains(value)) {
            _Assert.fail(message, range.toString(), value);
        }
    }

    public static void assertRangeContains(_Ints.Range range, int value, Supplier<String> lazyMessage) {
        if (!range.contains(value)) {
            _Assert.fail(lazyMessage.get(), range.toString(), value);
        }
    }

    public static void assertRangeContains(_Longs.Range range, long value, String message) {
        if (!range.contains(value)) {
            _Assert.fail(message, range.toString(), value);
        }
    }

    public static void assertRangeContains(_Longs.Range range, long value, Supplier<String> lazyMessage) {
        if (!range.contains(value)) {
            _Assert.fail(lazyMessage.get(), range.toString(), value);
        }
    }

    public static void assertNotEmpty(String s) {
        _Assert.assertNotEmpty(s, (String)null);
    }

    public static void assertNotEmpty(String s, String message) {
        if (_NullSafe.isEmpty(s)) {
            _Assert.fail(message, "not empty", "empty");
        }
    }

    public static void assertNotEmpty(String s, Supplier<String> lazyMessage) {
        if (_NullSafe.isEmpty(s)) {
            _Assert.fail(lazyMessage.get(), "not empty", "empty");
        }
    }

    public static void assertTypeIsInstanceOf(@NonNull Class<?> type, @NonNull Class<?> requiredType) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (requiredType == null) {
            throw new NullPointerException("requiredType is marked non-null but is null");
        }
        if (!requiredType.isAssignableFrom(type)) {
            throw _Exceptions.assertionError(String.format("unexpected type: '%s' is not an instance of '%s' ", "" + type, "" + requiredType));
        }
    }

    public static void assertNullableObjectIsInstanceOf(@Nullable Object pojo, @NonNull Class<?> requiredType) {
        if (requiredType == null) {
            throw new NullPointerException("requiredType is marked non-null but is null");
        }
        if (pojo == null) {
            return;
        }
        _Assert.assertTypeIsInstanceOf(pojo.getClass(), requiredType);
    }

    static String buildPrefix(String message) {
        return _Strings.isNotEmpty(message) ? message + " ==> " : "";
    }

    private static void fail(String message, Object expected, Object actual) {
        AssertionError error = _Exceptions.assertionError(_Assert.buildPrefix(message) + String.format("expected: <%s> but was: <%s>", "" + expected, "" + actual));
        log.error((Object)error);
        throw error;
    }

    private _Assert() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static enum OpenCloseState {
        NOT_INITIALIZED,
        OPEN,
        CLOSED;


        public boolean isNotInitialized() {
            return this == NOT_INITIALIZED;
        }

        public boolean isOpen() {
            return this == OPEN;
        }

        public boolean isClosed() {
            return this == CLOSED;
        }

        public void assertEquals(@Nullable OpenCloseState expected) {
            if (expected != this) {
                throw new IllegalStateException("State is: " + this + "; should be: " + expected);
            }
        }
    }
}

