/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.commons.collections;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import lombok.NonNull;
import org.apache.causeway.commons.collections.Can;
import org.apache.causeway.commons.collections.Cardinality;
import org.apache.causeway.commons.internal.base._Casts;
import org.apache.causeway.commons.internal.collections._Lists;
import org.apache.causeway.commons.internal.exceptions._Exceptions;
import org.springframework.lang.Nullable;

final class Can_Empty<T>
implements Can<T> {
    private static final long serialVersionUID = 1L;
    static final Can_Empty<?> INSTANCE = new Can_Empty();

    @Override
    public Cardinality getCardinality() {
        return Cardinality.ZERO;
    }

    @Override
    public Stream<T> stream() {
        return Stream.empty();
    }

    @Override
    public Stream<T> parallelStream() {
        return Stream.empty();
    }

    @Override
    public Optional<T> getSingleton() {
        return Optional.empty();
    }

    @Override
    public Optional<T> getFirst() {
        return Optional.empty();
    }

    @Override
    public Optional<T> getLast() {
        return Optional.empty();
    }

    @Override
    public Optional<T> get(int elementIndex) {
        return Optional.empty();
    }

    @Override
    public boolean contains(@Nullable T element) {
        return false;
    }

    @Override
    public int size() {
        return 0;
    }

    @Override
    public Iterator<T> iterator(int skip, int limit) {
        return this.iterator();
    }

    @Override
    public Iterator<T> iterator() {
        return Collections.emptyList().iterator();
    }

    @Override
    public Can<T> sorted(@NonNull Comparator<? super T> c) {
        if (c == null) {
            throw new NullPointerException("c is marked non-null but is null");
        }
        return this;
    }

    @Override
    public Can<T> distinct() {
        return this;
    }

    @Override
    public Can<T> distinct(@NonNull BiPredicate<T, T> equality) {
        if (equality == null) {
            throw new NullPointerException("equality is marked non-null but is null");
        }
        return this;
    }

    @Override
    public Can<T> reverse() {
        return this;
    }

    @Override
    public Iterator<T> reverseIterator() {
        return this.iterator();
    }

    @Override
    public void forEach(Consumer<? super T> action) {
    }

    @Override
    public Can<T> filter(@Nullable Predicate<? super T> predicate) {
        return this;
    }

    @Override
    public <R> void zip(Iterable<R> zippedIn, BiConsumer<? super T, ? super R> action) {
    }

    @Override
    public <R, Z> Can<R> zipMap(Iterable<Z> zippedIn, BiFunction<? super T, ? super Z, R> mapper) {
        return Can.empty();
    }

    @Override
    public Can<T> add(@Nullable T element) {
        return element != null ? Can.ofSingleton(element) : this;
    }

    @Override
    public Can<T> addUnique(@Nullable T element) {
        return this.add(element);
    }

    @Override
    public Can<T> addAll(@Nullable Can<T> other) {
        return other != null ? other : this;
    }

    @Override
    public Can<T> add(int index, @Nullable T element) {
        if (index != 0) {
            throw new IndexOutOfBoundsException("cannot add to empty can with index other than 0; got " + index);
        }
        return this.add(element);
    }

    @Override
    public Can<T> replace(int index, @Nullable T element) {
        throw _Exceptions.unsupportedOperation("cannot replace an element in an empty Can");
    }

    @Override
    public Can<T> remove(int index) {
        throw new IndexOutOfBoundsException("cannot remove anything from an empty Can");
    }

    @Override
    public Can<T> remove(@Nullable T element) {
        return this;
    }

    @Override
    public Can<T> pickByIndex(int ... indices) {
        return Can.empty();
    }

    @Override
    public Can<T> pickByIndex(@Nullable IntStream intStream) {
        return Can.empty();
    }

    @Override
    public Can<T> subCan(int startInclusive, int endExclusive) {
        return Can.empty();
    }

    @Override
    public Can<Can<T>> partitionInnerBound(int maxInnerSize) {
        return Can.empty();
    }

    @Override
    public Can<Can<T>> partitionOuterBound(int outerSizeYield) {
        return Can.empty();
    }

    @Override
    public int indexOf(@Nullable T element) {
        return -1;
    }

    public String toString() {
        return "Can[]";
    }

    public boolean equals(@Nullable Object obj) {
        if (INSTANCE == obj) {
            return true;
        }
        return obj instanceof Can ? ((Can)obj).isEmpty() : false;
    }

    public int hashCode() {
        return 0;
    }

    @Override
    public int compareTo(@Nullable Can<T> other) {
        if (other == null) {
            return 0;
        }
        return Integer.compare(0, other.size());
    }

    @Override
    public List<T> toList() {
        return Collections.emptyList();
    }

    @Override
    public List<T> toArrayList() {
        return _Lists.newArrayList();
    }

    @Override
    public Set<T> toSet() {
        return Collections.emptySet();
    }

    @Override
    public Set<T> toSet(@NonNull Consumer<T> onDuplicated) {
        if (onDuplicated == null) {
            throw new NullPointerException("onDuplicated is marked non-null but is null");
        }
        return Collections.emptySet();
    }

    @Override
    public <C extends Collection<T>> C toCollection(@NonNull Supplier<C> collectionFactory) {
        if (collectionFactory == null) {
            throw new NullPointerException("collectionFactory is marked non-null but is null");
        }
        return (C)((Collection)collectionFactory.get());
    }

    @Override
    public T[] toArray(@NonNull Class<T> elementType) {
        if (elementType == null) {
            throw new NullPointerException("elementType is marked non-null but is null");
        }
        Object[] array = (Object[])_Casts.uncheckedCast(Array.newInstance(elementType, 0));
        return array;
    }

    private Can_Empty() {
    }
}

