/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.commons.collections;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import lombok.NonNull;
import org.apache.causeway.commons.collections.Can_Empty;
import org.apache.causeway.commons.collections.Can_Multiple;
import org.apache.causeway.commons.collections.Can_Singleton;
import org.apache.causeway.commons.collections.ImmutableCollection;
import org.apache.causeway.commons.collections._CanFactory;
import org.apache.causeway.commons.internal.base._NullSafe;
import org.apache.causeway.commons.internal.exceptions._Exceptions;
import org.springframework.lang.Nullable;

public interface Can<T>
extends ImmutableCollection<T>,
Comparable<Can<T>>,
Serializable {
    public Optional<T> get(int var1);

    default public T getElseFail(int elementIndex) {
        return this.get(elementIndex).orElseThrow(() -> new NoSuchElementException("no element with elementIndex = " + elementIndex));
    }

    @Override
    public int compareTo(@Nullable Can<T> var1);

    public Optional<T> getFirst();

    default public T getFirstElseFail() {
        return this.getFirst().orElseThrow(_Exceptions::noSuchElement);
    }

    public Optional<T> getLast();

    default public T getLastElseFail() {
        return this.getLast().orElseThrow(_Exceptions::noSuchElement);
    }

    public static <T> Can<T> empty() {
        return Can_Empty.INSTANCE;
    }

    public static <T> Can<T> ofNullable(@Nullable T element) {
        if (element == null) {
            return Can.empty();
        }
        return Can_Singleton.of(element);
    }

    public static <T> Can<T> ofSingleton(@NonNull T element) {
        if (element == null) {
            throw new NullPointerException("element is marked non-null but is null");
        }
        return Can_Singleton.of(element);
    }

    @SafeVarargs
    public static <T> Can<T> of(T ... array) {
        return Can.ofArray(array);
    }

    public static <T> Can<T> ofArray(@Nullable T[] array) {
        if (_NullSafe.size(array) == 0) {
            return Can.empty();
        }
        ArrayList nonNullElements = Stream.of(array).filter(_NullSafe::isPresent).collect(_CanFactory.toListWithSizeUpperBound(array.length));
        return _CanFactory.ofNonNullElements(nonNullElements);
    }

    public static <T> Can<T> ofCollection(@Nullable Collection<T> collection) {
        int inputSize = _NullSafe.size(collection);
        if (inputSize == 0) {
            return Can.empty();
        }
        ArrayList nonNullElements = collection.stream().filter(_NullSafe::isPresent).collect(_CanFactory.toListWithSizeUpperBound(inputSize));
        return _CanFactory.ofNonNullElements(nonNullElements);
    }

    public static <T> Can<T> ofIterable(@Nullable Iterable<T> iterable) {
        if (iterable == null) {
            return Can.empty();
        }
        ArrayList nonNullElements = new ArrayList();
        iterable.forEach(element -> {
            if (element != null) {
                nonNullElements.add(element);
            }
        });
        return _CanFactory.ofNonNullElements(nonNullElements);
    }

    public static <T> Can<T> ofEnumeration(@Nullable Enumeration<T> enumeration) {
        if (enumeration == null) {
            return Can.empty();
        }
        ArrayList<T> nonNullElements = new ArrayList<T>();
        while (enumeration.hasMoreElements()) {
            T element = enumeration.nextElement();
            if (element == null) continue;
            nonNullElements.add(element);
        }
        return _CanFactory.ofNonNullElements(nonNullElements);
    }

    public static <T> Can<T> ofStream(@Nullable Stream<T> stream) {
        if (stream == null) {
            return Can.empty();
        }
        ArrayList nonNullElements = stream.filter(_NullSafe::isPresent).collect(Collectors.toCollection(() -> new ArrayList()));
        return _CanFactory.ofNonNullElements(nonNullElements);
    }

    public Can<T> sorted(Comparator<? super T> var1);

    public Can<T> distinct();

    public Can<T> distinct(@NonNull BiPredicate<T, T> var1);

    public Can<T> reverse();

    public Can<T> filter(@Nullable Predicate<? super T> var1);

    default public <R> Can<R> map(@NonNull Function<? super T, R> mapper) {
        if (mapper == null) {
            throw new NullPointerException("mapper is marked non-null but is null");
        }
        if (this.isEmpty()) {
            return Can.empty();
        }
        ArrayList nonNullMappedElements = this.stream().map(mapper).filter(_NullSafe::isPresent).collect(_CanFactory.toListWithSizeUpperBound(this.size()));
        return _CanFactory.ofNonNullElements(nonNullMappedElements);
    }

    default public <R> Can<R> flatMap(@NonNull Function<? super T, ? extends Can<? extends R>> mapper) {
        if (mapper == null) {
            throw new NullPointerException("mapper is marked non-null but is null");
        }
        if (this.isEmpty()) {
            return Can.empty();
        }
        return this.stream().map(mapper).filter(_NullSafe::isPresent).flatMap(ImmutableCollection::stream).collect(Can.toCan());
    }

    public static <T> Can<T> concat(@Nullable Can<T> can, @Nullable T element) {
        if (can == null || can.isEmpty()) {
            return Can.ofNullable(element);
        }
        if (element == null) {
            return can;
        }
        int newSize = can.size() + 1;
        ArrayList union = can.stream().collect(Collectors.toCollection(() -> new ArrayList(newSize)));
        union.add(element);
        return Can_Multiple.of(union);
    }

    public Iterator<T> iterator(int var1, int var2);

    public Iterator<T> reverseIterator();

    @Override
    public void forEach(@NonNull Consumer<? super T> var1);

    public <R> void zip(Iterable<R> var1, BiConsumer<? super T, ? super R> var2);

    public <R, Z> Can<R> zipMap(Iterable<Z> var1, BiFunction<? super T, ? super Z, R> var2);

    public Can<T> add(@Nullable T var1);

    default public Can<T> addUnique(@Nullable T element) {
        if (this.contains(element)) {
            return this;
        }
        return this.add(element);
    }

    public Can<T> addAll(@Nullable Can<T> var1);

    public Can<T> add(int var1, @Nullable T var2);

    public Can<T> replace(int var1, @Nullable T var2);

    public Can<T> remove(int var1);

    public Can<T> remove(@Nullable T var1);

    public Can<T> pickByIndex(int ... var1);

    public Can<T> pickByIndex(@Nullable IntStream var1);

    public Can<T> subCan(int var1, int var2);

    public Can<Can<T>> partitionInnerBound(int var1);

    public Can<Can<T>> partitionOuterBound(int var1);

    public int indexOf(@Nullable T var1);

    default public boolean isEqualTo(@Nullable Can<?> other) {
        if (other == null) {
            return false;
        }
        if (this.size() != other.size()) {
            return false;
        }
        Iterator otherIterator = other.iterator();
        for (Object element : this) {
            Object otherElement;
            if (element.equals(otherElement = otherIterator.next())) continue;
            return false;
        }
        return true;
    }

    default public boolean startsWith(@Nullable Can<?> other) {
        if (other == null || other.isEmpty()) {
            return true;
        }
        if (this.size() < other.size()) {
            return false;
        }
        Iterator thisIterator = this.iterator();
        for (Object otherElement : other) {
            Object thisElement = thisIterator.next();
            if (thisElement.equals(otherElement)) continue;
            return false;
        }
        return true;
    }

    default public boolean endsWith(@Nullable Can<?> other) {
        if (other == null || other.isEmpty()) {
            return true;
        }
        if (this.size() < other.size()) {
            return false;
        }
        Iterator<T> thisIterator = this.reverseIterator();
        Iterator<?> otherIterator = other.reverseIterator();
        while (otherIterator.hasNext()) {
            Object otherElement = otherIterator.next();
            T thisElement = thisIterator.next();
            if (thisElement.equals(otherElement)) continue;
            return false;
        }
        return true;
    }

    @Override
    default public boolean isEmpty() {
        return this.getCardinality().isZero();
    }

    default public boolean isNotEmpty() {
        return !this.getCardinality().isZero();
    }

    default public boolean isCardinalityOne() {
        return this.getCardinality().isOne();
    }

    default public boolean isCardinalityMultiple() {
        return this.getCardinality().isMultiple();
    }

    public static <T> Collector<T, ?, Can<T>> toCan() {
        return Collectors.collectingAndThen(Collectors.toList(), Can::ofCollection);
    }

    public List<T> toList();

    public List<T> toArrayList();

    public Set<T> toSet();

    public Set<T> toSet(@NonNull Consumer<T> var1);

    public <C extends Collection<T>> C toCollection(Supplier<C> var1);

    default public T[] toArray(T[] a) {
        return this.toList().toArray(a);
    }

    public T[] toArray(Class<T> var1);
}

