/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.metadata.schema;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.shaded.guava.common.base.Strings;
import java.util.function.Consumer;
import net.jcip.annotations.NotThreadSafe;

@NotThreadSafe
public class ScriptBuilder {
    private static final int INDENT_SIZE = 4;
    private final boolean pretty;
    private final StringBuilder builder = new StringBuilder();
    private int indent;
    private boolean isAtLineStart;
    private boolean isFirstOption = true;

    public ScriptBuilder(boolean pretty) {
        this.pretty = pretty;
    }

    public ScriptBuilder append(String s) {
        if (this.pretty && this.isAtLineStart && this.indent > 0) {
            this.builder.append(Strings.repeat((String)" ", (int)(this.indent * 4)));
        }
        this.isAtLineStart = false;
        this.builder.append(s);
        return this;
    }

    public ScriptBuilder append(CqlIdentifier id) {
        this.append(id.asCql(this.pretty));
        return this;
    }

    public ScriptBuilder newLine() {
        if (this.pretty) {
            this.builder.append('\n');
        } else {
            this.builder.append(' ');
        }
        this.isAtLineStart = true;
        return this;
    }

    public ScriptBuilder forceNewLine(int count) {
        this.builder.append(Strings.repeat((String)"\n", (int)count));
        this.isAtLineStart = true;
        return this;
    }

    public ScriptBuilder increaseIndent() {
        ++this.indent;
        return this;
    }

    public ScriptBuilder decreaseIndent() {
        if (this.indent > 0) {
            --this.indent;
        }
        return this;
    }

    public ScriptBuilder andWith() {
        if (this.isFirstOption) {
            this.append(" WITH ");
            this.isFirstOption = false;
        } else {
            this.newLine();
            this.append("AND ");
        }
        return this;
    }

    public <E> ScriptBuilder forEach(Iterable<E> iterable, Consumer<E> action) {
        for (E e : iterable) {
            action.accept(e);
        }
        return this;
    }

    public String build() {
        return this.builder.toString();
    }
}

