/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.api.core;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.jcip.annotations.Immutable;

@Immutable
public class Version
implements Comparable<Version>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String VERSION_REGEXP = "(\\d+)\\.(\\d+)(\\.\\d+)?(\\.\\d+)?([~\\-]\\w[.\\w]*(?:-\\w[.\\w]*)*)?(\\+[.\\w]+)?";
    private static final Pattern pattern = Pattern.compile("(\\d+)\\.(\\d+)(\\.\\d+)?(\\.\\d+)?([~\\-]\\w[.\\w]*(?:-\\w[.\\w]*)*)?(\\+[.\\w]+)?");
    @NonNull
    public static final Version V2_1_0 = Objects.requireNonNull(Version.parse("2.1.0"));
    @NonNull
    public static final Version V2_2_0 = Objects.requireNonNull(Version.parse("2.2.0"));
    @NonNull
    public static final Version V3_0_0 = Objects.requireNonNull(Version.parse("3.0.0"));
    @NonNull
    public static final Version V4_0_0 = Objects.requireNonNull(Version.parse("4.0.0"));
    @NonNull
    public static final Version V4_1_0 = Objects.requireNonNull(Version.parse("4.1.0"));
    @NonNull
    public static final Version V5_0_0 = Objects.requireNonNull(Version.parse("5.0.0"));
    @NonNull
    public static final Version V6_7_0 = Objects.requireNonNull(Version.parse("6.7.0"));
    @NonNull
    public static final Version V6_8_0 = Objects.requireNonNull(Version.parse("6.8.0"));
    private final int major;
    private final int minor;
    private final int patch;
    private final int dsePatch;
    private final String[] preReleases;
    private final String build;

    private Version(int major, int minor, int patch, int dsePatch, String[] preReleases, String build) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
        this.dsePatch = dsePatch;
        this.preReleases = preReleases;
        this.build = build;
    }

    @Nullable
    public static Version parse(@Nullable String version) {
        if (version == null) {
            return null;
        }
        Matcher matcher = pattern.matcher(version);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Invalid version number: " + version);
        }
        try {
            int major = Integer.parseInt(matcher.group(1));
            int minor = Integer.parseInt(matcher.group(2));
            String pa = matcher.group(3);
            int patch = pa == null || pa.isEmpty() ? 0 : Integer.parseInt(pa.substring(1));
            String dse = matcher.group(4);
            int dsePatch = dse == null || dse.isEmpty() ? -1 : Integer.parseInt(dse.substring(1));
            String pr = matcher.group(5);
            String[] preReleases = pr == null || pr.isEmpty() ? null : pr.substring(1).split("-");
            String bl = matcher.group(6);
            String build = bl == null || bl.isEmpty() ? null : bl.substring(1);
            return new Version(major, minor, patch, dsePatch, preReleases, build);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid version number: " + version);
        }
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getPatch() {
        return this.patch;
    }

    public int getDSEPatch() {
        return this.dsePatch;
    }

    public List<String> getPreReleaseLabels() {
        return this.preReleases == null ? null : Collections.unmodifiableList(Arrays.asList(this.preReleases));
    }

    public String getBuildLabel() {
        return this.build;
    }

    public Version nextStable() {
        return new Version(this.major, this.minor, this.patch, this.dsePatch, null, null);
    }

    @Override
    public int compareTo(@NonNull Version other) {
        if (this.major < other.major) {
            return -1;
        }
        if (this.major > other.major) {
            return 1;
        }
        if (this.minor < other.minor) {
            return -1;
        }
        if (this.minor > other.minor) {
            return 1;
        }
        if (this.patch < other.patch) {
            return -1;
        }
        if (this.patch > other.patch) {
            return 1;
        }
        if (this.dsePatch < 0) {
            if (other.dsePatch >= 0) {
                return -1;
            }
        } else {
            if (other.dsePatch < 0) {
                return 1;
            }
            if (this.dsePatch < other.dsePatch) {
                return -1;
            }
            if (this.dsePatch > other.dsePatch) {
                return 1;
            }
        }
        if (this.preReleases == null) {
            return other.preReleases == null ? 0 : 1;
        }
        if (other.preReleases == null) {
            return -1;
        }
        for (int i = 0; i < Math.min(this.preReleases.length, other.preReleases.length); ++i) {
            int cmp = this.preReleases[i].compareTo(other.preReleases[i]);
            if (cmp == 0) continue;
            return cmp;
        }
        return Integer.compare(this.preReleases.length, other.preReleases.length);
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof Version) {
            Version that = (Version)other;
            return this.major == that.major && this.minor == that.minor && this.patch == that.patch && this.dsePatch == that.dsePatch && (this.preReleases == null ? that.preReleases == null : Arrays.equals(this.preReleases, that.preReleases)) && Objects.equals(this.build, that.build);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.major, this.minor, this.patch, this.dsePatch, Arrays.hashCode(this.preReleases), this.build);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.major).append('.').append(this.minor).append('.').append(this.patch);
        if (this.dsePatch >= 0) {
            sb.append('.').append(this.dsePatch);
        }
        if (this.preReleases != null) {
            for (String preRelease : this.preReleases) {
                sb.append('-').append(preRelease);
            }
        }
        if (this.build != null) {
            sb.append('+').append(this.build);
        }
        return sb.toString();
    }
}

