/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.util.collection;

import com.datastax.oss.driver.Assertions;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.internal.core.util.collection.QueryPlan;
import java.util.Comparator;
import java.util.Iterator;
import java.util.concurrent.ConcurrentSkipListSet;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public abstract class QueryPlanTestBase {
    @Mock
    private Node node1;
    @Mock
    private Node node2;
    @Mock
    private Node node3;

    @Test
    public void should_poll_elements() {
        QueryPlan queryPlan = this.newQueryPlan(this.node1, this.node2, this.node3);
        Assertions.assertThat((Object)((Node)queryPlan.poll())).isSameAs((Object)this.node1);
        Assertions.assertThat((Object)((Node)queryPlan.poll())).isSameAs((Object)this.node2);
        Assertions.assertThat((Object)((Node)queryPlan.poll())).isSameAs((Object)this.node3);
        Assertions.assertThat((Object)((Node)queryPlan.poll())).isNull();
        Assertions.assertThat((Object)((Node)queryPlan.poll())).isNull();
    }

    @Test
    public void should_poll_elements_concurrently() throws InterruptedException {
        for (int runs = 0; runs < 5; ++runs) {
            Node[] nodes = new Node[1000];
            for (int i = 0; i < 1000; ++i) {
                nodes[i] = (Node)Mockito.mock(Node.class, (String)("node" + i));
                Mockito.when((Object)nodes[i].getOpenConnections()).thenReturn((Object)i);
            }
            QueryPlan queryPlan = this.newQueryPlan(nodes);
            ConcurrentSkipListSet<Node> actual = new ConcurrentSkipListSet<Node>(Comparator.comparingInt(Node::getOpenConnections));
            Thread[] threads = new Thread[5];
            for (int i = 0; i < 5; ++i) {
                threads[i] = new Thread(() -> {
                    Node node;
                    while ((node = (Node)queryPlan.poll()) != null) {
                        actual.add(node);
                    }
                    return;
                });
            }
            for (Thread thread : threads) {
                thread.start();
            }
            for (Thread thread : threads) {
                thread.join();
            }
            Assertions.assertThat(actual).hasSize(1000);
            Iterator iterator = actual.iterator();
            int i = 0;
            while (iterator.hasNext()) {
                Node node = (Node)iterator.next();
                Assertions.assertThat((int)node.getOpenConnections()).isEqualTo(i);
                ++i;
            }
        }
    }

    @Test
    public void should_return_size() {
        QueryPlan queryPlan = this.newQueryPlan(this.node1, this.node2, this.node3);
        Assertions.assertThat((int)queryPlan.size()).isEqualTo(3);
        queryPlan.poll();
        Assertions.assertThat((int)queryPlan.size()).isEqualTo(2);
        queryPlan.poll();
        Assertions.assertThat((int)queryPlan.size()).isEqualTo(1);
        queryPlan.poll();
        Assertions.assertThat((int)queryPlan.size()).isEqualTo(0);
        queryPlan.poll();
        Assertions.assertThat((int)queryPlan.size()).isEqualTo(0);
    }

    @Test
    public void should_return_iterator() {
        QueryPlan queryPlan = this.newQueryPlan(this.node1, this.node2, this.node3);
        Iterator iterator3 = queryPlan.iterator();
        queryPlan.poll();
        Iterator iterator2 = queryPlan.iterator();
        queryPlan.poll();
        Iterator iterator1 = queryPlan.iterator();
        queryPlan.poll();
        Iterator iterator0 = queryPlan.iterator();
        queryPlan.poll();
        Iterator iterator00 = queryPlan.iterator();
        Assertions.assertThat((Iterator)iterator3).toIterable().containsExactly((Object[])new Node[]{this.node1, this.node2, this.node3});
        Assertions.assertThat((Iterator)iterator2).toIterable().containsExactly((Object[])new Node[]{this.node2, this.node3});
        Assertions.assertThat((Iterator)iterator1).toIterable().containsExactly((Object[])new Node[]{this.node3});
        Assertions.assertThat((Iterator)iterator0).toIterable().isEmpty();
        Assertions.assertThat((Iterator)iterator00).toIterable().isEmpty();
    }

    protected abstract QueryPlan newQueryPlan(Node ... var1);
}

