/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.util;

import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.config.DriverOption;
import com.datastax.oss.driver.api.core.specex.SpeculativeExecutionPolicy;
import com.datastax.oss.driver.internal.core.config.typesafe.TypesafeDriverConfig;
import com.datastax.oss.driver.internal.core.context.InternalDriverContext;
import com.datastax.oss.driver.internal.core.specex.ConstantSpeculativeExecutionPolicy;
import com.datastax.oss.driver.internal.core.specex.NoSpeculativeExecutionPolicy;
import com.datastax.oss.driver.internal.core.util.Reflection;
import com.typesafe.config.ConfigFactory;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.Test;
import org.mockito.Mockito;

public class ReflectionTest {
    @Test
    public void should_build_policies_per_profile() {
        String configSource = "advanced.speculative-execution-policy {\n  class = ConstantSpeculativeExecutionPolicy\n  max-executions = 3\n  delay = 100 milliseconds\n}\nprofiles {\n  profile1 {}\n  profile2 { \n    advanced.speculative-execution-policy.max-executions = 2  }\n  profile3 { \n    advanced.speculative-execution-policy.max-executions = 2  }\n  profile4 { \n    advanced.speculative-execution-policy.class = NoSpeculativeExecutionPolicy\n  }\n}\n";
        InternalDriverContext context = (InternalDriverContext)Mockito.mock(InternalDriverContext.class);
        TypesafeDriverConfig config = new TypesafeDriverConfig(ConfigFactory.parseString((String)configSource));
        Mockito.when((Object)context.getConfig()).thenReturn((Object)config);
        Map policies = Reflection.buildFromConfigProfiles((InternalDriverContext)context, (DriverOption)DefaultDriverOption.SPECULATIVE_EXECUTION_POLICY_CLASS, (DriverOption)DefaultDriverOption.SPECULATIVE_EXECUTION_POLICY, SpeculativeExecutionPolicy.class, (String[])new String[]{"com.datastax.oss.driver.internal.core.specex"});
        Assertions.assertThat((Map)policies).hasSize(5);
        SpeculativeExecutionPolicy defaultPolicy = (SpeculativeExecutionPolicy)policies.get("default");
        SpeculativeExecutionPolicy policy1 = (SpeculativeExecutionPolicy)policies.get("profile1");
        SpeculativeExecutionPolicy policy2 = (SpeculativeExecutionPolicy)policies.get("profile2");
        SpeculativeExecutionPolicy policy3 = (SpeculativeExecutionPolicy)policies.get("profile3");
        SpeculativeExecutionPolicy policy4 = (SpeculativeExecutionPolicy)policies.get("profile4");
        ((ObjectAssert)Assertions.assertThat((Object)defaultPolicy).isInstanceOf(ConstantSpeculativeExecutionPolicy.class)).isSameAs((Object)policy1);
        ((ObjectAssert)Assertions.assertThat((Object)policy2).isInstanceOf(ConstantSpeculativeExecutionPolicy.class)).isSameAs((Object)policy3);
        Assertions.assertThat((Object)policy4).isInstanceOf(NoSpeculativeExecutionPolicy.class);
    }
}

