/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.type.codec.registry;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.data.CqlDuration;
import com.datastax.oss.driver.api.core.data.CqlVector;
import com.datastax.oss.driver.api.core.data.TupleValue;
import com.datastax.oss.driver.api.core.data.UdtValue;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.DataTypes;
import com.datastax.oss.driver.api.core.type.TupleType;
import com.datastax.oss.driver.api.core.type.UserDefinedType;
import com.datastax.oss.driver.api.core.type.codec.TypeCodecs;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import com.datastax.oss.driver.internal.core.data.DefaultTupleValue;
import com.datastax.oss.driver.internal.core.data.DefaultUdtValue;
import com.datastax.oss.driver.internal.core.type.UserDefinedTypeBuilder;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableList;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableMap;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableSet;
import com.tngtech.java.junit.dataprovider.DataProvider;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.Collections;
import java.util.UUID;

public class CachingCodecRegistryTestDataProviders {
    @DataProvider
    public static Object[][] primitiveCodecs() {
        return new Object[][]{{TypeCodecs.BOOLEAN}, {TypeCodecs.TINYINT}, {TypeCodecs.DOUBLE}, {TypeCodecs.COUNTER}, {TypeCodecs.FLOAT}, {TypeCodecs.INT}, {TypeCodecs.BIGINT}, {TypeCodecs.SMALLINT}, {TypeCodecs.TIMESTAMP}, {TypeCodecs.DATE}, {TypeCodecs.TIME}, {TypeCodecs.BLOB}, {TypeCodecs.TEXT}, {TypeCodecs.ASCII}, {TypeCodecs.VARINT}, {TypeCodecs.DECIMAL}, {TypeCodecs.UUID}, {TypeCodecs.TIMEUUID}, {TypeCodecs.INET}, {TypeCodecs.DURATION}};
    }

    @DataProvider
    public static Object[][] primitiveCodecsWithValues() throws UnknownHostException {
        return new Object[][]{{true, TypeCodecs.BOOLEAN}, {(byte)0, TypeCodecs.TINYINT}, {0.0, TypeCodecs.DOUBLE}, {Float.valueOf(0.0f), TypeCodecs.FLOAT}, {0, TypeCodecs.INT}, {0L, TypeCodecs.BIGINT}, {(short)0, TypeCodecs.SMALLINT}, {Instant.EPOCH, TypeCodecs.TIMESTAMP}, {LocalDate.MIN, TypeCodecs.DATE}, {LocalTime.MIDNIGHT, TypeCodecs.TIME}, {ByteBuffer.allocate(0), TypeCodecs.BLOB}, {"", TypeCodecs.TEXT}, {BigInteger.ONE, TypeCodecs.VARINT}, {BigDecimal.ONE, TypeCodecs.DECIMAL}, {new UUID(2L, 1L), TypeCodecs.UUID}, {InetAddress.getByName("127.0.0.1"), TypeCodecs.INET}, {CqlDuration.newInstance((int)1, (int)2, (long)3L), TypeCodecs.DURATION}};
    }

    @DataProvider
    public static Object[][] primitiveCodecsWithCqlTypesAndValues() throws UnknownHostException {
        return new Object[][]{{DataTypes.BOOLEAN, true, TypeCodecs.BOOLEAN}, {DataTypes.TINYINT, (byte)0, TypeCodecs.TINYINT}, {DataTypes.DOUBLE, 0.0, TypeCodecs.DOUBLE}, {DataTypes.FLOAT, Float.valueOf(0.0f), TypeCodecs.FLOAT}, {DataTypes.INT, 0, TypeCodecs.INT}, {DataTypes.BIGINT, 0L, TypeCodecs.BIGINT}, {DataTypes.SMALLINT, (short)0, TypeCodecs.SMALLINT}, {DataTypes.TIMESTAMP, Instant.EPOCH, TypeCodecs.TIMESTAMP}, {DataTypes.DATE, LocalDate.MIN, TypeCodecs.DATE}, {DataTypes.TIME, LocalTime.MIDNIGHT, TypeCodecs.TIME}, {DataTypes.BLOB, ByteBuffer.allocate(0), TypeCodecs.BLOB}, {DataTypes.TEXT, "", TypeCodecs.TEXT}, {DataTypes.VARINT, BigInteger.ONE, TypeCodecs.VARINT}, {DataTypes.DECIMAL, BigDecimal.ONE, TypeCodecs.DECIMAL}, {DataTypes.UUID, new UUID(2L, 1L), TypeCodecs.UUID}, {DataTypes.INET, InetAddress.getByName("127.0.0.1"), TypeCodecs.INET}, {DataTypes.DURATION, CqlDuration.newInstance((int)1, (int)2, (long)3L), TypeCodecs.DURATION}};
    }

    @DataProvider
    public static Object[][] collectionsWithCqlAndJavaTypes() throws UnknownHostException, ClassNotFoundException {
        TupleType tupleType = DataTypes.tupleOf((DataType[])new DataType[]{DataTypes.INT, DataTypes.listOf((DataType)DataTypes.TEXT)});
        TupleValue tupleValue = tupleType.newValue();
        UserDefinedType userType = new UserDefinedTypeBuilder(CqlIdentifier.fromInternal((String)"ks"), CqlIdentifier.fromInternal((String)"type")).withField(CqlIdentifier.fromInternal((String)"field1"), DataTypes.INT).withField(CqlIdentifier.fromInternal((String)"field2"), (DataType)DataTypes.listOf((DataType)DataTypes.TEXT)).build();
        UdtValue udtValue = userType.newValue();
        return new Object[][]{{DataTypes.listOf((DataType)DataTypes.INT), GenericType.listOf(Integer.class), GenericType.listOf(Integer.class), ImmutableList.of((Object)1)}, {DataTypes.listOf((DataType)DataTypes.TEXT), GenericType.listOf(String.class), GenericType.listOf(String.class), ImmutableList.of((Object)"foo")}, {DataTypes.listOf((DataType)DataTypes.BLOB), GenericType.listOf(ByteBuffer.class), GenericType.listOf(Class.forName("java.nio.HeapByteBuffer")), ImmutableList.of((Object)ByteBuffer.wrap(new byte[]{127, 0, 0, 1}))}, {DataTypes.listOf((DataType)DataTypes.INET), GenericType.listOf(InetAddress.class), GenericType.listOf(Inet4Address.class), ImmutableList.of((Object)InetAddress.getByAddress(new byte[]{127, 0, 0, 1}))}, {DataTypes.listOf((DataType)tupleType), GenericType.listOf(TupleValue.class), GenericType.listOf(DefaultTupleValue.class), ImmutableList.of((Object)tupleValue)}, {DataTypes.listOf((DataType)userType), GenericType.listOf(UdtValue.class), GenericType.listOf(DefaultUdtValue.class), ImmutableList.of((Object)udtValue)}, {DataTypes.listOf((DataType)DataTypes.listOf((DataType)DataTypes.INT)), GenericType.listOf((GenericType)GenericType.listOf(Integer.class)), GenericType.listOf((GenericType)GenericType.listOf(Integer.class)), ImmutableList.of((Object)ImmutableList.of((Object)1))}, {DataTypes.listOf((DataType)DataTypes.listOf((DataType)tupleType)), GenericType.listOf((GenericType)GenericType.listOf(TupleValue.class)), GenericType.listOf((GenericType)GenericType.listOf(DefaultTupleValue.class)), ImmutableList.of((Object)ImmutableList.of((Object)tupleValue))}, {DataTypes.listOf((DataType)DataTypes.listOf((DataType)userType)), GenericType.listOf((GenericType)GenericType.listOf(UdtValue.class)), GenericType.listOf((GenericType)GenericType.listOf(DefaultUdtValue.class)), ImmutableList.of((Object)ImmutableList.of((Object)udtValue))}, {DataTypes.setOf((DataType)DataTypes.INT), GenericType.setOf(Integer.class), GenericType.setOf(Integer.class), ImmutableSet.of((Object)1)}, {DataTypes.setOf((DataType)DataTypes.TEXT), GenericType.setOf(String.class), GenericType.setOf(String.class), ImmutableSet.of((Object)"foo")}, {DataTypes.setOf((DataType)DataTypes.BLOB), GenericType.setOf(ByteBuffer.class), GenericType.setOf(Class.forName("java.nio.HeapByteBuffer")), ImmutableSet.of((Object)ByteBuffer.wrap(new byte[]{127, 0, 0, 1}))}, {DataTypes.setOf((DataType)DataTypes.INET), GenericType.setOf(InetAddress.class), GenericType.setOf(Inet4Address.class), ImmutableSet.of((Object)InetAddress.getByAddress(new byte[]{127, 0, 0, 1}))}, {DataTypes.setOf((DataType)tupleType), GenericType.setOf(TupleValue.class), GenericType.setOf(DefaultTupleValue.class), ImmutableSet.of((Object)tupleValue)}, {DataTypes.setOf((DataType)userType), GenericType.setOf(UdtValue.class), GenericType.setOf(DefaultUdtValue.class), ImmutableSet.of((Object)udtValue)}, {DataTypes.setOf((DataType)DataTypes.setOf((DataType)DataTypes.INT)), GenericType.setOf((GenericType)GenericType.setOf(Integer.class)), GenericType.setOf((GenericType)GenericType.setOf(Integer.class)), ImmutableSet.of((Object)ImmutableSet.of((Object)1))}, {DataTypes.setOf((DataType)DataTypes.setOf((DataType)tupleType)), GenericType.setOf((GenericType)GenericType.setOf(TupleValue.class)), GenericType.setOf((GenericType)GenericType.setOf(DefaultTupleValue.class)), ImmutableSet.of((Object)ImmutableSet.of((Object)tupleValue))}, {DataTypes.setOf((DataType)DataTypes.setOf((DataType)userType)), GenericType.setOf((GenericType)GenericType.setOf(UdtValue.class)), GenericType.setOf((GenericType)GenericType.setOf(DefaultUdtValue.class)), ImmutableSet.of((Object)ImmutableSet.of((Object)udtValue))}, {DataTypes.mapOf((DataType)DataTypes.INT, (DataType)DataTypes.TEXT), GenericType.mapOf(Integer.class, String.class), GenericType.mapOf(Integer.class, String.class), ImmutableMap.of((Object)1, (Object)"foo")}, {DataTypes.mapOf((DataType)DataTypes.BLOB, (DataType)DataTypes.INET), GenericType.mapOf(ByteBuffer.class, InetAddress.class), GenericType.mapOf(Class.forName("java.nio.HeapByteBuffer"), Inet4Address.class), ImmutableMap.of((Object)ByteBuffer.wrap(new byte[]{127, 0, 0, 1}), (Object)InetAddress.getByAddress(new byte[]{127, 0, 0, 1}))}, {DataTypes.mapOf((DataType)tupleType, (DataType)tupleType), GenericType.mapOf(TupleValue.class, TupleValue.class), GenericType.mapOf(DefaultTupleValue.class, DefaultTupleValue.class), ImmutableMap.of((Object)tupleValue, (Object)tupleValue)}, {DataTypes.mapOf((DataType)userType, (DataType)userType), GenericType.mapOf(UdtValue.class, UdtValue.class), GenericType.mapOf(DefaultUdtValue.class, DefaultUdtValue.class), ImmutableMap.of((Object)udtValue, (Object)udtValue)}, {DataTypes.mapOf((DataType)DataTypes.UUID, (DataType)DataTypes.mapOf((DataType)DataTypes.INT, (DataType)DataTypes.TEXT)), GenericType.mapOf((GenericType)GenericType.UUID, (GenericType)GenericType.mapOf(Integer.class, String.class)), GenericType.mapOf((GenericType)GenericType.UUID, (GenericType)GenericType.mapOf(Integer.class, String.class)), ImmutableMap.of((Object)UUID.randomUUID(), (Object)ImmutableMap.of((Object)1, (Object)"foo"))}, {DataTypes.mapOf((DataType)DataTypes.mapOf((DataType)userType, (DataType)userType), (DataType)DataTypes.mapOf((DataType)tupleType, (DataType)tupleType)), GenericType.mapOf((GenericType)GenericType.mapOf(UdtValue.class, UdtValue.class), (GenericType)GenericType.mapOf(TupleValue.class, TupleValue.class)), GenericType.mapOf((GenericType)GenericType.mapOf(DefaultUdtValue.class, DefaultUdtValue.class), (GenericType)GenericType.mapOf(DefaultTupleValue.class, DefaultTupleValue.class)), ImmutableMap.of((Object)ImmutableMap.of((Object)udtValue, (Object)udtValue), (Object)ImmutableMap.of((Object)tupleValue, (Object)tupleValue))}, {DataTypes.vectorOf((DataType)DataTypes.INT, (int)1), GenericType.vectorOf(Integer.class), GenericType.vectorOf(Integer.class), CqlVector.newInstance((Number[])new Integer[]{1})}, {DataTypes.vectorOf((DataType)DataTypes.BIGINT, (int)1), GenericType.vectorOf(Long.class), GenericType.vectorOf(Long.class), CqlVector.newInstance((Number[])new Long[]{1L})}, {DataTypes.vectorOf((DataType)DataTypes.SMALLINT, (int)1), GenericType.vectorOf(Short.class), GenericType.vectorOf(Short.class), CqlVector.newInstance((Number[])new Short[]{(short)1})}, {DataTypes.vectorOf((DataType)DataTypes.TINYINT, (int)1), GenericType.vectorOf(Byte.class), GenericType.vectorOf(Byte.class), CqlVector.newInstance((Number[])new Byte[]{(byte)1})}, {DataTypes.vectorOf((DataType)DataTypes.FLOAT, (int)1), GenericType.vectorOf(Float.class), GenericType.vectorOf(Float.class), CqlVector.newInstance((Number[])new Float[]{Float.valueOf(1.0f)})}, {DataTypes.vectorOf((DataType)DataTypes.DOUBLE, (int)1), GenericType.vectorOf(Double.class), GenericType.vectorOf(Double.class), CqlVector.newInstance((Number[])new Double[]{1.0})}, {DataTypes.vectorOf((DataType)DataTypes.DECIMAL, (int)1), GenericType.vectorOf(BigDecimal.class), GenericType.vectorOf(BigDecimal.class), CqlVector.newInstance((Number[])new BigDecimal[]{BigDecimal.ONE})}, {DataTypes.vectorOf((DataType)DataTypes.VARINT, (int)1), GenericType.vectorOf(BigInteger.class), GenericType.vectorOf(BigInteger.class), CqlVector.newInstance((Number[])new BigInteger[]{BigInteger.ONE})}};
    }

    @DataProvider
    public static Object[][] emptyCollectionsWithCqlAndJavaTypes() {
        TupleType tupleType = DataTypes.tupleOf((DataType[])new DataType[]{DataTypes.INT, DataTypes.listOf((DataType)DataTypes.TEXT)});
        UserDefinedType userType = new UserDefinedTypeBuilder(CqlIdentifier.fromInternal((String)"ks"), CqlIdentifier.fromInternal((String)"type")).withField(CqlIdentifier.fromInternal((String)"field1"), DataTypes.INT).withField(CqlIdentifier.fromInternal((String)"field2"), (DataType)DataTypes.listOf((DataType)DataTypes.TEXT)).build();
        return new Object[][]{{DataTypes.listOf((DataType)DataTypes.INT), GenericType.listOf(Integer.class), DataTypes.listOf((DataType)DataTypes.BOOLEAN), GenericType.listOf(Boolean.class), Collections.emptyList()}, {DataTypes.listOf((DataType)DataTypes.TEXT), GenericType.listOf(String.class), DataTypes.listOf((DataType)DataTypes.BOOLEAN), GenericType.listOf(Boolean.class), Collections.emptyList()}, {DataTypes.listOf((DataType)DataTypes.BLOB), GenericType.listOf(ByteBuffer.class), DataTypes.listOf((DataType)DataTypes.BOOLEAN), GenericType.listOf(Boolean.class), Collections.emptyList()}, {DataTypes.listOf((DataType)DataTypes.INET), GenericType.listOf(InetAddress.class), DataTypes.listOf((DataType)DataTypes.BOOLEAN), GenericType.listOf(Boolean.class), Collections.emptyList()}, {DataTypes.listOf((DataType)tupleType), GenericType.listOf(TupleValue.class), DataTypes.listOf((DataType)DataTypes.BOOLEAN), GenericType.listOf(Boolean.class), Collections.emptyList()}, {DataTypes.listOf((DataType)userType), GenericType.listOf(UdtValue.class), DataTypes.listOf((DataType)DataTypes.BOOLEAN), GenericType.listOf(Boolean.class), Collections.emptyList()}, {DataTypes.listOf((DataType)DataTypes.listOf((DataType)DataTypes.INT)), GenericType.listOf((GenericType)GenericType.listOf(Integer.class)), DataTypes.listOf((DataType)DataTypes.listOf((DataType)DataTypes.BOOLEAN)), GenericType.listOf((GenericType)GenericType.listOf(Boolean.class)), ImmutableList.of(Collections.emptyList())}, {DataTypes.listOf((DataType)DataTypes.listOf((DataType)tupleType)), GenericType.listOf((GenericType)GenericType.listOf(TupleValue.class)), DataTypes.listOf((DataType)DataTypes.listOf((DataType)DataTypes.BOOLEAN)), GenericType.listOf((GenericType)GenericType.listOf(Boolean.class)), ImmutableList.of(Collections.emptyList())}, {DataTypes.listOf((DataType)DataTypes.listOf((DataType)userType)), GenericType.listOf((GenericType)GenericType.listOf(UdtValue.class)), DataTypes.listOf((DataType)DataTypes.listOf((DataType)DataTypes.BOOLEAN)), GenericType.listOf((GenericType)GenericType.listOf(Boolean.class)), ImmutableList.of(Collections.emptyList())}, {DataTypes.setOf((DataType)DataTypes.INT), GenericType.setOf(Integer.class), DataTypes.setOf((DataType)DataTypes.BOOLEAN), GenericType.setOf(Boolean.class), Collections.emptySet()}, {DataTypes.setOf((DataType)DataTypes.TEXT), GenericType.setOf(String.class), DataTypes.setOf((DataType)DataTypes.BOOLEAN), GenericType.setOf(Boolean.class), Collections.emptySet()}, {DataTypes.setOf((DataType)DataTypes.BLOB), GenericType.setOf(ByteBuffer.class), DataTypes.setOf((DataType)DataTypes.BOOLEAN), GenericType.setOf(Boolean.class), Collections.emptySet()}, {DataTypes.setOf((DataType)DataTypes.INET), GenericType.setOf(InetAddress.class), DataTypes.setOf((DataType)DataTypes.BOOLEAN), GenericType.setOf(Boolean.class), Collections.emptySet()}, {DataTypes.setOf((DataType)tupleType), GenericType.setOf(TupleValue.class), DataTypes.setOf((DataType)DataTypes.BOOLEAN), GenericType.setOf(Boolean.class), Collections.emptySet()}, {DataTypes.setOf((DataType)userType), GenericType.setOf(UdtValue.class), DataTypes.setOf((DataType)DataTypes.BOOLEAN), GenericType.setOf(Boolean.class), Collections.emptySet()}, {DataTypes.setOf((DataType)DataTypes.setOf((DataType)DataTypes.INT)), GenericType.setOf((GenericType)GenericType.setOf(Integer.class)), DataTypes.setOf((DataType)DataTypes.setOf((DataType)DataTypes.BOOLEAN)), GenericType.setOf((GenericType)GenericType.setOf(Boolean.class)), ImmutableSet.of(Collections.emptySet())}, {DataTypes.setOf((DataType)DataTypes.setOf((DataType)tupleType)), GenericType.setOf((GenericType)GenericType.setOf(TupleValue.class)), DataTypes.setOf((DataType)DataTypes.setOf((DataType)DataTypes.BOOLEAN)), GenericType.setOf((GenericType)GenericType.setOf(Boolean.class)), ImmutableSet.of(Collections.emptySet())}, {DataTypes.setOf((DataType)DataTypes.setOf((DataType)userType)), GenericType.setOf((GenericType)GenericType.setOf(UdtValue.class)), DataTypes.setOf((DataType)DataTypes.setOf((DataType)DataTypes.BOOLEAN)), GenericType.setOf((GenericType)GenericType.setOf(Boolean.class)), ImmutableSet.of(Collections.emptySet())}, {DataTypes.mapOf((DataType)DataTypes.INT, (DataType)DataTypes.TEXT), GenericType.mapOf(Integer.class, String.class), DataTypes.mapOf((DataType)DataTypes.BOOLEAN, (DataType)DataTypes.BOOLEAN), GenericType.mapOf(Boolean.class, Boolean.class), Collections.emptyMap()}, {DataTypes.mapOf((DataType)DataTypes.BLOB, (DataType)DataTypes.INET), GenericType.mapOf(ByteBuffer.class, InetAddress.class), DataTypes.mapOf((DataType)DataTypes.BOOLEAN, (DataType)DataTypes.BOOLEAN), GenericType.mapOf(Boolean.class, Boolean.class), Collections.emptyMap()}, {DataTypes.mapOf((DataType)tupleType, (DataType)tupleType), GenericType.mapOf(TupleValue.class, TupleValue.class), DataTypes.mapOf((DataType)DataTypes.BOOLEAN, (DataType)DataTypes.BOOLEAN), GenericType.mapOf(Boolean.class, Boolean.class), Collections.emptyMap()}, {DataTypes.mapOf((DataType)userType, (DataType)userType), GenericType.mapOf(UdtValue.class, UdtValue.class), DataTypes.mapOf((DataType)DataTypes.BOOLEAN, (DataType)DataTypes.BOOLEAN), GenericType.mapOf(Boolean.class, Boolean.class), Collections.emptyMap()}, {DataTypes.mapOf((DataType)DataTypes.UUID, (DataType)DataTypes.mapOf((DataType)DataTypes.INT, (DataType)DataTypes.TEXT)), GenericType.mapOf((GenericType)GenericType.UUID, (GenericType)GenericType.mapOf(Integer.class, String.class)), DataTypes.mapOf((DataType)DataTypes.UUID, (DataType)DataTypes.mapOf((DataType)DataTypes.BOOLEAN, (DataType)DataTypes.BOOLEAN)), GenericType.mapOf((GenericType)GenericType.UUID, (GenericType)GenericType.mapOf(Boolean.class, Boolean.class)), ImmutableMap.of((Object)UUID.randomUUID(), Collections.emptyMap())}, {DataTypes.mapOf((DataType)DataTypes.mapOf((DataType)DataTypes.INT, (DataType)DataTypes.TEXT), (DataType)DataTypes.UUID), GenericType.mapOf((GenericType)GenericType.mapOf(Integer.class, String.class), (GenericType)GenericType.UUID), DataTypes.mapOf((DataType)DataTypes.mapOf((DataType)DataTypes.BOOLEAN, (DataType)DataTypes.BOOLEAN), (DataType)DataTypes.UUID), GenericType.mapOf((GenericType)GenericType.mapOf(Boolean.class, Boolean.class), (GenericType)GenericType.UUID), ImmutableMap.of(Collections.emptyMap(), (Object)UUID.randomUUID())}, {DataTypes.mapOf((DataType)DataTypes.mapOf((DataType)userType, (DataType)userType), (DataType)DataTypes.mapOf((DataType)tupleType, (DataType)tupleType)), GenericType.mapOf((GenericType)GenericType.mapOf(UdtValue.class, UdtValue.class), (GenericType)GenericType.mapOf(TupleValue.class, TupleValue.class)), DataTypes.mapOf((DataType)DataTypes.mapOf((DataType)DataTypes.BOOLEAN, (DataType)DataTypes.BOOLEAN), (DataType)DataTypes.mapOf((DataType)DataTypes.BOOLEAN, (DataType)DataTypes.BOOLEAN)), GenericType.mapOf((GenericType)GenericType.mapOf(Boolean.class, Boolean.class), (GenericType)GenericType.mapOf(Boolean.class, Boolean.class)), ImmutableMap.of(Collections.emptyMap(), Collections.emptyMap())}};
    }

    @DataProvider
    public static Object[][] collectionsWithNullElements() {
        return new Object[][]{{Collections.singletonList(null), "Can't infer list codec because the first element is null (note that CQL does not allow null values in collections)"}, {Collections.singleton(null), "Can't infer set codec because the first element is null (note that CQL does not allow null values in collections)"}, {Collections.singletonMap("foo", null), "Can't infer map codec because the first key and/or value is null (note that CQL does not allow null values in collections)"}, {Collections.singletonMap(null, "foo"), "Can't infer map codec because the first key and/or value is null (note that CQL does not allow null values in collections)"}, {Collections.singletonMap(null, null), "Can't infer map codec because the first key and/or value is null (note that CQL does not allow null values in collections)"}};
    }

    @DataProvider
    public static Object[][] tuplesWithCqlTypes() {
        TupleType tupleType1 = DataTypes.tupleOf((DataType[])new DataType[]{DataTypes.INT, DataTypes.TEXT});
        TupleType tupleType2 = DataTypes.tupleOf((DataType[])new DataType[]{DataTypes.INT, DataTypes.listOf((DataType)DataTypes.TEXT)});
        TupleType tupleType3 = DataTypes.tupleOf((DataType[])new DataType[]{DataTypes.mapOf((DataType)tupleType1, (DataType)tupleType2)});
        TupleValue tupleValue1 = tupleType1.newValue(new Object[]{42, "foo"});
        TupleValue tupleValue2 = tupleType2.newValue(new Object[]{42, ImmutableList.of((Object)"foo", (Object)"bar")});
        return new Object[][]{{tupleType1, tupleType1.newValue()}, {tupleType1, tupleValue1}, {tupleType2, tupleType2.newValue()}, {tupleType2, tupleValue2}, {tupleType3, tupleType3.newValue()}, {tupleType3, tupleType3.newValue(new Object[]{ImmutableMap.of((Object)tupleValue1, (Object)tupleValue2)})}};
    }

    @DataProvider
    public static Object[][] udtsWithCqlTypes() {
        UserDefinedType userType1 = new UserDefinedTypeBuilder(CqlIdentifier.fromInternal((String)"ks"), CqlIdentifier.fromInternal((String)"type")).withField(CqlIdentifier.fromInternal((String)"field1"), DataTypes.INT).withField(CqlIdentifier.fromInternal((String)"field2"), DataTypes.TEXT).build();
        UserDefinedType userType2 = new UserDefinedTypeBuilder(CqlIdentifier.fromInternal((String)"ks"), CqlIdentifier.fromInternal((String)"type")).withField(CqlIdentifier.fromInternal((String)"field1"), (DataType)DataTypes.setOf((DataType)DataTypes.BIGINT)).withField(CqlIdentifier.fromInternal((String)"field2"), (DataType)DataTypes.listOf((DataType)DataTypes.TEXT)).build();
        UserDefinedType userType3 = new UserDefinedTypeBuilder(CqlIdentifier.fromInternal((String)"ks"), CqlIdentifier.fromInternal((String)"type")).withField(CqlIdentifier.fromInternal((String)"field1"), (DataType)DataTypes.mapOf((DataType)userType1, (DataType)userType2)).build();
        UdtValue userValue1 = userType1.newValue(new Object[]{42, "foo"});
        UdtValue userValue2 = userType2.newValue(new Object[]{ImmutableSet.of((Object)24L, (Object)43L), ImmutableList.of((Object)"foo", (Object)"bar")});
        return new Object[][]{{userType1, userType1.newValue()}, {userType1, userValue1}, {userType2, userType2.newValue()}, {userType2, userValue2}, {userType3, userType3.newValue()}, {userType3, userType3.newValue(new Object[]{ImmutableMap.of((Object)userValue1, (Object)userValue2)})}};
    }
}

