/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.type.codec.registry;

import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.data.TupleValue;
import com.datastax.oss.driver.api.core.data.UdtValue;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.DataTypes;
import com.datastax.oss.driver.api.core.type.ListType;
import com.datastax.oss.driver.api.core.type.codec.CodecNotFoundException;
import com.datastax.oss.driver.api.core.type.codec.TypeCodec;
import com.datastax.oss.driver.api.core.type.codec.TypeCodecs;
import com.datastax.oss.driver.api.core.type.codec.registry.CodecRegistry;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import com.datastax.oss.driver.internal.core.data.DefaultTupleValue;
import com.datastax.oss.driver.internal.core.data.DefaultUdtValue;
import com.datastax.oss.driver.internal.core.type.codec.CqlIntToStringCodec;
import com.datastax.oss.driver.internal.core.type.codec.IntCodec;
import com.datastax.oss.driver.internal.core.type.codec.ListCodec;
import com.datastax.oss.driver.internal.core.type.codec.registry.CachingCodecRegistry;
import com.datastax.oss.driver.internal.core.type.codec.registry.CachingCodecRegistryTestDataProviders;
import com.datastax.oss.driver.internal.core.type.codec.registry.CodecRegistryConstants;
import com.datastax.oss.driver.shaded.guava.common.collect.Lists;
import com.tngtech.java.junit.dataprovider.DataProviderRunner;
import com.tngtech.java.junit.dataprovider.UseDataProvider;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.nio.ByteBuffer;
import java.time.Period;
import java.util.ArrayList;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InOrder;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

@RunWith(value=DataProviderRunner.class)
public class CachingCodecRegistryTest {
    @Mock
    private TestCachingCodecRegistry.MockCache mockCache;

    @Before
    public void setup() {
        MockitoAnnotations.initMocks((Object)this);
    }

    @Test
    @UseDataProvider(value="primitiveCodecs", location={CachingCodecRegistryTestDataProviders.class})
    public void should_find_primitive_codecs_for_types(TypeCodec<?> codec) {
        TestCachingCodecRegistry registry = new TestCachingCodecRegistry(this.mockCache);
        DataType cqlType = codec.getCqlType();
        GenericType javaType = codec.getJavaType();
        Assertions.assertThat((Object)registry.codecFor(cqlType, javaType)).isSameAs(codec);
        Assertions.assertThat((Object)registry.codecFor(cqlType)).isSameAs(codec);
        Assertions.assertThat((Object)javaType.__getToken().getType()).isInstanceOf(Class.class);
        Class javaClass = (Class)javaType.__getToken().getType();
        Assertions.assertThat((Object)registry.codecFor(cqlType, javaClass)).isSameAs(codec);
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.mockCache});
    }

    @Test
    @UseDataProvider(value="primitiveCodecsWithValues", location={CachingCodecRegistryTestDataProviders.class})
    public void should_find_primitive_codecs_for_value(Object value, TypeCodec<?> codec) {
        TestCachingCodecRegistry registry = new TestCachingCodecRegistry(this.mockCache);
        Assertions.assertThat((Object)registry.codecFor(value)).isEqualTo(codec);
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.mockCache});
    }

    @Test
    @UseDataProvider(value="primitiveCodecsWithCqlTypesAndValues", location={CachingCodecRegistryTestDataProviders.class})
    public void should_find_primitive_codecs_for_cql_type_and_value(DataType cqlType, Object value, TypeCodec<?> codec) {
        TestCachingCodecRegistry registry = new TestCachingCodecRegistry(this.mockCache);
        Assertions.assertThat((Object)registry.codecFor(cqlType, value)).isEqualTo(codec);
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.mockCache});
    }

    @Test
    public void should_find_user_codec_for_built_in_java_type() {
        CqlIntToStringCodec intToStringCodec1 = new CqlIntToStringCodec();
        CqlIntToStringCodec intToStringCodec2 = new CqlIntToStringCodec();
        TestCachingCodecRegistry registry = new TestCachingCodecRegistry(this.mockCache);
        registry.register(new TypeCodec[]{intToStringCodec1, intToStringCodec2});
        ((TestCachingCodecRegistry.MockCache)Mockito.verify((Object)this.mockCache)).lookup(DataTypes.INT, GenericType.STRING, false);
        Assertions.assertThat((Object)registry.codecFor(DataTypes.INT, GenericType.STRING)).isSameAs((Object)intToStringCodec1);
        Assertions.assertThat((Object)registry.codecFor(DataTypes.INT, String.class)).isSameAs((Object)intToStringCodec1);
        Assertions.assertThat((Object)registry.codecFor(DataTypes.INT, "123")).isSameAs((Object)intToStringCodec1);
        Assertions.assertThat((Object)registry.codecFor(DataTypes.INT)).isSameAs((Object)TypeCodecs.INT);
        Assertions.assertThat((Object)registry.codecFor("123")).isSameAs((Object)TypeCodecs.TEXT);
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.mockCache});
    }

    @Test
    public void should_find_user_codec_for_custom_java_type() {
        TextToPeriodCodec textToPeriodCodec1 = new TextToPeriodCodec();
        TextToPeriodCodec textToPeriodCodec2 = new TextToPeriodCodec();
        TestCachingCodecRegistry registry = new TestCachingCodecRegistry(this.mockCache);
        registry.register(new TypeCodec[]{textToPeriodCodec1, textToPeriodCodec2});
        ((TestCachingCodecRegistry.MockCache)Mockito.verify((Object)this.mockCache)).lookup(DataTypes.TEXT, GenericType.of(Period.class), false);
        Assertions.assertThat((Object)registry.codecFor(DataTypes.TEXT, GenericType.of(Period.class))).isSameAs((Object)textToPeriodCodec1);
        Assertions.assertThat((Object)registry.codecFor(DataTypes.TEXT, Period.class)).isSameAs((Object)textToPeriodCodec1);
        Assertions.assertThat((Object)registry.codecFor(DataTypes.TEXT, Period.ofDays(1))).isSameAs((Object)textToPeriodCodec1);
        Assertions.assertThat((Object)registry.codecFor(Period.ofDays(1))).isSameAs((Object)textToPeriodCodec1);
        Assertions.assertThat((Object)registry.codecFor(DataTypes.TEXT)).isSameAs((Object)TypeCodecs.TEXT);
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.mockCache});
    }

    @Test
    @UseDataProvider(value="collectionsWithCqlAndJavaTypes", location={CachingCodecRegistryTestDataProviders.class})
    public void should_create_collection_codec_for_cql_and_java_types(DataType cqlType, GenericType<?> javaType, Object value) {
        TestCachingCodecRegistry registry = new TestCachingCodecRegistry(this.mockCache);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockCache});
        TypeCodec codec = registry.codecFor(cqlType, javaType);
        Assertions.assertThat((Object)codec).isNotNull();
        Assertions.assertThat((boolean)codec.accepts(cqlType)).isTrue();
        Assertions.assertThat((boolean)codec.accepts(javaType)).isTrue();
        Assertions.assertThat((boolean)codec.accepts(value)).isTrue();
        ((TestCachingCodecRegistry.MockCache)inOrder.verify((Object)this.mockCache)).lookup(cqlType, javaType, false);
    }

    @Test
    @UseDataProvider(value="collectionsWithCqlAndJavaTypes", location={CachingCodecRegistryTestDataProviders.class})
    public void should_create_collection_codec_for_cql_type(DataType cqlType, GenericType<?> javaType, Object value) {
        TestCachingCodecRegistry registry = new TestCachingCodecRegistry(this.mockCache);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockCache});
        TypeCodec codec = registry.codecFor(cqlType);
        Assertions.assertThat((Object)codec).isNotNull();
        Assertions.assertThat((boolean)codec.accepts(cqlType)).isTrue();
        Assertions.assertThat((boolean)codec.accepts(javaType)).isTrue();
        Assertions.assertThat((boolean)codec.accepts(value)).isTrue();
        ((TestCachingCodecRegistry.MockCache)inOrder.verify((Object)this.mockCache)).lookup(cqlType, null, false);
    }

    @Test
    @UseDataProvider(value="collectionsWithCqlAndJavaTypes", location={CachingCodecRegistryTestDataProviders.class})
    public void should_create_collection_codec_for_cql_type_and_java_value(DataType cqlType, GenericType<?> javaType, GenericType<?> javaTypeLookup, Object value) {
        TestCachingCodecRegistry registry = new TestCachingCodecRegistry(this.mockCache);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockCache});
        TypeCodec codec = registry.codecFor(cqlType, value);
        Assertions.assertThat((Object)codec).isNotNull();
        Assertions.assertThat((boolean)codec.accepts(cqlType)).isTrue();
        Assertions.assertThat((boolean)codec.accepts(javaType)).isTrue();
        Assertions.assertThat((boolean)codec.accepts(value)).isTrue();
        ((TestCachingCodecRegistry.MockCache)inOrder.verify((Object)this.mockCache)).lookup(cqlType, javaTypeLookup, true);
    }

    @Test
    @UseDataProvider(value="collectionsWithCqlAndJavaTypes", location={CachingCodecRegistryTestDataProviders.class})
    public void should_create_collection_codec_for_java_value(DataType cqlType, GenericType<?> javaType, GenericType<?> javaTypeLookup, Object value) {
        TestCachingCodecRegistry registry = new TestCachingCodecRegistry(this.mockCache);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockCache});
        TypeCodec codec = registry.codecFor(value);
        Assertions.assertThat((Object)codec).isNotNull();
        Assertions.assertThat((boolean)codec.accepts(cqlType)).isTrue();
        Assertions.assertThat((boolean)codec.accepts(javaType)).isTrue();
        Assertions.assertThat((boolean)codec.accepts(value)).isTrue();
        ((TestCachingCodecRegistry.MockCache)inOrder.verify((Object)this.mockCache)).lookup(cqlType, javaTypeLookup, true);
    }

    @Test
    @UseDataProvider(value="emptyCollectionsWithCqlAndJavaTypes", location={CachingCodecRegistryTestDataProviders.class})
    public void should_create_collection_codec_for_empty_java_value(DataType cqlType, GenericType<?> javaType, DataType cqlTypeLookup, GenericType<?> javaTypeLookup, Object value) {
        TestCachingCodecRegistry registry = new TestCachingCodecRegistry(this.mockCache);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockCache});
        TypeCodec codec = registry.codecFor(value);
        Assertions.assertThat((Object)codec).isNotNull();
        Assertions.assertThat((boolean)codec.accepts(cqlType)).isFalse();
        Assertions.assertThat((boolean)codec.accepts(javaType)).isFalse();
        Assertions.assertThat((boolean)codec.accepts(value)).isTrue();
        codec.encode(value, ProtocolVersion.DEFAULT);
        ((TestCachingCodecRegistry.MockCache)inOrder.verify((Object)this.mockCache)).lookup(cqlTypeLookup, javaTypeLookup, true);
    }

    @Test
    @UseDataProvider(value="emptyCollectionsWithCqlAndJavaTypes", location={CachingCodecRegistryTestDataProviders.class})
    public void should_create_collection_codec_for_cql_type_and_empty_java_value(DataType cqlType, GenericType<?> javaType, Object value) {
        TestCachingCodecRegistry registry = new TestCachingCodecRegistry(this.mockCache);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockCache});
        TypeCodec codec = registry.codecFor(cqlType, value);
        Assertions.assertThat((Object)codec).isNotNull();
        Assertions.assertThat((boolean)codec.accepts(cqlType)).isTrue();
        Assertions.assertThat((boolean)codec.accepts(javaType)).isTrue();
        Assertions.assertThat((boolean)codec.accepts(value)).isTrue();
        codec.encode(value, ProtocolVersion.DEFAULT);
        ((TestCachingCodecRegistry.MockCache)inOrder.verify((Object)this.mockCache)).lookup(cqlType, javaType, true);
    }

    @Test
    @UseDataProvider(value="collectionsWithNullElements", location={CachingCodecRegistryTestDataProviders.class})
    public void should_throw_for_collection_containing_null_element(Object value, String expected) {
        TestCachingCodecRegistry registry = new TestCachingCodecRegistry(this.mockCache);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> registry.codecFor(value)).isInstanceOf(IllegalArgumentException.class)).hasMessage(expected);
    }

    @Test
    @UseDataProvider(value="tuplesWithCqlTypes", location={CachingCodecRegistryTestDataProviders.class})
    public void should_create_tuple_codec_for_cql_and_java_types(DataType cqlType, Object value) {
        TestCachingCodecRegistry registry = new TestCachingCodecRegistry(this.mockCache);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockCache});
        TypeCodec codec = registry.codecFor(cqlType, GenericType.TUPLE_VALUE);
        Assertions.assertThat((Object)codec).isNotNull();
        Assertions.assertThat((boolean)codec.accepts(cqlType)).isTrue();
        Assertions.assertThat((boolean)codec.accepts(GenericType.TUPLE_VALUE)).isTrue();
        Assertions.assertThat((boolean)codec.accepts(TupleValue.class)).isTrue();
        Assertions.assertThat((boolean)codec.accepts(value)).isTrue();
        ((TestCachingCodecRegistry.MockCache)inOrder.verify((Object)this.mockCache)).lookup(cqlType, GenericType.TUPLE_VALUE, false);
    }

    @Test
    @UseDataProvider(value="tuplesWithCqlTypes", location={CachingCodecRegistryTestDataProviders.class})
    public void should_create_tuple_codec_for_cql_type(DataType cqlType, Object value) {
        TestCachingCodecRegistry registry = new TestCachingCodecRegistry(this.mockCache);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockCache});
        TypeCodec codec = registry.codecFor(cqlType);
        Assertions.assertThat((Object)codec).isNotNull();
        Assertions.assertThat((boolean)codec.accepts(cqlType)).isTrue();
        Assertions.assertThat((boolean)codec.accepts(GenericType.TUPLE_VALUE)).isTrue();
        Assertions.assertThat((boolean)codec.accepts(TupleValue.class)).isTrue();
        Assertions.assertThat((boolean)codec.accepts(value)).isTrue();
        ((TestCachingCodecRegistry.MockCache)inOrder.verify((Object)this.mockCache)).lookup(cqlType, null, false);
    }

    @Test
    @UseDataProvider(value="tuplesWithCqlTypes", location={CachingCodecRegistryTestDataProviders.class})
    public void should_create_tuple_codec_for_cql_type_and_java_value(DataType cqlType, Object value) {
        TestCachingCodecRegistry registry = new TestCachingCodecRegistry(this.mockCache);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockCache});
        TypeCodec codec = registry.codecFor(cqlType, value);
        Assertions.assertThat((Object)codec).isNotNull();
        Assertions.assertThat((boolean)codec.accepts(cqlType)).isTrue();
        Assertions.assertThat((boolean)codec.accepts(GenericType.TUPLE_VALUE)).isTrue();
        Assertions.assertThat((boolean)codec.accepts(TupleValue.class)).isTrue();
        Assertions.assertThat((boolean)codec.accepts(value)).isTrue();
        ((TestCachingCodecRegistry.MockCache)inOrder.verify((Object)this.mockCache)).lookup(cqlType, GenericType.of(DefaultTupleValue.class), true);
        inOrder.verifyNoMoreInteractions();
    }

    @Test
    @UseDataProvider(value="tuplesWithCqlTypes", location={CachingCodecRegistryTestDataProviders.class})
    public void should_create_tuple_codec_for_java_value(DataType cqlType, Object value) {
        TestCachingCodecRegistry registry = new TestCachingCodecRegistry(this.mockCache);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockCache});
        TypeCodec codec = registry.codecFor(value);
        Assertions.assertThat((Object)codec).isNotNull();
        Assertions.assertThat((boolean)codec.accepts(cqlType)).isTrue();
        Assertions.assertThat((boolean)codec.accepts(GenericType.TUPLE_VALUE)).isTrue();
        Assertions.assertThat((boolean)codec.accepts(TupleValue.class)).isTrue();
        Assertions.assertThat((boolean)codec.accepts(value)).isTrue();
        ((TestCachingCodecRegistry.MockCache)inOrder.verify((Object)this.mockCache)).lookup(cqlType, GenericType.of(DefaultTupleValue.class), true);
        inOrder.verifyNoMoreInteractions();
    }

    @Test
    @UseDataProvider(value="udtsWithCqlTypes", location={CachingCodecRegistryTestDataProviders.class})
    public void should_create_udt_codec_for_cql_and_java_types(DataType cqlType, Object value) {
        TestCachingCodecRegistry registry = new TestCachingCodecRegistry(this.mockCache);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockCache});
        TypeCodec codec = registry.codecFor(cqlType, GenericType.UDT_VALUE);
        Assertions.assertThat((Object)codec).isNotNull();
        Assertions.assertThat((boolean)codec.accepts(cqlType)).isTrue();
        Assertions.assertThat((boolean)codec.accepts(GenericType.UDT_VALUE)).isTrue();
        Assertions.assertThat((boolean)codec.accepts(UdtValue.class)).isTrue();
        Assertions.assertThat((boolean)codec.accepts(value)).isTrue();
        ((TestCachingCodecRegistry.MockCache)inOrder.verify((Object)this.mockCache)).lookup(cqlType, GenericType.UDT_VALUE, false);
    }

    @Test
    @UseDataProvider(value="udtsWithCqlTypes", location={CachingCodecRegistryTestDataProviders.class})
    public void should_create_udt_codec_for_cql_type(DataType cqlType, Object value) {
        TestCachingCodecRegistry registry = new TestCachingCodecRegistry(this.mockCache);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockCache});
        TypeCodec codec = registry.codecFor(cqlType);
        Assertions.assertThat((Object)codec).isNotNull();
        Assertions.assertThat((boolean)codec.accepts(cqlType)).isTrue();
        Assertions.assertThat((boolean)codec.accepts(GenericType.UDT_VALUE)).isTrue();
        Assertions.assertThat((boolean)codec.accepts(UdtValue.class)).isTrue();
        Assertions.assertThat((boolean)codec.accepts(value)).isTrue();
        ((TestCachingCodecRegistry.MockCache)inOrder.verify((Object)this.mockCache)).lookup(cqlType, null, false);
    }

    @Test
    @UseDataProvider(value="udtsWithCqlTypes", location={CachingCodecRegistryTestDataProviders.class})
    public void should_create_udt_codec_for_cql_type_and_java_value(DataType cqlType, Object value) {
        TestCachingCodecRegistry registry = new TestCachingCodecRegistry(this.mockCache);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockCache});
        TypeCodec codec = registry.codecFor(cqlType, value);
        Assertions.assertThat((Object)codec).isNotNull();
        Assertions.assertThat((boolean)codec.accepts(cqlType)).isTrue();
        Assertions.assertThat((boolean)codec.accepts(GenericType.UDT_VALUE)).isTrue();
        Assertions.assertThat((boolean)codec.accepts(UdtValue.class)).isTrue();
        Assertions.assertThat((boolean)codec.accepts(value)).isTrue();
        ((TestCachingCodecRegistry.MockCache)inOrder.verify((Object)this.mockCache)).lookup(cqlType, GenericType.of(DefaultUdtValue.class), true);
        inOrder.verifyNoMoreInteractions();
    }

    @Test
    @UseDataProvider(value="udtsWithCqlTypes", location={CachingCodecRegistryTestDataProviders.class})
    public void should_create_udt_codec_for_java_value(DataType cqlType, Object value) {
        TestCachingCodecRegistry registry = new TestCachingCodecRegistry(this.mockCache);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockCache});
        TypeCodec codec = registry.codecFor(value);
        Assertions.assertThat((Object)codec).isNotNull();
        Assertions.assertThat((boolean)codec.accepts(cqlType)).isTrue();
        Assertions.assertThat((boolean)codec.accepts(GenericType.UDT_VALUE)).isTrue();
        Assertions.assertThat((boolean)codec.accepts(UdtValue.class)).isTrue();
        Assertions.assertThat((boolean)codec.accepts(value)).isTrue();
        ((TestCachingCodecRegistry.MockCache)inOrder.verify((Object)this.mockCache)).lookup(cqlType, GenericType.of(DefaultUdtValue.class), true);
        inOrder.verifyNoMoreInteractions();
    }

    @Test
    public void should_not_find_codec_if_java_type_unknown() {
        try {
            CodecRegistry.DEFAULT.codecFor(StringBuilder.class);
            Assertions.fail((String)"Should not have found a codec for ANY <-> StringBuilder");
        }
        catch (CodecNotFoundException codecNotFoundException) {
            // empty catch block
        }
        try {
            CodecRegistry.DEFAULT.codecFor(DataTypes.TEXT, StringBuilder.class);
            Assertions.fail((String)"Should not have found a codec for varchar <-> StringBuilder");
        }
        catch (CodecNotFoundException codecNotFoundException) {
            // empty catch block
        }
        try {
            CodecRegistry.DEFAULT.codecFor((Object)new StringBuilder());
            Assertions.fail((String)"Should not have found a codec for ANY <-> StringBuilder");
        }
        catch (CodecNotFoundException codecNotFoundException) {
            // empty catch block
        }
    }

    @Test
    public void should_not_allow_covariance_for_lookups_by_java_type() {
        TestCachingCodecRegistry registry = new TestCachingCodecRegistry(this.mockCache);
        registry.register(new ACodec());
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockCache});
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> registry.codecFor(B.class)).isInstanceOf(CodecNotFoundException.class)).hasMessage("Codec not found for requested operation: [null <-> %s]", new Object[]{B.class.getName()});
        ((TestCachingCodecRegistry.MockCache)inOrder.verify((Object)this.mockCache)).lookup(null, GenericType.of(B.class), false);
        inOrder.verifyNoMoreInteractions();
        Assertions.assertThatThrownBy(() -> registry.codecFor(GenericType.listOf(B.class))).isInstanceOf(CodecNotFoundException.class);
        ((TestCachingCodecRegistry.MockCache)inOrder.verify((Object)this.mockCache)).lookup(null, GenericType.listOf(B.class), false);
        ((TestCachingCodecRegistry.MockCache)inOrder.verify((Object)this.mockCache)).lookup(null, GenericType.of(B.class), false);
        inOrder.verifyNoMoreInteractions();
    }

    @Test
    public void should_allow_covariance_for_lookups_by_cql_type_and_value() {
        TestCachingCodecRegistry registry = new TestCachingCodecRegistry(this.mockCache);
        registry.register(new ACodec());
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockCache});
        ((TestCachingCodecRegistry.MockCache)inOrder.verify((Object)this.mockCache)).lookup(DataTypes.INT, GenericType.of(A.class), false);
        Assertions.assertThat((Object)registry.codecFor(DataTypes.INT, new B())).isInstanceOf(ACodec.class);
        inOrder.verifyNoMoreInteractions();
        ArrayList list = Lists.newArrayList((Object[])new B[]{new B()});
        ListType cqlType = DataTypes.listOf((DataType)DataTypes.INT);
        TypeCodec actual = registry.codecFor((DataType)cqlType, list);
        Assertions.assertThat((Object)actual).isInstanceOf(ListCodec.class);
        Assertions.assertThat((Object)actual.getJavaType()).isEqualTo((Object)GenericType.listOf(A.class));
        Assertions.assertThat((boolean)actual.accepts((Object)list)).isTrue();
        Assertions.assertThat((boolean)actual.accepts(GenericType.listOf(B.class))).isFalse();
        ((TestCachingCodecRegistry.MockCache)inOrder.verify((Object)this.mockCache)).lookup((DataType)cqlType, GenericType.listOf(B.class), true);
        inOrder.verifyNoMoreInteractions();
    }

    @Test
    public void should_allow_covariance_for_lookups_by_value() {
        TestCachingCodecRegistry registry = new TestCachingCodecRegistry(this.mockCache);
        registry.register(new ACodec());
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockCache});
        ((TestCachingCodecRegistry.MockCache)inOrder.verify((Object)this.mockCache)).lookup(DataTypes.INT, GenericType.of(A.class), false);
        Assertions.assertThat((Object)registry.codecFor(new B())).isInstanceOf(ACodec.class);
        inOrder.verifyNoMoreInteractions();
        ArrayList list = Lists.newArrayList((Object[])new B[]{new B()});
        TypeCodec actual = registry.codecFor(list);
        Assertions.assertThat((Object)actual).isInstanceOf(ListCodec.class);
        Assertions.assertThat((Object)actual.getJavaType()).isEqualTo((Object)GenericType.listOf(A.class));
        Assertions.assertThat((boolean)actual.accepts((Object)list)).isTrue();
        Assertions.assertThat((boolean)actual.accepts(GenericType.listOf(B.class))).isFalse();
        ((TestCachingCodecRegistry.MockCache)inOrder.verify((Object)this.mockCache)).lookup(null, GenericType.listOf(B.class), true);
        inOrder.verifyNoMoreInteractions();
    }

    @Test
    public void should_register_user_codec_at_runtime() {
        CqlIntToStringCodec intToStringCodec = new CqlIntToStringCodec();
        TestCachingCodecRegistry registry = new TestCachingCodecRegistry(this.mockCache);
        registry.register((TypeCodec)intToStringCodec);
        ((TestCachingCodecRegistry.MockCache)Mockito.verify((Object)this.mockCache)).lookup(DataTypes.INT, GenericType.STRING, false);
        Assertions.assertThat((Object)registry.codecFor(DataTypes.INT, GenericType.STRING)).isSameAs((Object)intToStringCodec);
        Assertions.assertThat((Object)registry.codecFor(DataTypes.INT, String.class)).isSameAs((Object)intToStringCodec);
        Assertions.assertThat((Object)registry.codecFor(DataTypes.INT, "123")).isSameAs((Object)intToStringCodec);
        Assertions.assertThat((Object)registry.codecFor(DataTypes.INT)).isSameAs((Object)TypeCodecs.INT);
        Assertions.assertThat((Object)registry.codecFor("123")).isSameAs((Object)TypeCodecs.TEXT);
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.mockCache});
    }

    @Test
    public void should_ignore_user_codec_if_collides_with_builtin_codec() {
        TestCachingCodecRegistry registry = new TestCachingCodecRegistry(this.mockCache);
        IntCodec userIntCodec = new IntCodec();
        registry.register((TypeCodec)userIntCodec);
        Assertions.assertThat((Object)registry.codecFor(DataTypes.INT, Integer.class)).isNotSameAs((Object)userIntCodec);
    }

    @Test
    public void should_ignore_user_codec_if_collides_with_other_user_codec() {
        TestCachingCodecRegistry registry = new TestCachingCodecRegistry(this.mockCache);
        CqlIntToStringCodec intToStringCodec1 = new CqlIntToStringCodec();
        CqlIntToStringCodec intToStringCodec2 = new CqlIntToStringCodec();
        registry.register(new TypeCodec[]{intToStringCodec1, intToStringCodec2});
        Assertions.assertThat((Object)registry.codecFor(DataTypes.INT, GenericType.STRING)).isSameAs((Object)intToStringCodec1);
    }

    @Test
    public void should_ignore_user_codec_if_collides_with_generated_codec() {
        TestCachingCodecRegistry registry = new TestCachingCodecRegistry(this.mockCache);
        TypeCodec userListOfIntCodec = TypeCodecs.listOf((TypeCodec)TypeCodecs.INT);
        registry.register(userListOfIntCodec);
        Assertions.assertThat((Object)registry.codecFor((DataType)DataTypes.listOf((DataType)DataTypes.INT), GenericType.listOf(Integer.class))).isNotSameAs((Object)userListOfIntCodec);
    }

    private static class ACodec
    implements TypeCodec<A> {
        private ACodec() {
        }

        @NonNull
        public GenericType<A> getJavaType() {
            return GenericType.of(A.class);
        }

        @NonNull
        public DataType getCqlType() {
            return DataTypes.INT;
        }

        public ByteBuffer encode(A value, @NonNull ProtocolVersion protocolVersion) {
            throw new UnsupportedOperationException("irrelevant");
        }

        public A decode(ByteBuffer bytes, @NonNull ProtocolVersion protocolVersion) {
            throw new UnsupportedOperationException("irrelevant");
        }

        @NonNull
        public String format(A value) {
            throw new UnsupportedOperationException("irrelevant");
        }

        public A parse(String value) {
            throw new UnsupportedOperationException("irrelevant");
        }
    }

    private static class B
    extends A {
        private B() {
        }
    }

    private static class A {
        private A() {
        }
    }

    public static class TextToPeriodCodec
    implements TypeCodec<Period> {
        @NonNull
        public GenericType<Period> getJavaType() {
            return GenericType.of(Period.class);
        }

        @NonNull
        public DataType getCqlType() {
            return DataTypes.TEXT;
        }

        public ByteBuffer encode(Period value, @NonNull ProtocolVersion protocolVersion) {
            throw new UnsupportedOperationException("not implemented for this test");
        }

        public Period decode(ByteBuffer bytes, @NonNull ProtocolVersion protocolVersion) {
            throw new UnsupportedOperationException("not implemented for this test");
        }

        @NonNull
        public String format(Period value) {
            throw new UnsupportedOperationException("not implemented for this test");
        }

        public Period parse(String value) {
            throw new UnsupportedOperationException("not implemented for this test");
        }
    }

    public static class TestCachingCodecRegistry
    extends CachingCodecRegistry {
        private final MockCache cache;

        TestCachingCodecRegistry(MockCache cache) {
            super("test", CodecRegistryConstants.PRIMITIVE_CODECS);
            this.cache = cache;
        }

        protected TypeCodec<?> getCachedCodec(@Nullable DataType cqlType, @Nullable GenericType<?> javaType, boolean isJavaCovariant) {
            this.cache.lookup(cqlType, javaType, isJavaCovariant);
            return this.createCodec(cqlType, javaType, isJavaCovariant);
        }

        public static interface MockCache {
            public void lookup(@Nullable DataType var1, @Nullable GenericType<?> var2, boolean var3);
        }
    }
}

