/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.type.codec.extras.time;

import com.datastax.oss.driver.api.core.type.codec.ExtraTypeCodecs;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import com.datastax.oss.driver.internal.core.type.codec.CodecTestBase;
import com.datastax.oss.driver.internal.core.type.codec.TimestampCodecTest;
import com.tngtech.java.junit.dataprovider.DataProviderRunner;
import com.tngtech.java.junit.dataprovider.UseDataProvider;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DataProviderRunner.class)
public class TimestampMillisCodecTest
extends CodecTestBase<Long> {
    @Test
    public void should_encode() {
        this.codec = ExtraTypeCodecs.TIMESTAMP_MILLIS_UTC;
        Assertions.assertThat((String)this.encode(0L)).isEqualTo("0x0000000000000000");
        Assertions.assertThat((String)this.encode(128L)).isEqualTo("0x0000000000000080");
        Assertions.assertThat((String)this.encode(null)).isNull();
    }

    @Test
    public void should_decode() {
        this.codec = ExtraTypeCodecs.TIMESTAMP_MILLIS_UTC;
        Assertions.assertThat((Long)((Long)this.decode("0x0000000000000000"))).isEqualTo(0L);
        Assertions.assertThat((Long)((Long)this.decode("0x0000000000000080"))).isEqualTo(128L);
        Assertions.assertThat((Long)((Long)this.decode(null))).isNull();
    }

    @Test(expected=IllegalArgumentException.class)
    public void should_fail_to_decode_if_not_enough_bytes() {
        this.codec = ExtraTypeCodecs.TIMESTAMP_MILLIS_SYSTEM;
        this.decode("0x0000");
    }

    @Test(expected=IllegalArgumentException.class)
    public void should_fail_to_decode_if_too_many_bytes() {
        this.codec = ExtraTypeCodecs.TIMESTAMP_MILLIS_SYSTEM;
        this.decode("0x00000000000000000000");
    }

    @Test
    public void should_format() {
        this.codec = ExtraTypeCodecs.timestampMillisAt((ZoneId)ZoneOffset.ofHours(2));
        Assertions.assertThat((String)this.format(0L)).isEqualTo("'1970-01-01T02:00:00.000+02:00'");
        Assertions.assertThat((String)this.format(1534435174123L)).isEqualTo("'2018-08-16T17:59:34.123+02:00'");
        Assertions.assertThat((String)this.format(null)).isEqualTo("NULL");
    }

    @Test
    @UseDataProvider(value="timeZones", location={TimestampCodecTest.class})
    public void should_parse(ZoneId defaultTimeZone) {
        this.codec = ExtraTypeCodecs.timestampMillisAt((ZoneId)defaultTimeZone);
        Assertions.assertThat((Long)((Long)this.parse("'0'"))).isEqualTo(0L);
        Assertions.assertThat((Long)((Long)this.parse("'-1'"))).isEqualTo(-1L);
        Assertions.assertThat((Long)((Long)this.parse("1534463100000"))).isEqualTo(1534463100000L);
        long expected = LocalDate.parse("2017-01-01").atStartOfDay().atZone(defaultTimeZone).toInstant().toEpochMilli();
        Assertions.assertThat((Long)((Long)this.parse("'2017-01-01'"))).isEqualTo(expected);
        expected = LocalDate.parse("2018-08-16").atStartOfDay().atZone(ZoneOffset.ofHours(2)).toInstant().toEpochMilli();
        Assertions.assertThat((Long)((Long)this.parse("'2018-08-16+02'"))).isEqualTo(expected);
        Assertions.assertThat((Long)((Long)this.parse("'2018-08-16+0200'"))).isEqualTo(expected);
        Assertions.assertThat((Long)((Long)this.parse("'2018-08-16+02:00'"))).isEqualTo(expected);
        Assertions.assertThat((Long)((Long)this.parse("'2018-08-16 CEST'"))).isEqualTo(expected);
        expected = LocalDateTime.parse("2018-08-16T23:45").atZone(defaultTimeZone).toInstant().toEpochMilli();
        Assertions.assertThat((Long)((Long)this.parse("'2018-08-16T23:45'"))).isEqualTo(expected);
        Assertions.assertThat((Long)((Long)this.parse("'2018-08-16 23:45'"))).isEqualTo(expected);
        expected = LocalDateTime.parse("2019-12-31T16:08:38").atZone(defaultTimeZone).toInstant().toEpochMilli();
        Assertions.assertThat((Long)((Long)this.parse("'2019-12-31T16:08:38'"))).isEqualTo(expected);
        Assertions.assertThat((Long)((Long)this.parse("'2019-12-31 16:08:38'"))).isEqualTo(expected);
        expected = LocalDateTime.parse("1950-02-28T12:00:59.230").atZone(defaultTimeZone).toInstant().toEpochMilli();
        Assertions.assertThat((Long)((Long)this.parse("'1950-02-28T12:00:59.230'"))).isEqualTo(expected);
        Assertions.assertThat((Long)((Long)this.parse("'1950-02-28 12:00:59.230'"))).isEqualTo(expected);
        expected = ZonedDateTime.parse("1973-06-23T23:59:00.000+01:00").toInstant().toEpochMilli();
        Assertions.assertThat((Long)((Long)this.parse("'1973-06-23T23:59+01'"))).isEqualTo(expected);
        Assertions.assertThat((Long)((Long)this.parse("'1973-06-23T23:59+0100'"))).isEqualTo(expected);
        Assertions.assertThat((Long)((Long)this.parse("'1973-06-23T23:59+01:00'"))).isEqualTo(expected);
        Assertions.assertThat((Long)((Long)this.parse("'1973-06-23T23:59 CET'"))).isEqualTo(expected);
        Assertions.assertThat((Long)((Long)this.parse("'1973-06-23 23:59+01'"))).isEqualTo(expected);
        Assertions.assertThat((Long)((Long)this.parse("'1973-06-23 23:59+0100'"))).isEqualTo(expected);
        Assertions.assertThat((Long)((Long)this.parse("'1973-06-23 23:59+01:00'"))).isEqualTo(expected);
        Assertions.assertThat((Long)((Long)this.parse("'1973-06-23 23:59 CET'"))).isEqualTo(expected);
        expected = ZonedDateTime.parse("1980-01-01T23:59:59.000-08:00").toInstant().toEpochMilli();
        Assertions.assertThat((Long)((Long)this.parse("'1980-01-01T23:59:59-08'"))).isEqualTo(expected);
        Assertions.assertThat((Long)((Long)this.parse("'1980-01-01T23:59:59-0800'"))).isEqualTo(expected);
        Assertions.assertThat((Long)((Long)this.parse("'1980-01-01T23:59:59-08:00'"))).isEqualTo(expected);
        Assertions.assertThat((Long)((Long)this.parse("'1980-01-01T23:59:59 PST'"))).isEqualTo(expected);
        Assertions.assertThat((Long)((Long)this.parse("'1980-01-01 23:59:59-08'"))).isEqualTo(expected);
        Assertions.assertThat((Long)((Long)this.parse("'1980-01-01 23:59:59-0800'"))).isEqualTo(expected);
        Assertions.assertThat((Long)((Long)this.parse("'1980-01-01 23:59:59-08:00'"))).isEqualTo(expected);
        Assertions.assertThat((Long)((Long)this.parse("'1980-01-01 23:59:59 PST'"))).isEqualTo(expected);
        expected = ZonedDateTime.parse("1999-12-31T23:59:59.999+00:00").toInstant().toEpochMilli();
        Assertions.assertThat((Long)((Long)this.parse("'1999-12-31T23:59:59.999+00'"))).isEqualTo(expected);
        Assertions.assertThat((Long)((Long)this.parse("'1999-12-31T23:59:59.999+0000'"))).isEqualTo(expected);
        Assertions.assertThat((Long)((Long)this.parse("'1999-12-31T23:59:59.999+00:00'"))).isEqualTo(expected);
        Assertions.assertThat((Long)((Long)this.parse("'1999-12-31T23:59:59.999 UTC'"))).isEqualTo(expected);
        Assertions.assertThat((Long)((Long)this.parse("'1999-12-31 23:59:59.999+00'"))).isEqualTo(expected);
        Assertions.assertThat((Long)((Long)this.parse("'1999-12-31 23:59:59.999+0000'"))).isEqualTo(expected);
        Assertions.assertThat((Long)((Long)this.parse("'1999-12-31 23:59:59.999+00:00'"))).isEqualTo(expected);
        Assertions.assertThat((Long)((Long)this.parse("'1999-12-31 23:59:59.999 UTC'"))).isEqualTo(expected);
        Assertions.assertThat((Long)((Long)this.parse("NULL"))).isNull();
        Assertions.assertThat((Long)((Long)this.parse("null"))).isNull();
        Assertions.assertThat((Long)((Long)this.parse(""))).isNull();
        Assertions.assertThat((Long)((Long)this.parse(null))).isNull();
    }

    @Test
    public void should_fail_to_parse_invalid_input() {
        this.codec = ExtraTypeCodecs.TIMESTAMP_MILLIS_SYSTEM;
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> {
            Long cfr_ignored_0 = (Long)this.parse("not a timestamp");
        }).isInstanceOf(IllegalArgumentException.class)).hasMessage("Alphanumeric timestamp literal must be quoted: \"not a timestamp\"");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> {
            Long cfr_ignored_0 = (Long)this.parse("'not a timestamp'");
        }).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot parse timestamp value from \"'not a timestamp'\"");
    }

    @Test
    public void should_accept_generic_type() {
        this.codec = ExtraTypeCodecs.TIMESTAMP_MILLIS_UTC;
        Assertions.assertThat((boolean)this.codec.accepts(GenericType.LONG)).isTrue();
        Assertions.assertThat((boolean)this.codec.accepts(GenericType.INSTANT)).isFalse();
    }

    @Test
    public void should_accept_raw_type() {
        this.codec = ExtraTypeCodecs.TIMESTAMP_MILLIS_UTC;
        Assertions.assertThat((boolean)this.codec.accepts(Long.class)).isTrue();
        Assertions.assertThat((boolean)this.codec.accepts(Long.TYPE)).isTrue();
        Assertions.assertThat((boolean)this.codec.accepts(Instant.class)).isFalse();
    }

    @Test
    public void should_accept_object() {
        this.codec = ExtraTypeCodecs.TIMESTAMP_MILLIS_UTC;
        Assertions.assertThat((boolean)this.codec.accepts((Object)Long.MIN_VALUE)).isTrue();
        Assertions.assertThat((boolean)this.codec.accepts((Object)Instant.EPOCH)).isFalse();
    }
}

