/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.type.codec.extras.time;

import com.datastax.oss.driver.api.core.type.codec.ExtraTypeCodecs;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import com.datastax.oss.driver.internal.core.type.codec.CodecTestBase;
import com.datastax.oss.driver.internal.core.type.codec.TimestampCodecTest;
import com.tngtech.java.junit.dataprovider.DataProviderRunner;
import com.tngtech.java.junit.dataprovider.UseDataProvider;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DataProviderRunner.class)
public class LocalTimestampCodecTest
extends CodecTestBase<LocalDateTime> {
    @Test
    public void should_encode() {
        this.codec = ExtraTypeCodecs.LOCAL_TIMESTAMP_UTC;
        Assertions.assertThat((String)this.encode(Instant.EPOCH.atZone(ZoneOffset.UTC).toLocalDateTime())).isEqualTo("0x0000000000000000");
        Assertions.assertThat((String)this.encode(Instant.ofEpochMilli(128L).atZone(ZoneOffset.UTC).toLocalDateTime())).isEqualTo("0x0000000000000080");
        Assertions.assertThat((String)this.encode(null)).isNull();
    }

    @Test
    public void should_decode() {
        this.codec = ExtraTypeCodecs.LOCAL_TIMESTAMP_UTC;
        Assertions.assertThat((LocalDateTime)((LocalDateTime)this.decode("0x0000000000000000"))).isEqualTo((Object)Instant.EPOCH.atZone(ZoneOffset.UTC).toLocalDateTime());
        Assertions.assertThat((LocalDateTime)((LocalDateTime)this.decode("0x0000000000000080"))).isEqualTo((Object)Instant.ofEpochMilli(128L).atZone(ZoneOffset.UTC).toLocalDateTime());
        Assertions.assertThat((LocalDateTime)((LocalDateTime)this.decode(null))).isNull();
    }

    @Test(expected=IllegalArgumentException.class)
    public void should_fail_to_decode_if_not_enough_bytes() {
        this.codec = ExtraTypeCodecs.LOCAL_TIMESTAMP_SYSTEM;
        this.decode("0x0000");
    }

    @Test(expected=IllegalArgumentException.class)
    public void should_fail_to_decode_if_too_many_bytes() {
        this.codec = ExtraTypeCodecs.LOCAL_TIMESTAMP_SYSTEM;
        this.decode("0x00000000000000000000");
    }

    @Test
    public void should_format() {
        this.codec = ExtraTypeCodecs.localTimestampAt((ZoneId)ZoneOffset.ofHours(2));
        Assertions.assertThat((String)this.format(LocalDateTime.parse("2018-08-16T16:59:34.123"))).isEqualTo("'2018-08-16T16:59:34.123+02:00'");
        Assertions.assertThat((String)this.format(null)).isEqualTo("NULL");
    }

    @Test
    @UseDataProvider(value="timeZones", location={TimestampCodecTest.class})
    public void should_parse(ZoneId defaultTimeZone) {
        this.codec = ExtraTypeCodecs.localTimestampAt((ZoneId)defaultTimeZone);
        Assertions.assertThat((LocalDateTime)((LocalDateTime)this.parse("'0'"))).isEqualTo((Object)Instant.EPOCH.atZone(defaultTimeZone).toLocalDateTime());
        Assertions.assertThat((LocalDateTime)((LocalDateTime)this.parse("'-1'"))).isEqualTo((Object)Instant.EPOCH.minusMillis(1L).atZone(defaultTimeZone).toLocalDateTime());
        Assertions.assertThat((LocalDateTime)((LocalDateTime)this.parse("1534463100000"))).isEqualTo((Object)Instant.ofEpochMilli(1534463100000L).atZone(defaultTimeZone).toLocalDateTime());
        LocalDateTime expected = LocalDate.parse("2017-01-01").atStartOfDay();
        Assertions.assertThat((LocalDateTime)((LocalDateTime)this.parse("'2017-01-01'"))).isEqualTo((Object)expected);
        expected = ZonedDateTime.parse("2018-08-16T00:00:00+02:00").withZoneSameInstant(defaultTimeZone).toLocalDateTime();
        Assertions.assertThat((LocalDateTime)((LocalDateTime)this.parse("'2018-08-16+02'"))).isEqualTo((Object)expected);
        Assertions.assertThat((LocalDateTime)((LocalDateTime)this.parse("'2018-08-16+0200'"))).isEqualTo((Object)expected);
        Assertions.assertThat((LocalDateTime)((LocalDateTime)this.parse("'2018-08-16+02:00'"))).isEqualTo((Object)expected);
        Assertions.assertThat((LocalDateTime)((LocalDateTime)this.parse("'2018-08-16 CEST'"))).isEqualTo((Object)expected);
        expected = LocalDateTime.parse("2018-08-16T23:45");
        Assertions.assertThat((LocalDateTime)((LocalDateTime)this.parse("'2018-08-16T23:45'"))).isEqualTo((Object)expected);
        Assertions.assertThat((LocalDateTime)((LocalDateTime)this.parse("'2018-08-16 23:45'"))).isEqualTo((Object)expected);
        expected = LocalDateTime.parse("2019-12-31T16:08:38");
        Assertions.assertThat((LocalDateTime)((LocalDateTime)this.parse("'2019-12-31T16:08:38'"))).isEqualTo((Object)expected);
        Assertions.assertThat((LocalDateTime)((LocalDateTime)this.parse("'2019-12-31 16:08:38'"))).isEqualTo((Object)expected);
        expected = LocalDateTime.parse("1950-02-28T12:00:59.230");
        Assertions.assertThat((LocalDateTime)((LocalDateTime)this.parse("'1950-02-28T12:00:59.230'"))).isEqualTo((Object)expected);
        Assertions.assertThat((LocalDateTime)((LocalDateTime)this.parse("'1950-02-28 12:00:59.230'"))).isEqualTo((Object)expected);
        expected = ZonedDateTime.parse("1973-06-23T23:59:00.000+01:00").withZoneSameInstant(defaultTimeZone).toLocalDateTime();
        Assertions.assertThat((LocalDateTime)((LocalDateTime)this.parse("'1973-06-23T23:59+01'"))).isEqualTo((Object)expected);
        Assertions.assertThat((LocalDateTime)((LocalDateTime)this.parse("'1973-06-23T23:59+0100'"))).isEqualTo((Object)expected);
        Assertions.assertThat((LocalDateTime)((LocalDateTime)this.parse("'1973-06-23T23:59+01:00'"))).isEqualTo((Object)expected);
        Assertions.assertThat((LocalDateTime)((LocalDateTime)this.parse("'1973-06-23T23:59 CET'"))).isEqualTo((Object)expected);
        Assertions.assertThat((LocalDateTime)((LocalDateTime)this.parse("'1973-06-23 23:59+01'"))).isEqualTo((Object)expected);
        Assertions.assertThat((LocalDateTime)((LocalDateTime)this.parse("'1973-06-23 23:59+0100'"))).isEqualTo((Object)expected);
        Assertions.assertThat((LocalDateTime)((LocalDateTime)this.parse("'1973-06-23 23:59+01:00'"))).isEqualTo((Object)expected);
        Assertions.assertThat((LocalDateTime)((LocalDateTime)this.parse("'1973-06-23 23:59 CET'"))).isEqualTo((Object)expected);
        expected = ZonedDateTime.parse("1980-01-01T23:59:59.000-08:00").withZoneSameInstant(defaultTimeZone).toLocalDateTime();
        Assertions.assertThat((LocalDateTime)((LocalDateTime)this.parse("'1980-01-01T23:59:59-08'"))).isEqualTo((Object)expected);
        Assertions.assertThat((LocalDateTime)((LocalDateTime)this.parse("'1980-01-01T23:59:59-0800'"))).isEqualTo((Object)expected);
        Assertions.assertThat((LocalDateTime)((LocalDateTime)this.parse("'1980-01-01T23:59:59-08:00'"))).isEqualTo((Object)expected);
        Assertions.assertThat((LocalDateTime)((LocalDateTime)this.parse("'1980-01-01T23:59:59 PST'"))).isEqualTo((Object)expected);
        Assertions.assertThat((LocalDateTime)((LocalDateTime)this.parse("'1980-01-01 23:59:59-08'"))).isEqualTo((Object)expected);
        Assertions.assertThat((LocalDateTime)((LocalDateTime)this.parse("'1980-01-01 23:59:59-0800'"))).isEqualTo((Object)expected);
        Assertions.assertThat((LocalDateTime)((LocalDateTime)this.parse("'1980-01-01 23:59:59-08:00'"))).isEqualTo((Object)expected);
        Assertions.assertThat((LocalDateTime)((LocalDateTime)this.parse("'1980-01-01 23:59:59 PST'"))).isEqualTo((Object)expected);
        expected = ZonedDateTime.parse("1999-12-31T23:59:59.999+00:00").withZoneSameInstant(defaultTimeZone).toLocalDateTime();
        Assertions.assertThat((LocalDateTime)((LocalDateTime)this.parse("'1999-12-31T23:59:59.999+00'"))).isEqualTo((Object)expected);
        Assertions.assertThat((LocalDateTime)((LocalDateTime)this.parse("'1999-12-31T23:59:59.999+0000'"))).isEqualTo((Object)expected);
        Assertions.assertThat((LocalDateTime)((LocalDateTime)this.parse("'1999-12-31T23:59:59.999+00:00'"))).isEqualTo((Object)expected);
        Assertions.assertThat((LocalDateTime)((LocalDateTime)this.parse("'1999-12-31T23:59:59.999 UTC'"))).isEqualTo((Object)expected);
        Assertions.assertThat((LocalDateTime)((LocalDateTime)this.parse("'1999-12-31 23:59:59.999+00'"))).isEqualTo((Object)expected);
        Assertions.assertThat((LocalDateTime)((LocalDateTime)this.parse("'1999-12-31 23:59:59.999+0000'"))).isEqualTo((Object)expected);
        Assertions.assertThat((LocalDateTime)((LocalDateTime)this.parse("'1999-12-31 23:59:59.999+00:00'"))).isEqualTo((Object)expected);
        Assertions.assertThat((LocalDateTime)((LocalDateTime)this.parse("'1999-12-31 23:59:59.999 UTC'"))).isEqualTo((Object)expected);
        Assertions.assertThat((LocalDateTime)((LocalDateTime)this.parse("NULL"))).isNull();
        Assertions.assertThat((LocalDateTime)((LocalDateTime)this.parse("null"))).isNull();
        Assertions.assertThat((LocalDateTime)((LocalDateTime)this.parse(""))).isNull();
        Assertions.assertThat((LocalDateTime)((LocalDateTime)this.parse(null))).isNull();
    }

    @Test
    public void should_fail_to_parse_invalid_input() {
        this.codec = ExtraTypeCodecs.LOCAL_TIMESTAMP_SYSTEM;
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> {
            LocalDateTime cfr_ignored_0 = (LocalDateTime)this.parse("not a timestamp");
        }).isInstanceOf(IllegalArgumentException.class)).hasMessage("Alphanumeric timestamp literal must be quoted: \"not a timestamp\"");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> {
            LocalDateTime cfr_ignored_0 = (LocalDateTime)this.parse("'not a timestamp'");
        }).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot parse timestamp value from \"'not a timestamp'\"");
    }

    @Test
    public void should_accept_generic_type() {
        this.codec = ExtraTypeCodecs.LOCAL_TIMESTAMP_SYSTEM;
        Assertions.assertThat((boolean)this.codec.accepts(GenericType.LOCAL_DATE_TIME)).isTrue();
        Assertions.assertThat((boolean)this.codec.accepts(GenericType.INSTANT)).isFalse();
    }

    @Test
    public void should_accept_raw_type() {
        this.codec = ExtraTypeCodecs.LOCAL_TIMESTAMP_SYSTEM;
        Assertions.assertThat((boolean)this.codec.accepts(LocalDateTime.class)).isTrue();
        Assertions.assertThat((boolean)this.codec.accepts(Instant.class)).isFalse();
    }

    @Test
    public void should_accept_object() {
        this.codec = ExtraTypeCodecs.LOCAL_TIMESTAMP_SYSTEM;
        Assertions.assertThat((boolean)this.codec.accepts((Object)LocalDateTime.now(ZoneId.systemDefault()))).isTrue();
        Assertions.assertThat((boolean)this.codec.accepts((Object)Instant.EPOCH)).isFalse();
    }
}

