/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.type.codec.extras.enums;

import com.datastax.dse.driver.api.core.DseProtocolVersion;
import com.datastax.oss.driver.api.core.DefaultProtocolVersion;
import com.datastax.oss.driver.api.core.type.codec.ExtraTypeCodecs;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import com.datastax.oss.driver.internal.core.type.codec.CodecTestBase;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;

public class EnumOrdinalCodecTest
extends CodecTestBase<DefaultProtocolVersion> {
    @Before
    public void setup() {
        this.codec = ExtraTypeCodecs.enumOrdinalsOf(DefaultProtocolVersion.class);
    }

    @Test
    public void should_encode() {
        Assertions.assertThat((String)this.encode(DefaultProtocolVersion.values()[0])).isEqualTo("0x00000000");
        Assertions.assertThat((String)this.encode(null)).isNull();
    }

    @Test
    public void should_decode() {
        Assertions.assertThat((Comparable)((DefaultProtocolVersion)this.decode("0x00000000"))).isEqualTo((Object)DefaultProtocolVersion.values()[0]);
        Assertions.assertThat((Comparable)((DefaultProtocolVersion)this.decode("0x"))).isNull();
        Assertions.assertThat((Comparable)((DefaultProtocolVersion)this.decode(null))).isNull();
    }

    @Test(expected=IllegalArgumentException.class)
    public void should_fail_to_decode_if_not_enough_bytes() {
        this.decode("0x0000");
    }

    @Test(expected=IllegalArgumentException.class)
    public void should_fail_to_decode_if_too_many_bytes() {
        this.decode("0x0000000000000000");
    }

    @Test
    public void should_format() {
        Assertions.assertThat((String)this.format(DefaultProtocolVersion.values()[0])).isEqualTo("0");
        Assertions.assertThat((String)this.format(null)).isEqualTo("NULL");
    }

    @Test
    public void should_parse() {
        Assertions.assertThat((Comparable)((DefaultProtocolVersion)this.parse("0"))).isEqualTo((Object)DefaultProtocolVersion.values()[0]);
        Assertions.assertThat((Comparable)((DefaultProtocolVersion)this.parse("NULL"))).isNull();
        Assertions.assertThat((Comparable)((DefaultProtocolVersion)this.parse("null"))).isNull();
        Assertions.assertThat((Comparable)((DefaultProtocolVersion)this.parse(""))).isNull();
        Assertions.assertThat((Comparable)((DefaultProtocolVersion)this.parse(null))).isNull();
    }

    @Test(expected=IllegalArgumentException.class)
    public void should_fail_to_parse_invalid_input() {
        this.parse("not an int");
    }

    @Test
    public void should_accept_generic_type() {
        Assertions.assertThat((boolean)this.codec.accepts(GenericType.of(DefaultProtocolVersion.class))).isTrue();
    }

    @Test
    public void should_accept_raw_type() {
        Assertions.assertThat((boolean)this.codec.accepts(DefaultProtocolVersion.class)).isTrue();
    }

    @Test
    public void should_accept_object() {
        Assertions.assertThat((boolean)this.codec.accepts((Object)DefaultProtocolVersion.V3)).isTrue();
        Assertions.assertThat((boolean)this.codec.accepts((Object)DseProtocolVersion.DSE_V1)).isFalse();
    }
}

