/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.type.codec.extras.array;

import com.datastax.oss.driver.api.core.type.codec.ExtraTypeCodecs;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import com.datastax.oss.driver.internal.core.type.codec.CodecTestBase;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;

public class LongArrayCodecTest
extends CodecTestBase<long[]> {
    @Before
    public void setup() {
        this.codec = ExtraTypeCodecs.LONG_LIST_TO_ARRAY;
    }

    @Test
    public void should_encode_null() {
        Assertions.assertThat((String)this.encode(null)).isNull();
    }

    @Test
    public void should_encode_empty_array() {
        Assertions.assertThat((String)this.encode(new long[0])).isEqualTo("0x00000000");
    }

    @Test
    public void should_encode_non_empty_array() {
        Assertions.assertThat((String)this.encode(new long[]{1L, 2L, 3L})).isEqualTo("0x00000003000000080000000000000001000000080000000000000002000000080000000000000003");
    }

    @Test
    public void should_decode_null_as_empty_array() {
        Assertions.assertThat((long[])((long[])this.decode(null))).isEmpty();
    }

    @Test
    public void should_decode_empty_array() {
        Assertions.assertThat((long[])((long[])this.decode("0x00000000"))).isEmpty();
    }

    @Test
    public void should_decode_non_empty_array() {
        Assertions.assertThat((long[])((long[])this.decode("0x00000003000000080000000000000001000000080000000000000002000000080000000000000003"))).containsExactly(new long[]{1L, 2L, 3L});
    }

    @Test(expected=NullPointerException.class)
    public void should_not_decode_array_with_null_elements() {
        this.decode("0x00000001FFFFFFFF");
    }

    @Test
    public void should_format_null_array() {
        Assertions.assertThat((String)this.format(null)).isEqualTo("NULL");
    }

    @Test
    public void should_format_empty_array() {
        Assertions.assertThat((String)this.format(new long[0])).isEqualTo("[]");
    }

    @Test
    public void should_format_non_empty_array() {
        Assertions.assertThat((String)this.format(new long[]{1L, 2L, 3L})).isEqualTo("[1,2,3]");
    }

    @Test
    public void should_parse_null_or_empty_string() {
        Assertions.assertThat((long[])((long[])this.parse(null))).isNull();
        Assertions.assertThat((long[])((long[])this.parse(""))).isNull();
    }

    @Test
    public void should_parse_empty_array() {
        Assertions.assertThat((long[])((long[])this.parse("[]"))).isEmpty();
    }

    @Test
    public void should_parse_non_empty_array() {
        Assertions.assertThat((long[])((long[])this.parse("[1,2,3]"))).containsExactly(new long[]{1L, 2L, 3L});
    }

    @Test(expected=IllegalArgumentException.class)
    public void should_fail_to_parse_malformed_array() {
        this.parse("not an array");
    }

    @Test
    public void should_accept_generic_type() {
        Assertions.assertThat((boolean)this.codec.accepts(GenericType.arrayOf(Long.TYPE))).isTrue();
        Assertions.assertThat((boolean)this.codec.accepts(GenericType.arrayOf(Long.class))).isFalse();
        Assertions.assertThat((boolean)this.codec.accepts(GenericType.arrayOf(String.class))).isFalse();
    }

    @Test
    public void should_accept_raw_type() {
        Assertions.assertThat((boolean)this.codec.accepts(GenericType.arrayOf(Long.TYPE).getRawType())).isTrue();
        Assertions.assertThat((boolean)this.codec.accepts(GenericType.arrayOf(Long.class).getRawType())).isFalse();
        Assertions.assertThat((boolean)this.codec.accepts(GenericType.arrayOf(String.class).getRawType())).isFalse();
    }

    @Test
    public void should_accept_object() {
        Assertions.assertThat((boolean)this.codec.accepts((Object)new long[]{1L, 2L, 3L})).isTrue();
        Assertions.assertThat((boolean)this.codec.accepts((Object)new Long[]{1L, 2L, 3L})).isFalse();
        Assertions.assertThat((boolean)this.codec.accepts((Object)new String[]{"hello", "world"})).isFalse();
    }
}

