/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.type.codec;

import com.datastax.oss.driver.api.core.data.CqlVector;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.DataTypes;
import com.datastax.oss.driver.api.core.type.VectorType;
import com.datastax.oss.driver.api.core.type.codec.TypeCodec;
import com.datastax.oss.driver.api.core.type.codec.TypeCodecs;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import com.datastax.oss.driver.internal.core.type.DefaultVectorType;
import com.datastax.oss.driver.internal.core.type.codec.CodecTestBase;
import java.util.Arrays;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class VectorCodecTest
extends CodecTestBase<CqlVector<Float>> {
    private static final Float[] VECTOR_ARGS = new Float[]{Float.valueOf(1.0f), Float.valueOf(2.5f)};
    private static final CqlVector<Float> VECTOR = CqlVector.newInstance((Number[])VECTOR_ARGS);
    private static final String VECTOR_HEX_STRING = "0x3f80000040200000";
    private static final String FORMATTED_VECTOR = "[1.0, 2.5]";

    public VectorCodecTest() {
        VectorType vectorType = DataTypes.vectorOf((DataType)DataTypes.FLOAT, (int)2);
        this.codec = TypeCodecs.vectorOf((VectorType)vectorType, (TypeCodec)TypeCodecs.FLOAT);
    }

    @Test
    public void should_encode() {
        Assertions.assertThat((String)this.encode(VECTOR)).isEqualTo(VECTOR_HEX_STRING);
        Assertions.assertThat((String)this.encode(null)).isNull();
    }

    @Test
    public void should_throw_on_encode_with_too_few_elements() {
        Assertions.assertThatThrownBy(() -> this.encode(VECTOR.subVector(0, 1))).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    public void should_throw_on_encode_with_empty_list() {
        Assertions.assertThatThrownBy(() -> this.encode(CqlVector.newInstance((Number[])new Float[0]))).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    public void should_encode_with_too_many_elements() {
        Number[] doubledVectorContents = Arrays.copyOf(VECTOR_ARGS, VECTOR_ARGS.length * 2);
        System.arraycopy(VECTOR_ARGS, 0, doubledVectorContents, VECTOR_ARGS.length, VECTOR_ARGS.length);
        Assertions.assertThat((String)this.encode(CqlVector.newInstance((Number[])doubledVectorContents))).isEqualTo(VECTOR_HEX_STRING);
    }

    @Test
    public void should_decode() {
        Assertions.assertThat((Iterable)((Iterable)this.decode(VECTOR_HEX_STRING))).isEqualTo(VECTOR);
        Assertions.assertThat((Iterable)((Iterable)this.decode("0x"))).isNull();
        Assertions.assertThat((Iterable)((Iterable)this.decode(null))).isNull();
    }

    @Test
    public void should_throw_on_decode_if_too_few_bytes() {
        for (int i = 1; i <= 3; ++i) {
            int lastIndex = VECTOR_HEX_STRING.length() - 2 * i;
            Assertions.assertThatThrownBy(() -> {
                CqlVector cfr_ignored_0 = (CqlVector)this.decode(VECTOR_HEX_STRING.substring(0, lastIndex));
            }).isInstanceOf(IllegalArgumentException.class);
        }
    }

    @Test
    public void should_format() {
        Assertions.assertThat((String)this.format(VECTOR)).isEqualTo(FORMATTED_VECTOR);
        Assertions.assertThat((String)this.format(null)).isEqualTo("NULL");
    }

    @Test
    public void should_parse() {
        Assertions.assertThat((Iterable)((Iterable)this.parse(FORMATTED_VECTOR))).isEqualTo(VECTOR);
        Assertions.assertThat((Iterable)((Iterable)this.parse("NULL"))).isNull();
        Assertions.assertThat((Iterable)((Iterable)this.parse("null"))).isNull();
        Assertions.assertThat((Iterable)((Iterable)this.parse(""))).isNull();
        Assertions.assertThat((Iterable)((Iterable)this.parse(null))).isNull();
    }

    @Test
    public void should_accept_data_type() {
        Assertions.assertThat((boolean)this.codec.accepts((DataType)new DefaultVectorType(DataTypes.FLOAT, 2))).isTrue();
        Assertions.assertThat((boolean)this.codec.accepts(DataTypes.INT)).isFalse();
    }

    @Test
    public void should_accept_vector_type_correct_dimension_only() {
        Assertions.assertThat((boolean)this.codec.accepts((DataType)new DefaultVectorType(DataTypes.FLOAT, 0))).isFalse();
        Assertions.assertThat((boolean)this.codec.accepts((DataType)new DefaultVectorType(DataTypes.FLOAT, 1))).isFalse();
        Assertions.assertThat((boolean)this.codec.accepts((DataType)new DefaultVectorType(DataTypes.FLOAT, 2))).isTrue();
        for (int i = 3; i < 1000; ++i) {
            Assertions.assertThat((boolean)this.codec.accepts((DataType)new DefaultVectorType(DataTypes.FLOAT, i))).isFalse();
        }
    }

    @Test
    public void should_accept_generic_type() {
        Assertions.assertThat((boolean)this.codec.accepts(GenericType.vectorOf((GenericType)GenericType.FLOAT))).isTrue();
        Assertions.assertThat((boolean)this.codec.accepts(GenericType.vectorOf((GenericType)GenericType.INTEGER))).isFalse();
        Assertions.assertThat((boolean)this.codec.accepts(GenericType.of(Integer.class))).isFalse();
    }

    @Test
    public void should_accept_raw_type() {
        Assertions.assertThat((boolean)this.codec.accepts(CqlVector.class)).isTrue();
        Assertions.assertThat((boolean)this.codec.accepts(Integer.class)).isFalse();
    }

    @Test
    public void should_accept_object() {
        Assertions.assertThat((boolean)this.codec.accepts(VECTOR)).isTrue();
        Assertions.assertThat((boolean)this.codec.accepts((Object)Integer.MIN_VALUE)).isFalse();
    }
}

