/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.type.codec;

import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.data.TupleValue;
import com.datastax.oss.driver.api.core.detach.AttachmentPoint;
import com.datastax.oss.driver.api.core.type.DataTypes;
import com.datastax.oss.driver.api.core.type.TupleType;
import com.datastax.oss.driver.api.core.type.codec.PrimitiveIntCodec;
import com.datastax.oss.driver.api.core.type.codec.TypeCodec;
import com.datastax.oss.driver.api.core.type.codec.TypeCodecs;
import com.datastax.oss.driver.api.core.type.codec.registry.CodecRegistry;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import com.datastax.oss.driver.internal.core.data.DefaultTupleValue;
import com.datastax.oss.driver.internal.core.type.DefaultTupleType;
import com.datastax.oss.driver.internal.core.type.codec.CodecTestBase;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableList;
import com.datastax.oss.protocol.internal.util.Bytes;
import java.util.List;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class TupleCodecTest
extends CodecTestBase<TupleValue> {
    @Mock
    private AttachmentPoint attachmentPoint;
    @Mock
    private CodecRegistry codecRegistry;
    private PrimitiveIntCodec intCodec;
    private TypeCodec<Double> doubleCodec;
    private TypeCodec<String> textCodec;
    private TupleType tupleType;

    @Before
    public void setup() {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.attachmentPoint.getCodecRegistry()).thenReturn((Object)this.codecRegistry);
        Mockito.when((Object)this.attachmentPoint.getProtocolVersion()).thenReturn((Object)ProtocolVersion.DEFAULT);
        this.intCodec = (PrimitiveIntCodec)Mockito.spy((Object)TypeCodecs.INT);
        this.doubleCodec = (TypeCodec)Mockito.spy((Object)TypeCodecs.DOUBLE);
        this.textCodec = (TypeCodec)Mockito.spy((Object)TypeCodecs.TEXT);
        Mockito.when((Object)this.codecRegistry.codecFor(DataTypes.INT, Integer.class)).thenAnswer(i -> this.intCodec);
        Mockito.when((Object)this.codecRegistry.codecFor(DataTypes.DOUBLE, Double.class)).thenAnswer(i -> this.doubleCodec);
        Mockito.when((Object)this.codecRegistry.codecFor(DataTypes.TEXT, String.class)).thenAnswer(i -> this.textCodec);
        Mockito.when((Object)this.codecRegistry.codecFor(DataTypes.INT)).thenAnswer(i -> this.intCodec);
        Mockito.when((Object)this.codecRegistry.codecFor(DataTypes.DOUBLE)).thenAnswer(i -> this.doubleCodec);
        Mockito.when((Object)this.codecRegistry.codecFor(DataTypes.TEXT)).thenAnswer(i -> this.textCodec);
        this.tupleType = new DefaultTupleType((List)ImmutableList.of((Object)DataTypes.INT, (Object)DataTypes.DOUBLE, (Object)DataTypes.TEXT), this.attachmentPoint);
        this.codec = TypeCodecs.tupleOf((TupleType)this.tupleType);
    }

    @Test
    public void should_encode_null_tuple() {
        Assertions.assertThat((String)this.encode(null)).isNull();
    }

    @Test
    public void should_encode_tuple() {
        TupleValue tuple = this.tupleType.newValue();
        tuple = (TupleValue)tuple.setInt(0, 1);
        tuple = (TupleValue)tuple.setToNull(1);
        tuple = (TupleValue)tuple.setString(2, "a");
        Assertions.assertThat((String)this.encode(tuple)).isEqualTo("0x0000000400000001ffffffff0000000161");
        ((PrimitiveIntCodec)Mockito.verify((Object)this.intCodec)).encodePrimitive(1, ProtocolVersion.DEFAULT);
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.doubleCodec});
        ((TypeCodec)Mockito.verify(this.textCodec)).encode((Object)"a", ProtocolVersion.DEFAULT);
    }

    @Test
    public void should_decode_null_tuple() {
        Assertions.assertThat((Object)((TupleValue)this.decode(null))).isNull();
    }

    @Test
    public void should_decode_tuple() {
        TupleValue tuple = (TupleValue)this.decode("0x0000000400000001ffffffff0000000161");
        Assertions.assertThat((int)tuple.getInt(0)).isEqualTo(1);
        Assertions.assertThat((boolean)tuple.isNull(1)).isTrue();
        Assertions.assertThat((String)tuple.getString(2)).isEqualTo("a");
        ((PrimitiveIntCodec)Mockito.verify((Object)this.intCodec)).decodePrimitive(Bytes.fromHexString((String)"0x00000001"), ProtocolVersion.DEFAULT);
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.doubleCodec});
        ((TypeCodec)Mockito.verify(this.textCodec)).decode(Bytes.fromHexString((String)"0x61"), ProtocolVersion.DEFAULT);
    }

    @Test
    public void should_decode_negative_element_length_as_null_field() {
        TupleValue tuple = (TupleValue)this.decode("0xfffffffffffffffe80000000");
        Assertions.assertThat((boolean)tuple.isNull(0)).isTrue();
        Assertions.assertThat((boolean)tuple.isNull(1)).isTrue();
        Assertions.assertThat((boolean)tuple.isNull(2)).isTrue();
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.intCodec});
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.doubleCodec});
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.textCodec});
    }

    @Test
    public void should_format_null_tuple() {
        Assertions.assertThat((String)this.format(null)).isEqualTo("NULL");
    }

    @Test
    public void should_format_tuple() {
        TupleValue tuple = this.tupleType.newValue();
        tuple = (TupleValue)tuple.setInt(0, 1);
        tuple = (TupleValue)tuple.setToNull(1);
        tuple = (TupleValue)tuple.setString(2, "a");
        Assertions.assertThat((String)this.format(tuple)).isEqualTo("(1,NULL,'a')");
        ((PrimitiveIntCodec)Mockito.verify((Object)this.intCodec)).format((Object)1);
        ((TypeCodec)Mockito.verify(this.doubleCodec)).format(null);
        ((TypeCodec)Mockito.verify(this.textCodec)).format((Object)"a");
    }

    @Test
    public void should_parse_null_tuple() {
        Assertions.assertThat((Object)((TupleValue)this.parse(null))).isNull();
        Assertions.assertThat((Object)((TupleValue)this.parse("null"))).isNull();
        Assertions.assertThat((Object)((TupleValue)this.parse("NULL"))).isNull();
    }

    @Test
    public void should_parse_empty_tuple() {
        TupleValue tuple = (TupleValue)this.parse("()");
        Assertions.assertThat((boolean)tuple.isNull(0)).isTrue();
        Assertions.assertThat((boolean)tuple.isNull(1)).isTrue();
        Assertions.assertThat((boolean)tuple.isNull(2)).isTrue();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.intCodec});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.doubleCodec});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.textCodec});
    }

    @Test
    public void should_parse_partial_tuple() {
        TupleValue tuple = (TupleValue)this.parse("(1,NULL)");
        Assertions.assertThat((int)tuple.getInt(0)).isEqualTo(1);
        Assertions.assertThat((boolean)tuple.isNull(1)).isTrue();
        Assertions.assertThat((boolean)tuple.isNull(2)).isTrue();
        ((PrimitiveIntCodec)Mockito.verify((Object)this.intCodec)).parse("1");
        ((TypeCodec)Mockito.verify(this.doubleCodec)).parse("NULL");
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.textCodec});
    }

    @Test
    public void should_parse_full_tuple() {
        TupleValue tuple = (TupleValue)this.parse("(1,NULL,'a')");
        Assertions.assertThat((int)tuple.getInt(0)).isEqualTo(1);
        Assertions.assertThat((boolean)tuple.isNull(1)).isTrue();
        Assertions.assertThat((String)tuple.getString(2)).isEqualTo("a");
        ((PrimitiveIntCodec)Mockito.verify((Object)this.intCodec)).parse("1");
        ((TypeCodec)Mockito.verify(this.doubleCodec)).parse("NULL");
        ((TypeCodec)Mockito.verify(this.textCodec)).parse("'a'");
    }

    @Test
    public void should_parse_tuple_with_extra_whitespace() {
        TupleValue tuple = (TupleValue)this.parse("  (  1  ,  NULL  ,  'a'  )  ");
        Assertions.assertThat((int)tuple.getInt(0)).isEqualTo(1);
        Assertions.assertThat((boolean)tuple.isNull(1)).isTrue();
        Assertions.assertThat((String)tuple.getString(2)).isEqualTo("a");
        ((PrimitiveIntCodec)Mockito.verify((Object)this.intCodec)).parse("1");
        ((TypeCodec)Mockito.verify(this.doubleCodec)).parse("NULL");
        ((TypeCodec)Mockito.verify(this.textCodec)).parse("'a'");
    }

    @Test
    public void should_fail_to_parse_invalid_input() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> {
            TupleValue cfr_ignored_0 = (TupleValue)this.parse("not a tuple");
        }).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot parse tuple value from \"not a tuple\", at character 0 expecting '(' but got 'n'");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> {
            TupleValue cfr_ignored_0 = (TupleValue)this.parse(" ( ");
        }).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot parse tuple value from \" ( \", at field 0 (character 3) expecting CQL value or ')', got EOF");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> {
            TupleValue cfr_ignored_0 = (TupleValue)this.parse("( [");
        }).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot parse tuple value from \"( [\", invalid CQL value at field 0 (character 2)");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> {
            TupleValue cfr_ignored_0 = (TupleValue)this.parse("( 12 , ");
        }).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot parse tuple value from \"( 12 , \", at field 1 (character 7) expecting CQL value or ')', got EOF");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> {
            TupleValue cfr_ignored_0 = (TupleValue)this.parse("( 12 12.34 ");
        }).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot parse tuple value from \"( 12 12.34 \", at field 0 (character 5) expecting ',' but got '1'");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> {
            TupleValue cfr_ignored_0 = (TupleValue)this.parse("(1234,12.34,'text'");
        }).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot parse tuple value from \"(1234,12.34,'text'\", at field 2 (character 18) expecting ',' or ')', but got EOF");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> {
            TupleValue cfr_ignored_0 = (TupleValue)this.parse("(1234,12.34,'text'))");
        }).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot parse tuple value from \"(1234,12.34,'text'))\", at character 19 expecting EOF or blank, but got \")\"");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> {
            TupleValue cfr_ignored_0 = (TupleValue)this.parse("())");
        }).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot parse tuple value from \"())\", at character 2 expecting EOF or blank, but got \")\"");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> {
            TupleValue cfr_ignored_0 = (TupleValue)this.parse("(1234,12.34,'text') extra");
        }).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot parse tuple value from \"(1234,12.34,'text') extra\", at character 20 expecting EOF or blank, but got \"extra\"");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> {
            TupleValue cfr_ignored_0 = (TupleValue)this.parse("(not a valid int,12.34,'text')");
        }).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot parse tuple value from \"(not a valid int,12.34,'text')\", invalid CQL value at field 0 (character 1): Cannot parse 32-bits int value from \"not\"").hasRootCauseInstanceOf(IllegalArgumentException.class);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> {
            TupleValue cfr_ignored_0 = (TupleValue)this.parse("(1234,not a valid double,'text')");
        }).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot parse tuple value from \"(1234,not a valid double,'text')\", invalid CQL value at field 1 (character 6): Cannot parse 64-bits double value from \"not\"").hasRootCauseInstanceOf(IllegalArgumentException.class);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> {
            TupleValue cfr_ignored_0 = (TupleValue)this.parse("(1234,12.34,not a valid text)");
        }).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot parse tuple value from \"(1234,12.34,not a valid text)\", invalid CQL value at field 2 (character 12): text or varchar values must be enclosed by single quotes").hasRootCauseInstanceOf(IllegalArgumentException.class);
    }

    @Test
    public void should_accept_generic_type() {
        Assertions.assertThat((boolean)this.codec.accepts(GenericType.of(TupleValue.class))).isTrue();
        Assertions.assertThat((boolean)this.codec.accepts(GenericType.of(DefaultTupleValue.class))).isFalse();
    }

    @Test
    public void should_accept_raw_type() {
        Assertions.assertThat((boolean)this.codec.accepts(TupleValue.class)).isTrue();
        Assertions.assertThat((boolean)this.codec.accepts(DefaultTupleValue.class)).isFalse();
    }

    @Test
    public void should_accept_object() {
        Assertions.assertThat((boolean)this.codec.accepts((Object)this.tupleType.newValue())).isTrue();
        Assertions.assertThat((boolean)this.codec.accepts((Object)new DefaultTupleValue(this.tupleType))).isTrue();
        Assertions.assertThat((boolean)this.codec.accepts((Object)"not a tuple")).isFalse();
    }
}

