/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.type.codec;

import com.datastax.oss.driver.api.core.data.CqlDuration;
import com.datastax.oss.driver.api.core.type.codec.TypeCodecs;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import com.datastax.oss.driver.internal.core.type.codec.CodecTestBase;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class CqlDurationCodecTest
extends CodecTestBase<CqlDuration> {
    private static final CqlDuration DURATION = CqlDuration.newInstance((int)1, (int)2, (long)3L);

    public CqlDurationCodecTest() {
        this.codec = TypeCodecs.DURATION;
    }

    @Test
    public void should_encode() {
        Assertions.assertThat((String)this.encode(DURATION)).isEqualTo("0x020406");
        Assertions.assertThat((String)this.encode(null)).isNull();
    }

    @Test
    public void should_decode() {
        Assertions.assertThat((Object)((CqlDuration)this.decode("0x020406"))).isEqualTo((Object)DURATION);
        Assertions.assertThat((Object)((CqlDuration)this.decode("0x"))).isNull();
        Assertions.assertThat((Object)((CqlDuration)this.decode(null))).isNull();
    }

    @Test(expected=IllegalStateException.class)
    public void should_fail_to_decode_if_not_enough_bytes() {
        this.decode("0x0000");
    }

    @Test
    public void should_format() {
        Assertions.assertThat((String)this.format(DURATION)).isEqualTo("1mo2d3ns");
        Assertions.assertThat((String)this.format(null)).isEqualTo("NULL");
    }

    @Test
    public void should_parse() {
        Assertions.assertThat((Object)((CqlDuration)this.parse("1mo2d3ns"))).isEqualTo((Object)DURATION);
        Assertions.assertThat((Object)((CqlDuration)this.parse("NULL"))).isNull();
        Assertions.assertThat((Object)((CqlDuration)this.parse("null"))).isNull();
        Assertions.assertThat((Object)((CqlDuration)this.parse(""))).isNull();
        Assertions.assertThat((Object)((CqlDuration)this.parse(null))).isNull();
    }

    @Test(expected=IllegalArgumentException.class)
    public void should_fail_to_parse_invalid_input() {
        this.parse("not a duration");
    }

    @Test
    public void should_accept_generic_type() {
        Assertions.assertThat((boolean)this.codec.accepts(GenericType.of(CqlDuration.class))).isTrue();
        Assertions.assertThat((boolean)this.codec.accepts(GenericType.of(Integer.class))).isFalse();
    }

    @Test
    public void should_accept_raw_type() {
        Assertions.assertThat((boolean)this.codec.accepts(CqlDuration.class)).isTrue();
        Assertions.assertThat((boolean)this.codec.accepts(Integer.class)).isFalse();
    }

    @Test
    public void should_accept_object() {
        Assertions.assertThat((boolean)this.codec.accepts((Object)DURATION)).isTrue();
        Assertions.assertThat((boolean)this.codec.accepts((Object)Integer.MIN_VALUE)).isFalse();
    }
}

