/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.type.codec;

import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.type.codec.TypeCodecs;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import com.datastax.oss.driver.internal.core.type.codec.CodecTestBase;
import com.datastax.oss.protocol.internal.util.Bytes;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class BlobCodecTest
extends CodecTestBase<ByteBuffer> {
    private static final ByteBuffer BUFFER = Bytes.fromHexString((String)"0xcafebabe");

    public BlobCodecTest() {
        this.codec = TypeCodecs.BLOB;
    }

    @Test
    public void should_encode() {
        Assertions.assertThat((String)this.encode(BUFFER)).isEqualTo("0xcafebabe");
        Assertions.assertThat((String)this.encode(null)).isNull();
    }

    @Test
    public void should_not_share_position_between_input_and_encoded() {
        int inputPosition = BUFFER.position();
        ByteBuffer encoded = this.codec.encode((Object)BUFFER, ProtocolVersion.DEFAULT);
        encoded.get();
        Assertions.assertThat((int)BUFFER.position()).isEqualTo(inputPosition);
    }

    @Test
    public void should_decode() {
        Assertions.assertThat((Comparable)((ByteBuffer)this.decode("0xcafebabe"))).isEqualTo((Object)BUFFER);
        Assertions.assertThat((int)((ByteBuffer)this.decode("0x")).capacity()).isEqualTo(0);
        Assertions.assertThat((Comparable)((ByteBuffer)this.decode(null))).isNull();
    }

    @Test
    public void should_not_share_position_between_decoded_and_input() {
        int inputPosition = BUFFER.position();
        ByteBuffer decoded = (ByteBuffer)this.codec.decode(BUFFER, ProtocolVersion.DEFAULT);
        decoded.get();
        Assertions.assertThat((int)BUFFER.position()).isEqualTo(inputPosition);
    }

    @Test
    public void should_format() {
        Assertions.assertThat((String)this.format(BUFFER)).isEqualTo("0xcafebabe");
        Assertions.assertThat((String)this.format(null)).isEqualTo("NULL");
    }

    @Test
    public void should_parse() {
        Assertions.assertThat((Comparable)((ByteBuffer)this.parse("0xcafebabe"))).isEqualTo((Object)BUFFER);
        Assertions.assertThat((Comparable)((ByteBuffer)this.parse("NULL"))).isNull();
        Assertions.assertThat((Comparable)((ByteBuffer)this.parse("null"))).isNull();
        Assertions.assertThat((Comparable)((ByteBuffer)this.parse(""))).isNull();
        Assertions.assertThat((Comparable)((ByteBuffer)this.parse(null))).isNull();
    }

    @Test(expected=IllegalArgumentException.class)
    public void should_fail_to_parse_invalid_input() {
        this.parse("not a blob");
    }

    @Test
    public void should_accept_generic_type() {
        Assertions.assertThat((boolean)this.codec.accepts(GenericType.of(ByteBuffer.class))).isTrue();
        Assertions.assertThat((boolean)this.codec.accepts(GenericType.of(MappedByteBuffer.class))).isFalse();
    }

    @Test
    public void should_accept_raw_type() {
        Assertions.assertThat((boolean)this.codec.accepts(ByteBuffer.class)).isTrue();
        Assertions.assertThat((boolean)this.codec.accepts(MappedByteBuffer.class)).isFalse();
    }

    @Test
    public void should_accept_object() {
        Assertions.assertThat((boolean)this.codec.accepts((Object)BUFFER)).isTrue();
        Assertions.assertThat((boolean)this.codec.accepts((Object)MappedByteBuffer.allocate(0))).isTrue();
    }
}

