/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.type.codec;

import com.datastax.oss.driver.api.core.type.codec.TypeCodecs;
import com.datastax.oss.driver.internal.core.type.codec.CodecTestBase;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class AsciiCodecTest
extends CodecTestBase<String> {
    public AsciiCodecTest() {
        this.codec = TypeCodecs.ASCII;
    }

    @Test
    public void should_encode() {
        Assertions.assertThat((String)this.encode("hello")).isEqualTo("0x68656c6c6f");
        Assertions.assertThat((String)this.encode(null)).isNull();
    }

    @Test(expected=IllegalArgumentException.class)
    public void should_fail_to_encode_non_ascii() {
        this.encode("h\u00ebllo");
    }

    @Test
    public void should_decode() {
        Assertions.assertThat((String)((String)this.decode("0x68656c6c6f"))).isEqualTo("hello");
        Assertions.assertThat((String)((String)this.decode("0x"))).isEmpty();
        Assertions.assertThat((String)((String)this.decode(null))).isNull();
    }

    @Test(expected=IllegalArgumentException.class)
    public void should_fail_to_decode_non_ascii() {
        this.decode("0x68c3ab6c6c6f");
    }
}

