/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.type;

import com.datastax.oss.driver.TestDataProviders;
import com.datastax.oss.driver.api.core.type.DataTypes;
import com.tngtech.java.junit.dataprovider.DataProviderRunner;
import com.tngtech.java.junit.dataprovider.UseDataProvider;
import java.util.Locale;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DataProviderRunner.class)
public class PrimitiveTypeTest {
    @Test
    public void should_report_protocol_code() {
        Assertions.assertThat((int)DataTypes.ASCII.getProtocolCode()).isEqualTo(1);
        Assertions.assertThat((int)DataTypes.BIGINT.getProtocolCode()).isEqualTo(2);
        Assertions.assertThat((int)DataTypes.BLOB.getProtocolCode()).isEqualTo(3);
        Assertions.assertThat((int)DataTypes.BOOLEAN.getProtocolCode()).isEqualTo(4);
        Assertions.assertThat((int)DataTypes.COUNTER.getProtocolCode()).isEqualTo(5);
        Assertions.assertThat((int)DataTypes.DECIMAL.getProtocolCode()).isEqualTo(6);
        Assertions.assertThat((int)DataTypes.DOUBLE.getProtocolCode()).isEqualTo(7);
        Assertions.assertThat((int)DataTypes.FLOAT.getProtocolCode()).isEqualTo(8);
        Assertions.assertThat((int)DataTypes.INT.getProtocolCode()).isEqualTo(9);
        Assertions.assertThat((int)DataTypes.TIMESTAMP.getProtocolCode()).isEqualTo(11);
        Assertions.assertThat((int)DataTypes.UUID.getProtocolCode()).isEqualTo(12);
        Assertions.assertThat((int)DataTypes.VARINT.getProtocolCode()).isEqualTo(14);
        Assertions.assertThat((int)DataTypes.TIMEUUID.getProtocolCode()).isEqualTo(15);
        Assertions.assertThat((int)DataTypes.INET.getProtocolCode()).isEqualTo(16);
        Assertions.assertThat((int)DataTypes.DATE.getProtocolCode()).isEqualTo(17);
        Assertions.assertThat((int)DataTypes.TEXT.getProtocolCode()).isEqualTo(13);
        Assertions.assertThat((int)DataTypes.TIME.getProtocolCode()).isEqualTo(18);
        Assertions.assertThat((int)DataTypes.SMALLINT.getProtocolCode()).isEqualTo(19);
        Assertions.assertThat((int)DataTypes.TINYINT.getProtocolCode()).isEqualTo(20);
        Assertions.assertThat((int)DataTypes.DURATION.getProtocolCode()).isEqualTo(21);
    }

    @Test
    @UseDataProvider(location={TestDataProviders.class}, value="locales")
    public void should_format_as_cql(Locale locale) {
        Locale def = Locale.getDefault();
        try {
            Locale.setDefault(locale);
            Assertions.assertThat((String)DataTypes.ASCII.asCql(true, true)).isEqualTo("ascii");
            Assertions.assertThat((String)DataTypes.BIGINT.asCql(true, true)).isEqualTo("bigint");
            Assertions.assertThat((String)DataTypes.BLOB.asCql(true, true)).isEqualTo("blob");
            Assertions.assertThat((String)DataTypes.BOOLEAN.asCql(true, true)).isEqualTo("boolean");
            Assertions.assertThat((String)DataTypes.COUNTER.asCql(true, true)).isEqualTo("counter");
            Assertions.assertThat((String)DataTypes.DECIMAL.asCql(true, true)).isEqualTo("decimal");
            Assertions.assertThat((String)DataTypes.DOUBLE.asCql(true, true)).isEqualTo("double");
            Assertions.assertThat((String)DataTypes.FLOAT.asCql(true, true)).isEqualTo("float");
            Assertions.assertThat((String)DataTypes.INT.asCql(true, true)).isEqualTo("int");
            Assertions.assertThat((String)DataTypes.TIMESTAMP.asCql(true, true)).isEqualTo("timestamp");
            Assertions.assertThat((String)DataTypes.UUID.asCql(true, true)).isEqualTo("uuid");
            Assertions.assertThat((String)DataTypes.VARINT.asCql(true, true)).isEqualTo("varint");
            Assertions.assertThat((String)DataTypes.TIMEUUID.asCql(true, true)).isEqualTo("timeuuid");
            Assertions.assertThat((String)DataTypes.INET.asCql(true, true)).isEqualTo("inet");
            Assertions.assertThat((String)DataTypes.DATE.asCql(true, true)).isEqualTo("date");
            Assertions.assertThat((String)DataTypes.TEXT.asCql(true, true)).isEqualTo("text");
            Assertions.assertThat((String)DataTypes.TIME.asCql(true, true)).isEqualTo("time");
            Assertions.assertThat((String)DataTypes.SMALLINT.asCql(true, true)).isEqualTo("smallint");
            Assertions.assertThat((String)DataTypes.TINYINT.asCql(true, true)).isEqualTo("tinyint");
            Assertions.assertThat((String)DataTypes.DURATION.asCql(true, true)).isEqualTo("duration");
        }
        finally {
            Locale.setDefault(def);
        }
    }

    @Test
    @UseDataProvider(location={TestDataProviders.class}, value="locales")
    public void should_format_as_string(Locale locale) {
        Locale def = Locale.getDefault();
        try {
            Locale.setDefault(locale);
            Assertions.assertThat((String)DataTypes.ASCII.toString()).isEqualTo("ASCII");
            Assertions.assertThat((String)DataTypes.BIGINT.toString()).isEqualTo("BIGINT");
            Assertions.assertThat((String)DataTypes.BLOB.toString()).isEqualTo("BLOB");
            Assertions.assertThat((String)DataTypes.BOOLEAN.toString()).isEqualTo("BOOLEAN");
            Assertions.assertThat((String)DataTypes.COUNTER.toString()).isEqualTo("COUNTER");
            Assertions.assertThat((String)DataTypes.DECIMAL.toString()).isEqualTo("DECIMAL");
            Assertions.assertThat((String)DataTypes.DOUBLE.toString()).isEqualTo("DOUBLE");
            Assertions.assertThat((String)DataTypes.FLOAT.toString()).isEqualTo("FLOAT");
            Assertions.assertThat((String)DataTypes.INT.toString()).isEqualTo("INT");
            Assertions.assertThat((String)DataTypes.TIMESTAMP.toString()).isEqualTo("TIMESTAMP");
            Assertions.assertThat((String)DataTypes.UUID.toString()).isEqualTo("UUID");
            Assertions.assertThat((String)DataTypes.VARINT.toString()).isEqualTo("VARINT");
            Assertions.assertThat((String)DataTypes.TIMEUUID.toString()).isEqualTo("TIMEUUID");
            Assertions.assertThat((String)DataTypes.INET.toString()).isEqualTo("INET");
            Assertions.assertThat((String)DataTypes.DATE.toString()).isEqualTo("DATE");
            Assertions.assertThat((String)DataTypes.TEXT.toString()).isEqualTo("TEXT");
            Assertions.assertThat((String)DataTypes.TIME.toString()).isEqualTo("TIME");
            Assertions.assertThat((String)DataTypes.SMALLINT.toString()).isEqualTo("SMALLINT");
            Assertions.assertThat((String)DataTypes.TINYINT.toString()).isEqualTo("TINYINT");
            Assertions.assertThat((String)DataTypes.DURATION.toString()).isEqualTo("DURATION");
        }
        finally {
            Locale.setDefault(def);
        }
    }
}

