/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.time;

import com.datastax.oss.driver.Assertions;
import com.datastax.oss.driver.api.core.context.DriverContext;
import com.datastax.oss.driver.internal.core.time.Clock;
import com.datastax.oss.driver.internal.core.time.MonotonicTimestampGenerator;
import com.datastax.oss.driver.internal.core.time.MonotonicTimestampGeneratorTestBase;
import com.datastax.oss.driver.internal.core.time.ThreadLocalTimestampGenerator;
import com.datastax.oss.driver.internal.core.util.concurrent.CompletableFutures;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.stubbing.OngoingStubbing;

public class ThreadLocalTimestampGeneratorTest
extends MonotonicTimestampGeneratorTestBase {
    @Override
    protected MonotonicTimestampGenerator newInstance(Clock clock) {
        return new ThreadLocalTimestampGenerator(clock, (DriverContext)this.context);
    }

    @Test
    public void should_confine_timestamps_to_thread() throws Exception {
        int testThreadsCount = 2;
        OngoingStubbing stub = Mockito.when((Object)this.clock.currentTimeMicros());
        for (int i = 0; i < 2000; ++i) {
            stub = stub.thenReturn((Object)1L);
        }
        MonotonicTimestampGenerator generator = this.newInstance(this.clock);
        CopyOnWriteArrayList futures = new CopyOnWriteArrayList();
        ExecutorService executor = Executors.newFixedThreadPool(2);
        for (int i = 0; i < 2; ++i) {
            executor.submit(() -> {
                try {
                    for (long l = 1L; l <= 1000L; ++l) {
                        Assertions.assertThat((long)generator.next()).isEqualTo(l);
                    }
                    futures.add(CompletableFuture.completedFuture(null));
                }
                catch (Throwable t) {
                    futures.add(CompletableFutures.failedFuture((Throwable)t));
                }
            });
        }
        executor.shutdown();
        if (!executor.awaitTermination(1L, TimeUnit.SECONDS)) {
            Assertions.fail((String)"Expected executor to shut down cleanly");
        }
        Assertions.assertThat(futures).hasSize(2);
        for (CompletionStage future : futures) {
            Assertions.assertThatStage(future).isSuccess();
        }
    }
}

