/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.time;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.config.DriverConfig;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.config.DriverOption;
import com.datastax.oss.driver.internal.core.context.InternalDriverContext;
import com.datastax.oss.driver.internal.core.time.Clock;
import com.datastax.oss.driver.internal.core.time.MonotonicTimestampGenerator;
import java.time.Duration;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.stubbing.OngoingStubbing;
import org.slf4j.LoggerFactory;

abstract class MonotonicTimestampGeneratorTestBase {
    @Mock
    protected Clock clock;
    @Mock
    protected InternalDriverContext context;
    @Mock
    private DriverConfig config;
    @Mock
    protected DriverExecutionProfile defaultProfile;
    @Mock
    private Appender<ILoggingEvent> appender;
    @Captor
    private ArgumentCaptor<ILoggingEvent> loggingEventCaptor;
    private Logger logger;

    MonotonicTimestampGeneratorTestBase() {
    }

    @Before
    public void setup() {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.config.getDefaultProfile()).thenReturn((Object)this.defaultProfile);
        Mockito.when((Object)this.context.getConfig()).thenReturn((Object)this.config);
        Mockito.when((Object)this.defaultProfile.getDuration((DriverOption)DefaultDriverOption.TIMESTAMP_GENERATOR_DRIFT_WARNING_THRESHOLD, Duration.ZERO)).thenReturn((Object)Duration.ZERO);
        Mockito.when((Object)this.defaultProfile.getDuration((DriverOption)DefaultDriverOption.TIMESTAMP_GENERATOR_DRIFT_WARNING_INTERVAL)).thenReturn((Object)Duration.ofSeconds(10L));
        this.logger = (Logger)LoggerFactory.getLogger(MonotonicTimestampGenerator.class);
        this.logger.addAppender(this.appender);
    }

    @After
    public void teardown() {
        this.logger.detachAppender(this.appender);
    }

    protected abstract MonotonicTimestampGenerator newInstance(Clock var1);

    @Test
    public void should_use_clock_if_it_keeps_increasing() {
        OngoingStubbing stub = Mockito.when((Object)this.clock.currentTimeMicros());
        for (long l = 1L; l < 5L; ++l) {
            stub = stub.thenReturn((Object)l);
        }
        MonotonicTimestampGenerator generator = this.newInstance(this.clock);
        for (long l = 1L; l < 5L; ++l) {
            Assertions.assertThat((long)generator.next()).isEqualTo(l);
        }
    }

    @Test
    public void should_increment_if_clock_does_not_increase() {
        Mockito.when((Object)this.clock.currentTimeMicros()).thenReturn((Object)1L, (Object[])new Long[]{1L, 1L, 5L});
        MonotonicTimestampGenerator generator = this.newInstance(this.clock);
        Assertions.assertThat((long)generator.next()).isEqualTo(1L);
        Assertions.assertThat((long)generator.next()).isEqualTo(2L);
        Assertions.assertThat((long)generator.next()).isEqualTo(3L);
        Assertions.assertThat((long)generator.next()).isEqualTo(5L);
    }

    @Test
    public void should_warn_if_timestamps_drift() {
        Mockito.when((Object)this.defaultProfile.getDuration((DriverOption)DefaultDriverOption.TIMESTAMP_GENERATOR_DRIFT_WARNING_THRESHOLD, Duration.ZERO)).thenReturn((Object)Duration.ofNanos(2000L));
        Mockito.when((Object)this.clock.currentTimeMicros()).thenReturn((Object)1L, (Object[])new Long[]{1L, 1L, 1L, 1L});
        MonotonicTimestampGenerator generator = this.newInstance(this.clock);
        Assertions.assertThat((long)generator.next()).isEqualTo(1L);
        Assertions.assertThat((long)generator.next()).isEqualTo(2L);
        Assertions.assertThat((long)generator.next()).isEqualTo(3L);
        Assertions.assertThat((long)generator.next()).isEqualTo(4L);
        Assertions.assertThat((long)generator.next()).isEqualTo(5L);
        ((Appender)Mockito.verify(this.appender)).doAppend((Object)((ILoggingEvent)this.loggingEventCaptor.capture()));
        ILoggingEvent log = (ILoggingEvent)this.loggingEventCaptor.getValue();
        Assertions.assertThat((Object)log.getLevel()).isEqualTo((Object)Level.WARN);
        Assertions.assertThat((String)log.getMessage()).contains(new CharSequence[]{"Clock skew detected"});
    }

    @Test
    public void should_go_back_to_clock_if_new_tick_high_enough() {
        Mockito.when((Object)this.clock.currentTimeMicros()).thenReturn((Object)1L, (Object[])new Long[]{1L, 1L, 1L, 1L, 10L});
        MonotonicTimestampGenerator generator = this.newInstance(this.clock);
        for (long l = 1L; l <= 5L; ++l) {
            Assertions.assertThat((long)generator.next()).isEqualTo(l);
        }
        Assertions.assertThat((long)generator.next()).isEqualTo(10L);
    }
}

