/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.ssl;

import com.datastax.oss.driver.internal.core.ssl.ReloadingKeyManagerFactory;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Optional;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManagerFactory;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReloadingKeyManagerFactoryTest {
    private static final Logger logger = LoggerFactory.getLogger(ReloadingKeyManagerFactoryTest.class);
    static final Path CERT_BASE = Paths.get(ReloadingKeyManagerFactoryTest.class.getResource(String.format("/%s/certs/", ReloadingKeyManagerFactoryTest.class.getSimpleName())).getPath(), new String[0]);
    static final Path SERVER_KEYSTORE_PATH = CERT_BASE.resolve("server.keystore");
    static final Path SERVER_TRUSTSTORE_PATH = CERT_BASE.resolve("server.truststore");
    static final Path ORIGINAL_CLIENT_KEYSTORE_PATH = CERT_BASE.resolve("client-original.keystore");
    static final Path ALTERNATE_CLIENT_KEYSTORE_PATH = CERT_BASE.resolve("client-alternate.keystore");
    static final BigInteger ORIGINAL_CLIENT_KEYSTORE_CERT_SERIAL = ReloadingKeyManagerFactoryTest.convertSerial("7372a966");
    static final BigInteger ALTERNATE_CLIENT_KEYSTORE_CERT_SERIAL = ReloadingKeyManagerFactoryTest.convertSerial("e50bf31");
    static final Path TMP_CLIENT_KEYSTORE_PATH;
    static final Path CLIENT_TRUSTSTORE_PATH;
    static final String CERTSTORE_PASSWORD = "changeit";

    private static TrustManagerFactory buildTrustManagerFactory() {
        TrustManagerFactory tmf;
        try (InputStream tsf = Files.newInputStream(CLIENT_TRUSTSTORE_PATH, new OpenOption[0]);){
            KeyStore ts = KeyStore.getInstance("JKS");
            char[] password = CERTSTORE_PASSWORD.toCharArray();
            ts.load(tsf, password);
            tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(ts);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return tmf;
    }

    private static SSLContext buildServerSslContext() {
        try {
            KeyManagerFactory kmf;
            TrustManagerFactory tmf;
            SSLContext context = SSLContext.getInstance("SSL");
            try (InputStream tsf = Files.newInputStream(SERVER_TRUSTSTORE_PATH, new OpenOption[0]);){
                KeyStore ts = KeyStore.getInstance("JKS");
                char[] password = CERTSTORE_PASSWORD.toCharArray();
                ts.load(tsf, password);
                tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                tmf.init(ts);
            }
            try (InputStream ksf = Files.newInputStream(SERVER_KEYSTORE_PATH, new OpenOption[0]);){
                KeyStore ks = KeyStore.getInstance("JKS");
                char[] password = CERTSTORE_PASSWORD.toCharArray();
                ks.load(ksf, password);
                kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                kmf.init(ks, password);
            }
            context.init(kmf.getKeyManagers(), tmf.getTrustManagers(), new SecureRandom());
            return context;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Test
    public void client_certificates_should_reload() throws Exception {
        Files.copy(ORIGINAL_CLIENT_KEYSTORE_PATH, TMP_CLIENT_KEYSTORE_PATH, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES);
        LinkedBlockingQueue peerCertificates = new LinkedBlockingQueue(1);
        SSLContext serverSslContext = ReloadingKeyManagerFactoryTest.buildServerSslContext();
        SSLServerSocket server = (SSLServerSocket)serverSslContext.getServerSocketFactory().createServerSocket();
        server.bind(new InetSocketAddress(0), 1);
        server.setUseClientMode(false);
        server.setNeedClientAuth(true);
        Thread serverThread = new Thread(() -> {
            while (true) {
                try {
                    while (true) {
                        logger.info("Server accepting client");
                        SSLSocket conn = (SSLSocket)server.accept();
                        logger.info("Server accepted client {}", (Object)conn);
                        conn.addHandshakeCompletedListener(event -> {
                            boolean offer;
                            try {
                                offer = peerCertificates.offer(Optional.of((X509Certificate[])event.getPeerCertificates()));
                            }
                            catch (SSLPeerUnverifiedException e) {
                                offer = peerCertificates.offer(Optional.empty());
                            }
                            Assert.assertTrue((boolean)offer);
                        });
                        logger.info("Server starting handshake");
                        conn.startHandshake();
                    }
                }
                catch (IOException e) {
                    if (e instanceof SocketException && e.getMessage().contains("Socket closed")) {
                        return;
                    }
                    logger.info("Server accept error", (Throwable)e);
                    continue;
                }
                break;
            }
        });
        serverThread.setName(String.format("%s-serverThread", this.getClass().getSimpleName()));
        serverThread.setDaemon(true);
        serverThread.start();
        ReloadingKeyManagerFactory kmf = ReloadingKeyManagerFactory.create((Path)TMP_CLIENT_KEYSTORE_PATH, (String)CERTSTORE_PASSWORD, Optional.empty());
        TrustManagerFactory tmf = ReloadingKeyManagerFactoryTest.buildTrustManagerFactory();
        ReloadingKeyManagerFactoryTest.testClientCertificates((KeyManagerFactory)kmf, tmf, server.getLocalSocketAddress(), () -> {
            try {
                return (Optional)peerCertificates.poll(10L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }, certs -> {
            Assert.assertEquals((long)1L, (long)((X509Certificate[])certs).length);
            X509Certificate cert = certs[0];
            Assert.assertEquals((Object)ORIGINAL_CLIENT_KEYSTORE_CERT_SERIAL, (Object)cert.getSerialNumber());
        });
        logger.info("Updating keystore file with new content");
        Files.copy(ALTERNATE_CLIENT_KEYSTORE_PATH, TMP_CLIENT_KEYSTORE_PATH, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES);
        kmf.reload();
        ReloadingKeyManagerFactoryTest.testClientCertificates((KeyManagerFactory)kmf, tmf, server.getLocalSocketAddress(), () -> {
            try {
                return (Optional)peerCertificates.poll(30L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }, certs -> {
            Assert.assertEquals((long)1L, (long)((X509Certificate[])certs).length);
            X509Certificate cert = certs[0];
            Assert.assertEquals((Object)ALTERNATE_CLIENT_KEYSTORE_CERT_SERIAL, (Object)cert.getSerialNumber());
        });
        kmf.close();
        server.close();
    }

    private static void testClientCertificates(KeyManagerFactory kmf, TrustManagerFactory tmf, SocketAddress serverAddress, Supplier<Optional<X509Certificate[]>> certsSupplier, Consumer<X509Certificate[]> certsConsumer) throws NoSuchAlgorithmException, KeyManagementException, IOException {
        SSLContext clientSslContext = SSLContext.getInstance("TLS");
        clientSslContext.init(kmf.getKeyManagers(), tmf.getTrustManagers(), null);
        SSLSocket client = (SSLSocket)clientSslContext.getSocketFactory().createSocket();
        logger.info("Client connecting");
        client.connect(serverAddress);
        logger.info("Client doing handshake");
        client.startHandshake();
        Optional<X509Certificate[]> lastCertificate = certsSupplier.get();
        logger.info("Client got its certificate back from the server; closing socket");
        client.close();
        Assert.assertNotNull(lastCertificate);
        Assert.assertTrue((boolean)lastCertificate.isPresent());
        logger.info("Client got its certificate back from server: {}", lastCertificate);
        certsConsumer.accept(lastCertificate.get());
    }

    private static BigInteger convertSerial(String hex) {
        BigInteger serial = new BigInteger(Integer.valueOf(hex, 16).toString());
        logger.info("Serial hex {} is {}", (Object)hex, (Object)serial);
        return serial;
    }

    static {
        try {
            TMP_CLIENT_KEYSTORE_PATH = Files.createTempFile(ReloadingKeyManagerFactoryTest.class.getSimpleName(), null, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        CLIENT_TRUSTSTORE_PATH = CERT_BASE.resolve("client.truststore");
    }
}

