/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.session;

import com.datastax.oss.driver.Assertions;
import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.addresstranslation.AddressTranslator;
import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.config.DriverConfig;
import com.datastax.oss.driver.api.core.config.DriverConfigLoader;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.config.DriverOption;
import com.datastax.oss.driver.api.core.connection.ReconnectionPolicy;
import com.datastax.oss.driver.api.core.loadbalancing.NodeDistance;
import com.datastax.oss.driver.api.core.metadata.Metadata;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.api.core.metadata.NodeState;
import com.datastax.oss.driver.api.core.metadata.NodeStateListener;
import com.datastax.oss.driver.api.core.metadata.schema.SchemaChangeListener;
import com.datastax.oss.driver.api.core.retry.RetryPolicy;
import com.datastax.oss.driver.api.core.session.Session;
import com.datastax.oss.driver.api.core.specex.SpeculativeExecutionPolicy;
import com.datastax.oss.driver.api.core.tracker.RequestTracker;
import com.datastax.oss.driver.internal.core.context.EventBus;
import com.datastax.oss.driver.internal.core.context.InternalDriverContext;
import com.datastax.oss.driver.internal.core.context.NettyOptions;
import com.datastax.oss.driver.internal.core.control.ControlConnection;
import com.datastax.oss.driver.internal.core.metadata.DefaultEndPoint;
import com.datastax.oss.driver.internal.core.metadata.DefaultNode;
import com.datastax.oss.driver.internal.core.metadata.DistanceEvent;
import com.datastax.oss.driver.internal.core.metadata.LoadBalancingPolicyWrapper;
import com.datastax.oss.driver.internal.core.metadata.MetadataManager;
import com.datastax.oss.driver.internal.core.metadata.NodeStateEvent;
import com.datastax.oss.driver.internal.core.metadata.TestNodeFactory;
import com.datastax.oss.driver.internal.core.metadata.TopologyMonitor;
import com.datastax.oss.driver.internal.core.metrics.MetricsFactory;
import com.datastax.oss.driver.internal.core.pool.ChannelPool;
import com.datastax.oss.driver.internal.core.pool.ChannelPoolFactory;
import com.datastax.oss.driver.internal.core.session.DefaultSession;
import com.datastax.oss.driver.internal.core.session.MockChannelPoolFactoryHelper;
import com.datastax.oss.driver.internal.core.session.PoolManager;
import com.datastax.oss.driver.internal.core.util.concurrent.CompletableFutures;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableMap;
import io.netty.channel.DefaultEventLoopGroup;
import io.netty.util.concurrent.DefaultPromise;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.GlobalEventExecutor;
import java.time.Duration;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import org.awaitility.Awaitility;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;
import org.mockito.verification.VerificationWithTimeout;

public class DefaultSessionPoolsTest {
    private static final CqlIdentifier KEYSPACE = CqlIdentifier.fromInternal((String)"ks");
    protected static final VerificationWithTimeout VERIFY_TIMEOUT = Mockito.timeout((long)500L);
    @Mock
    private InternalDriverContext context;
    @Mock
    private NettyOptions nettyOptions;
    @Mock
    private ChannelPoolFactory channelPoolFactory;
    @Mock
    private MetadataManager metadataManager;
    @Mock
    private TopologyMonitor topologyMonitor;
    @Mock
    private LoadBalancingPolicyWrapper loadBalancingPolicyWrapper;
    @Mock
    private DriverConfigLoader configLoader;
    @Mock
    private Metadata metadata;
    @Mock
    private DriverConfig config;
    @Mock
    private DriverExecutionProfile defaultProfile;
    @Mock
    private ReconnectionPolicy reconnectionPolicy;
    @Mock
    private RetryPolicy retryPolicy;
    @Mock
    private SpeculativeExecutionPolicy speculativeExecutionPolicy;
    @Mock
    private AddressTranslator addressTranslator;
    @Mock
    private ControlConnection controlConnection;
    @Mock
    private MetricsFactory metricsFactory;
    @Mock
    private NodeStateListener nodeStateListener;
    @Mock
    private SchemaChangeListener schemaChangeListener;
    @Mock
    private RequestTracker requestTracker;
    private DefaultNode node1;
    private DefaultNode node2;
    private DefaultNode node3;
    private EventBus eventBus;

    @Before
    public void setup() {
        MockitoAnnotations.initMocks((Object)this);
        DefaultEventLoopGroup adminEventLoopGroup = new DefaultEventLoopGroup(1);
        Mockito.when((Object)this.nettyOptions.adminEventExecutorGroup()).thenReturn((Object)adminEventLoopGroup);
        Mockito.when((Object)this.context.getNettyOptions()).thenReturn((Object)this.nettyOptions);
        Mockito.when((Object)this.defaultProfile.getBoolean((DriverOption)DefaultDriverOption.REQUEST_WARN_IF_SET_KEYSPACE)).thenReturn((Object)true);
        Mockito.when((Object)this.defaultProfile.getBoolean((DriverOption)DefaultDriverOption.REPREPARE_ENABLED)).thenReturn((Object)false);
        Mockito.when((Object)this.defaultProfile.isDefined((DriverOption)DefaultDriverOption.PROTOCOL_VERSION)).thenReturn((Object)true);
        Mockito.when((Object)this.defaultProfile.getDuration((DriverOption)DefaultDriverOption.METADATA_TOPOLOGY_WINDOW)).thenReturn((Object)Duration.ZERO);
        Mockito.when((Object)this.defaultProfile.getInt((DriverOption)DefaultDriverOption.METADATA_TOPOLOGY_MAX_EVENTS)).thenReturn((Object)1);
        Mockito.when((Object)this.config.getDefaultProfile()).thenReturn((Object)this.defaultProfile);
        Mockito.when((Object)this.context.getConfig()).thenReturn((Object)this.config);
        Mockito.when((Object)this.metadataManager.refreshNodes()).thenReturn(CompletableFuture.completedFuture(null));
        Mockito.when((Object)this.metadataManager.refreshSchema(null, false, true)).thenReturn(CompletableFuture.completedFuture(null));
        Mockito.when((Object)this.context.getMetadataManager()).thenReturn((Object)this.metadataManager);
        Mockito.when((Object)this.topologyMonitor.init()).thenReturn(CompletableFuture.completedFuture(null));
        Mockito.when((Object)this.context.getTopologyMonitor()).thenReturn((Object)this.topologyMonitor);
        Mockito.when((Object)this.context.getLoadBalancingPolicyWrapper()).thenReturn((Object)this.loadBalancingPolicyWrapper);
        Mockito.when((Object)this.context.getConfigLoader()).thenReturn((Object)this.configLoader);
        Mockito.when((Object)this.context.getMetricsFactory()).thenReturn((Object)this.metricsFactory);
        Mockito.when((Object)this.context.getSessionName()).thenReturn((Object)"test");
        Mockito.when((Object)this.context.getChannelPoolFactory()).thenReturn((Object)this.channelPoolFactory);
        this.eventBus = (EventBus)Mockito.spy((Object)new EventBus("test"));
        Mockito.when((Object)this.context.getEventBus()).thenReturn((Object)this.eventBus);
        this.node1 = DefaultSessionPoolsTest.mockLocalNode(1);
        this.node2 = DefaultSessionPoolsTest.mockLocalNode(2);
        this.node3 = DefaultSessionPoolsTest.mockLocalNode(3);
        ImmutableMap nodes = ImmutableMap.of((Object)this.node1.getHostId(), (Object)this.node1, (Object)this.node2.getHostId(), (Object)this.node2, (Object)this.node3.getHostId(), (Object)this.node3);
        Mockito.when((Object)this.metadata.getNodes()).thenReturn((Object)nodes);
        Mockito.when((Object)this.metadataManager.getMetadata()).thenReturn((Object)this.metadata);
        PoolManager poolManager = new PoolManager(this.context);
        Mockito.when((Object)this.context.getPoolManager()).thenReturn((Object)poolManager);
        Mockito.when((Object)this.context.getReconnectionPolicy()).thenReturn((Object)this.reconnectionPolicy);
        Mockito.when((Object)this.context.getRetryPolicy("default")).thenReturn((Object)this.retryPolicy);
        Mockito.when((Object)this.context.getSpeculativeExecutionPolicies()).thenReturn((Object)ImmutableMap.of((Object)"default", (Object)this.speculativeExecutionPolicy));
        Mockito.when((Object)this.context.getAddressTranslator()).thenReturn((Object)this.addressTranslator);
        Mockito.when((Object)this.context.getNodeStateListener()).thenReturn((Object)this.nodeStateListener);
        Mockito.when((Object)this.context.getSchemaChangeListener()).thenReturn((Object)this.schemaChangeListener);
        Mockito.when((Object)this.context.getRequestTracker()).thenReturn((Object)this.requestTracker);
        Mockito.when((Object)this.metadataManager.closeAsync()).thenReturn(CompletableFuture.completedFuture(null));
        Mockito.when((Object)this.metadataManager.forceCloseAsync()).thenReturn(CompletableFuture.completedFuture(null));
        Mockito.when((Object)this.topologyMonitor.closeAsync()).thenReturn(CompletableFuture.completedFuture(null));
        Mockito.when((Object)this.topologyMonitor.forceCloseAsync()).thenReturn(CompletableFuture.completedFuture(null));
        Mockito.when((Object)this.context.getControlConnection()).thenReturn((Object)this.controlConnection);
        Mockito.when((Object)this.controlConnection.closeAsync()).thenReturn(CompletableFuture.completedFuture(null));
        Mockito.when((Object)this.controlConnection.forceCloseAsync()).thenReturn(CompletableFuture.completedFuture(null));
        DefaultPromise nettyCloseFuture = new DefaultPromise((EventExecutor)GlobalEventExecutor.INSTANCE);
        nettyCloseFuture.setSuccess(null);
        Mockito.when((Object)this.nettyOptions.onClose()).thenAnswer(invocation -> nettyCloseFuture);
    }

    @Test
    public void should_initialize_pools_with_distances() {
        Mockito.when((Object)this.node3.getDistance()).thenReturn((Object)NodeDistance.REMOTE);
        CompletableFuture<ChannelPool> pool1Future = new CompletableFuture<ChannelPool>();
        CompletableFuture<ChannelPool> pool2Future = new CompletableFuture<ChannelPool>();
        CompletableFuture<ChannelPool> pool3Future = new CompletableFuture<ChannelPool>();
        ChannelPool pool1 = this.mockPool((Node)this.node1);
        ChannelPool pool2 = this.mockPool((Node)this.node2);
        ChannelPool pool3 = this.mockPool((Node)this.node3);
        MockChannelPoolFactoryHelper factoryHelper = MockChannelPoolFactoryHelper.builder(this.channelPoolFactory).pending((Node)this.node1, KEYSPACE, NodeDistance.LOCAL, pool1Future).pending((Node)this.node2, KEYSPACE, NodeDistance.LOCAL, pool2Future).pending((Node)this.node3, KEYSPACE, NodeDistance.REMOTE, pool3Future).build();
        CompletionStage<CqlSession> initFuture = this.newSession();
        factoryHelper.waitForCall((Node)this.node1, KEYSPACE, NodeDistance.LOCAL);
        factoryHelper.waitForCall((Node)this.node2, KEYSPACE, NodeDistance.LOCAL);
        factoryHelper.waitForCall((Node)this.node3, KEYSPACE, NodeDistance.REMOTE);
        Assertions.assertThatStage(initFuture).isNotDone();
        pool1Future.complete(pool1);
        pool2Future.complete(pool2);
        pool3Future.complete(pool3);
        Assertions.assertThatStage(initFuture).isSuccess(session -> Assertions.assertThat((Map)((DefaultSession)session).getPools()).containsValues((Object[])new ChannelPool[]{pool1, pool2, pool3}));
    }

    @Test
    public void should_not_connect_to_ignored_nodes() {
        Mockito.when((Object)this.node2.getDistance()).thenReturn((Object)NodeDistance.IGNORED);
        ChannelPool pool1 = this.mockPool((Node)this.node1);
        ChannelPool pool3 = this.mockPool((Node)this.node3);
        MockChannelPoolFactoryHelper factoryHelper = MockChannelPoolFactoryHelper.builder(this.channelPoolFactory).success((Node)this.node1, KEYSPACE, NodeDistance.LOCAL, pool1).success((Node)this.node3, KEYSPACE, NodeDistance.LOCAL, pool3).build();
        CompletionStage<CqlSession> initFuture = this.newSession();
        factoryHelper.waitForCall((Node)this.node1, KEYSPACE, NodeDistance.LOCAL);
        factoryHelper.waitForCall((Node)this.node3, KEYSPACE, NodeDistance.LOCAL);
        Assertions.assertThatStage(initFuture).isSuccess(session -> Assertions.assertThat((Map)((DefaultSession)session).getPools()).containsValues((Object[])new ChannelPool[]{pool1, pool3}));
    }

    @Test
    public void should_not_connect_to_forced_down_nodes() {
        Mockito.when((Object)this.node2.getState()).thenReturn((Object)NodeState.FORCED_DOWN);
        ChannelPool pool1 = this.mockPool((Node)this.node1);
        ChannelPool pool3 = this.mockPool((Node)this.node3);
        MockChannelPoolFactoryHelper factoryHelper = MockChannelPoolFactoryHelper.builder(this.channelPoolFactory).success((Node)this.node1, KEYSPACE, NodeDistance.LOCAL, pool1).success((Node)this.node3, KEYSPACE, NodeDistance.LOCAL, pool3).build();
        CompletionStage<CqlSession> initFuture = this.newSession();
        factoryHelper.waitForCall((Node)this.node1, KEYSPACE, NodeDistance.LOCAL);
        factoryHelper.waitForCall((Node)this.node3, KEYSPACE, NodeDistance.LOCAL);
        Assertions.assertThatStage(initFuture).isSuccess(session -> Assertions.assertThat((Map)((DefaultSession)session).getPools()).containsValues((Object[])new ChannelPool[]{pool1, pool3}));
    }

    @Test
    public void should_adjust_distance_if_changed_while_init() {
        CompletableFuture<ChannelPool> pool1Future = new CompletableFuture<ChannelPool>();
        CompletableFuture<ChannelPool> pool2Future = new CompletableFuture<ChannelPool>();
        CompletableFuture<ChannelPool> pool3Future = new CompletableFuture<ChannelPool>();
        ChannelPool pool1 = this.mockPool((Node)this.node1);
        ChannelPool pool2 = this.mockPool((Node)this.node2);
        ChannelPool pool3 = this.mockPool((Node)this.node3);
        MockChannelPoolFactoryHelper factoryHelper = MockChannelPoolFactoryHelper.builder(this.channelPoolFactory).pending((Node)this.node1, KEYSPACE, NodeDistance.LOCAL, pool1Future).pending((Node)this.node2, KEYSPACE, NodeDistance.LOCAL, pool2Future).pending((Node)this.node3, KEYSPACE, NodeDistance.LOCAL, pool3Future).build();
        CompletionStage<CqlSession> initFuture = this.newSession();
        factoryHelper.waitForCall((Node)this.node1, KEYSPACE, NodeDistance.LOCAL);
        factoryHelper.waitForCall((Node)this.node2, KEYSPACE, NodeDistance.LOCAL);
        factoryHelper.waitForCall((Node)this.node3, KEYSPACE, NodeDistance.LOCAL);
        Assertions.assertThatStage(initFuture).isNotDone();
        this.eventBus.fire((Object)new DistanceEvent(NodeDistance.REMOTE, this.node2));
        pool1Future.complete(pool1);
        pool2Future.complete(pool2);
        pool3Future.complete(pool3);
        ((ChannelPool)Mockito.verify((Object)pool2, (VerificationMode)VERIFY_TIMEOUT)).resize(NodeDistance.REMOTE);
        Assertions.assertThatStage(initFuture).isSuccess(session -> Assertions.assertThat((Map)((DefaultSession)session).getPools()).containsValues((Object[])new ChannelPool[]{pool1, pool2, pool3}));
    }

    @Test
    public void should_remove_pool_if_ignored_while_init() {
        CompletableFuture<ChannelPool> pool1Future = new CompletableFuture<ChannelPool>();
        CompletableFuture<ChannelPool> pool2Future = new CompletableFuture<ChannelPool>();
        CompletableFuture<ChannelPool> pool3Future = new CompletableFuture<ChannelPool>();
        ChannelPool pool1 = this.mockPool((Node)this.node1);
        ChannelPool pool2 = this.mockPool((Node)this.node2);
        ChannelPool pool3 = this.mockPool((Node)this.node3);
        MockChannelPoolFactoryHelper factoryHelper = MockChannelPoolFactoryHelper.builder(this.channelPoolFactory).pending((Node)this.node1, KEYSPACE, NodeDistance.LOCAL, pool1Future).pending((Node)this.node2, KEYSPACE, NodeDistance.LOCAL, pool2Future).pending((Node)this.node3, KEYSPACE, NodeDistance.LOCAL, pool3Future).build();
        CompletionStage<CqlSession> initFuture = this.newSession();
        factoryHelper.waitForCall((Node)this.node1, KEYSPACE, NodeDistance.LOCAL);
        factoryHelper.waitForCall((Node)this.node2, KEYSPACE, NodeDistance.LOCAL);
        factoryHelper.waitForCall((Node)this.node3, KEYSPACE, NodeDistance.LOCAL);
        Assertions.assertThatStage(initFuture).isNotDone();
        this.eventBus.fire((Object)new DistanceEvent(NodeDistance.IGNORED, this.node2));
        pool1Future.complete(pool1);
        pool2Future.complete(pool2);
        pool3Future.complete(pool3);
        ((ChannelPool)Mockito.verify((Object)pool2, (VerificationMode)VERIFY_TIMEOUT)).closeAsync();
        Assertions.assertThatStage(initFuture).isSuccess(session -> Assertions.assertThat((Map)((DefaultSession)session).getPools()).containsValues((Object[])new ChannelPool[]{pool1, pool3}));
    }

    @Test
    public void should_remove_pool_if_forced_down_while_init() {
        CompletableFuture<ChannelPool> pool1Future = new CompletableFuture<ChannelPool>();
        CompletableFuture<ChannelPool> pool2Future = new CompletableFuture<ChannelPool>();
        CompletableFuture<ChannelPool> pool3Future = new CompletableFuture<ChannelPool>();
        ChannelPool pool1 = this.mockPool((Node)this.node1);
        ChannelPool pool2 = this.mockPool((Node)this.node2);
        ChannelPool pool3 = this.mockPool((Node)this.node3);
        MockChannelPoolFactoryHelper factoryHelper = MockChannelPoolFactoryHelper.builder(this.channelPoolFactory).pending((Node)this.node1, KEYSPACE, NodeDistance.LOCAL, pool1Future).pending((Node)this.node2, KEYSPACE, NodeDistance.LOCAL, pool2Future).pending((Node)this.node3, KEYSPACE, NodeDistance.LOCAL, pool3Future).build();
        CompletionStage<CqlSession> initFuture = this.newSession();
        factoryHelper.waitForCall((Node)this.node1, KEYSPACE, NodeDistance.LOCAL);
        factoryHelper.waitForCall((Node)this.node2, KEYSPACE, NodeDistance.LOCAL);
        factoryHelper.waitForCall((Node)this.node3, KEYSPACE, NodeDistance.LOCAL);
        Assertions.assertThatStage(initFuture).isNotDone();
        this.eventBus.fire((Object)NodeStateEvent.changed((NodeState)NodeState.UP, (NodeState)NodeState.FORCED_DOWN, (DefaultNode)this.node2));
        pool1Future.complete(pool1);
        pool2Future.complete(pool2);
        pool3Future.complete(pool3);
        ((ChannelPool)Mockito.verify((Object)pool2, (VerificationMode)VERIFY_TIMEOUT)).closeAsync();
        Assertions.assertThatStage(initFuture).isSuccess(session -> Assertions.assertThat((Map)((DefaultSession)session).getPools()).containsValues((Object[])new ChannelPool[]{pool1, pool3}));
    }

    @Test
    public void should_resize_pool_if_distance_changes() {
        ChannelPool pool1 = this.mockPool((Node)this.node1);
        ChannelPool pool2 = this.mockPool((Node)this.node2);
        ChannelPool pool3 = this.mockPool((Node)this.node3);
        MockChannelPoolFactoryHelper factoryHelper = MockChannelPoolFactoryHelper.builder(this.channelPoolFactory).success((Node)this.node1, KEYSPACE, NodeDistance.LOCAL, pool1).success((Node)this.node2, KEYSPACE, NodeDistance.LOCAL, pool2).success((Node)this.node3, KEYSPACE, NodeDistance.LOCAL, pool3).build();
        CompletionStage<CqlSession> initFuture = this.newSession();
        factoryHelper.waitForCall((Node)this.node1, KEYSPACE, NodeDistance.LOCAL);
        factoryHelper.waitForCall((Node)this.node2, KEYSPACE, NodeDistance.LOCAL);
        factoryHelper.waitForCall((Node)this.node3, KEYSPACE, NodeDistance.LOCAL);
        Assertions.assertThatStage(initFuture).isSuccess();
        this.eventBus.fire((Object)new DistanceEvent(NodeDistance.REMOTE, this.node2));
        ((ChannelPool)Mockito.verify((Object)pool2, (VerificationMode)Mockito.timeout((long)500L))).resize(NodeDistance.REMOTE);
    }

    @Test
    public void should_remove_pool_if_node_becomes_ignored() {
        ChannelPool pool1 = this.mockPool((Node)this.node1);
        ChannelPool pool2 = this.mockPool((Node)this.node2);
        ChannelPool pool3 = this.mockPool((Node)this.node3);
        MockChannelPoolFactoryHelper factoryHelper = MockChannelPoolFactoryHelper.builder(this.channelPoolFactory).success((Node)this.node1, KEYSPACE, NodeDistance.LOCAL, pool1).success((Node)this.node2, KEYSPACE, NodeDistance.LOCAL, pool2).success((Node)this.node3, KEYSPACE, NodeDistance.LOCAL, pool3).build();
        CompletionStage<CqlSession> initFuture = this.newSession();
        factoryHelper.waitForCall((Node)this.node1, KEYSPACE, NodeDistance.LOCAL);
        factoryHelper.waitForCall((Node)this.node2, KEYSPACE, NodeDistance.LOCAL);
        factoryHelper.waitForCall((Node)this.node3, KEYSPACE, NodeDistance.LOCAL);
        Assertions.assertThatStage(initFuture).isSuccess();
        this.eventBus.fire((Object)new DistanceEvent(NodeDistance.IGNORED, this.node2));
        ((ChannelPool)Mockito.verify((Object)pool2, (VerificationMode)Mockito.timeout((long)500L))).closeAsync();
        Session session = (Session)CompletableFutures.getCompleted(initFuture.toCompletableFuture());
        Awaitility.await().untilAsserted(() -> Assertions.assertThat((Map)((DefaultSession)session).getPools()).containsValues((Object[])new ChannelPool[]{pool1, pool3}));
    }

    @Test
    public void should_do_nothing_if_node_becomes_ignored_but_was_already_ignored() throws InterruptedException {
        ChannelPool pool1 = this.mockPool((Node)this.node1);
        ChannelPool pool2 = this.mockPool((Node)this.node2);
        ChannelPool pool3 = this.mockPool((Node)this.node3);
        MockChannelPoolFactoryHelper factoryHelper = MockChannelPoolFactoryHelper.builder(this.channelPoolFactory).success((Node)this.node1, KEYSPACE, NodeDistance.LOCAL, pool1).success((Node)this.node2, KEYSPACE, NodeDistance.LOCAL, pool2).success((Node)this.node3, KEYSPACE, NodeDistance.LOCAL, pool3).build();
        CompletionStage<CqlSession> initFuture = this.newSession();
        factoryHelper.waitForCall((Node)this.node1, KEYSPACE, NodeDistance.LOCAL);
        factoryHelper.waitForCall((Node)this.node2, KEYSPACE, NodeDistance.LOCAL);
        factoryHelper.waitForCall((Node)this.node3, KEYSPACE, NodeDistance.LOCAL);
        Assertions.assertThatStage(initFuture).isSuccess();
        this.eventBus.fire((Object)new DistanceEvent(NodeDistance.IGNORED, this.node2));
        ((ChannelPool)Mockito.verify((Object)pool2, (VerificationMode)Mockito.timeout((long)100L))).closeAsync();
        Session session = (Session)CompletableFutures.getCompleted(initFuture.toCompletableFuture());
        Assertions.assertThat((Map)((DefaultSession)session).getPools()).containsValues((Object[])new ChannelPool[]{pool1, pool3});
        this.eventBus.fire((Object)new DistanceEvent(NodeDistance.IGNORED, this.node2));
        TimeUnit.MILLISECONDS.sleep(200L);
        factoryHelper.verifyNoMoreCalls();
    }

    @Test
    public void should_recreate_pool_if_node_becomes_not_ignored() {
        Mockito.when((Object)this.node2.getDistance()).thenReturn((Object)NodeDistance.IGNORED);
        ChannelPool pool1 = this.mockPool((Node)this.node1);
        ChannelPool pool2 = this.mockPool((Node)this.node2);
        ChannelPool pool3 = this.mockPool((Node)this.node3);
        MockChannelPoolFactoryHelper factoryHelper = MockChannelPoolFactoryHelper.builder(this.channelPoolFactory).success((Node)this.node1, KEYSPACE, NodeDistance.LOCAL, pool1).success((Node)this.node3, KEYSPACE, NodeDistance.LOCAL, pool3).success((Node)this.node2, KEYSPACE, NodeDistance.LOCAL, pool2).build();
        CompletionStage<CqlSession> initFuture = this.newSession();
        factoryHelper.waitForCall((Node)this.node1, KEYSPACE, NodeDistance.LOCAL);
        factoryHelper.waitForCall((Node)this.node3, KEYSPACE, NodeDistance.LOCAL);
        Assertions.assertThatStage(initFuture).isSuccess();
        Session session = (Session)CompletableFutures.getCompleted(initFuture.toCompletableFuture());
        Assertions.assertThat((Map)((DefaultSession)session).getPools()).containsValues((Object[])new ChannelPool[]{pool1, pool3});
        this.eventBus.fire((Object)new DistanceEvent(NodeDistance.LOCAL, this.node2));
        factoryHelper.waitForCall((Node)this.node2, KEYSPACE, NodeDistance.LOCAL);
        Awaitility.await().untilAsserted(() -> Assertions.assertThat((Map)((DefaultSession)session).getPools()).containsValues((Object[])new ChannelPool[]{pool1, pool2, pool3}));
    }

    @Test
    public void should_remove_pool_if_node_is_forced_down() {
        ChannelPool pool1 = this.mockPool((Node)this.node1);
        ChannelPool pool2 = this.mockPool((Node)this.node2);
        ChannelPool pool3 = this.mockPool((Node)this.node3);
        MockChannelPoolFactoryHelper factoryHelper = MockChannelPoolFactoryHelper.builder(this.channelPoolFactory).success((Node)this.node1, KEYSPACE, NodeDistance.LOCAL, pool1).success((Node)this.node2, KEYSPACE, NodeDistance.LOCAL, pool2).success((Node)this.node3, KEYSPACE, NodeDistance.LOCAL, pool3).build();
        CompletionStage<CqlSession> initFuture = this.newSession();
        factoryHelper.waitForCall((Node)this.node1, KEYSPACE, NodeDistance.LOCAL);
        factoryHelper.waitForCall((Node)this.node2, KEYSPACE, NodeDistance.LOCAL);
        factoryHelper.waitForCall((Node)this.node3, KEYSPACE, NodeDistance.LOCAL);
        Assertions.assertThatStage(initFuture).isSuccess();
        this.eventBus.fire((Object)NodeStateEvent.changed((NodeState)NodeState.UP, (NodeState)NodeState.FORCED_DOWN, (DefaultNode)this.node2));
        ((ChannelPool)Mockito.verify((Object)pool2, (VerificationMode)Mockito.timeout((long)500L))).closeAsync();
        Session session = (Session)CompletableFutures.getCompleted(initFuture.toCompletableFuture());
        Awaitility.await().untilAsserted(() -> Assertions.assertThat((Map)((DefaultSession)session).getPools()).containsValues((Object[])new ChannelPool[]{pool1, pool3}));
    }

    @Test
    public void should_recreate_pool_if_node_is_forced_back_up() {
        Mockito.when((Object)this.node2.getState()).thenReturn((Object)NodeState.FORCED_DOWN);
        ChannelPool pool1 = this.mockPool((Node)this.node1);
        ChannelPool pool2 = this.mockPool((Node)this.node2);
        ChannelPool pool3 = this.mockPool((Node)this.node3);
        MockChannelPoolFactoryHelper factoryHelper = MockChannelPoolFactoryHelper.builder(this.channelPoolFactory).success((Node)this.node1, KEYSPACE, NodeDistance.LOCAL, pool1).success((Node)this.node3, KEYSPACE, NodeDistance.LOCAL, pool3).success((Node)this.node2, KEYSPACE, NodeDistance.LOCAL, pool2).build();
        CompletionStage<CqlSession> initFuture = this.newSession();
        factoryHelper.waitForCall((Node)this.node1, KEYSPACE, NodeDistance.LOCAL);
        factoryHelper.waitForCall((Node)this.node3, KEYSPACE, NodeDistance.LOCAL);
        Assertions.assertThatStage(initFuture).isSuccess();
        Session session = (Session)CompletableFutures.getCompleted(initFuture.toCompletableFuture());
        Assertions.assertThat((Map)((DefaultSession)session).getPools()).containsValues((Object[])new ChannelPool[]{pool1, pool3});
        this.eventBus.fire((Object)NodeStateEvent.changed((NodeState)NodeState.FORCED_DOWN, (NodeState)NodeState.UP, (DefaultNode)this.node2));
        factoryHelper.waitForCall((Node)this.node2, KEYSPACE, NodeDistance.LOCAL);
        Awaitility.await().untilAsserted(() -> Assertions.assertThat((Map)((DefaultSession)session).getPools()).containsValues((Object[])new ChannelPool[]{pool1, pool2, pool3}));
    }

    @Test
    public void should_not_recreate_pool_if_node_is_forced_back_up_but_ignored() {
        Mockito.when((Object)this.node2.getState()).thenReturn((Object)NodeState.FORCED_DOWN);
        Mockito.when((Object)this.node2.getDistance()).thenReturn((Object)NodeDistance.IGNORED);
        ChannelPool pool1 = this.mockPool((Node)this.node1);
        ChannelPool pool3 = this.mockPool((Node)this.node3);
        MockChannelPoolFactoryHelper factoryHelper = MockChannelPoolFactoryHelper.builder(this.channelPoolFactory).success((Node)this.node1, KEYSPACE, NodeDistance.LOCAL, pool1).success((Node)this.node3, KEYSPACE, NodeDistance.LOCAL, pool3).build();
        CompletionStage<CqlSession> initFuture = this.newSession();
        factoryHelper.waitForCall((Node)this.node1, KEYSPACE, NodeDistance.LOCAL);
        factoryHelper.waitForCall((Node)this.node3, KEYSPACE, NodeDistance.LOCAL);
        Assertions.assertThatStage(initFuture).isSuccess();
        Session session = (Session)CompletableFutures.getCompleted(initFuture.toCompletableFuture());
        Assertions.assertThat((Map)((DefaultSession)session).getPools()).containsValues((Object[])new ChannelPool[]{pool1, pool3});
        this.eventBus.fire((Object)NodeStateEvent.changed((NodeState)NodeState.FORCED_DOWN, (NodeState)NodeState.UP, (DefaultNode)this.node2));
        Awaitility.await().untilAsserted(() -> Assertions.assertThat((Map)((DefaultSession)session).getPools()).containsValues((Object[])new ChannelPool[]{pool1, pool3}));
        factoryHelper.verifyNoMoreCalls();
    }

    @Test
    public void should_adjust_distance_if_changed_while_recreating() {
        Mockito.when((Object)this.node2.getDistance()).thenReturn((Object)NodeDistance.IGNORED);
        ChannelPool pool1 = this.mockPool((Node)this.node1);
        ChannelPool pool2 = this.mockPool((Node)this.node2);
        CompletableFuture<ChannelPool> pool2Future = new CompletableFuture<ChannelPool>();
        ChannelPool pool3 = this.mockPool((Node)this.node3);
        MockChannelPoolFactoryHelper factoryHelper = MockChannelPoolFactoryHelper.builder(this.channelPoolFactory).success((Node)this.node1, KEYSPACE, NodeDistance.LOCAL, pool1).success((Node)this.node3, KEYSPACE, NodeDistance.LOCAL, pool3).pending((Node)this.node2, KEYSPACE, NodeDistance.LOCAL, pool2Future).build();
        CompletionStage<CqlSession> initFuture = this.newSession();
        factoryHelper.waitForCall((Node)this.node1, KEYSPACE, NodeDistance.LOCAL);
        factoryHelper.waitForCall((Node)this.node3, KEYSPACE, NodeDistance.LOCAL);
        Assertions.assertThatStage(initFuture).isSuccess();
        Session session = (Session)CompletableFutures.getCompleted(initFuture.toCompletableFuture());
        Assertions.assertThat((Map)((DefaultSession)session).getPools()).containsValues((Object[])new ChannelPool[]{pool1, pool3});
        this.eventBus.fire((Object)new DistanceEvent(NodeDistance.LOCAL, this.node2));
        factoryHelper.waitForCall((Node)this.node2, KEYSPACE, NodeDistance.LOCAL);
        this.eventBus.fire((Object)new DistanceEvent(NodeDistance.REMOTE, this.node2));
        pool2Future.complete(pool2);
        ((ChannelPool)Mockito.verify((Object)pool2, (VerificationMode)VERIFY_TIMEOUT)).resize(NodeDistance.REMOTE);
        Awaitility.await().untilAsserted(() -> Assertions.assertThat((Map)((DefaultSession)session).getPools()).containsValues((Object[])new ChannelPool[]{pool1, pool2, pool3}));
    }

    @Test
    public void should_remove_pool_if_ignored_while_recreating() {
        Mockito.when((Object)this.node2.getDistance()).thenReturn((Object)NodeDistance.IGNORED);
        ChannelPool pool1 = this.mockPool((Node)this.node1);
        ChannelPool pool2 = this.mockPool((Node)this.node2);
        CompletableFuture<ChannelPool> pool2Future = new CompletableFuture<ChannelPool>();
        ChannelPool pool3 = this.mockPool((Node)this.node3);
        MockChannelPoolFactoryHelper factoryHelper = MockChannelPoolFactoryHelper.builder(this.channelPoolFactory).success((Node)this.node1, KEYSPACE, NodeDistance.LOCAL, pool1).success((Node)this.node3, KEYSPACE, NodeDistance.LOCAL, pool3).pending((Node)this.node2, KEYSPACE, NodeDistance.LOCAL, pool2Future).build();
        CompletionStage<CqlSession> initFuture = this.newSession();
        factoryHelper.waitForCall((Node)this.node1, KEYSPACE, NodeDistance.LOCAL);
        factoryHelper.waitForCall((Node)this.node3, KEYSPACE, NodeDistance.LOCAL);
        Assertions.assertThatStage(initFuture).isSuccess();
        Session session = (Session)CompletableFutures.getCompleted(initFuture.toCompletableFuture());
        Assertions.assertThat((Map)((DefaultSession)session).getPools()).containsValues((Object[])new ChannelPool[]{pool1, pool3});
        this.eventBus.fire((Object)new DistanceEvent(NodeDistance.LOCAL, this.node2));
        factoryHelper.waitForCall((Node)this.node2, KEYSPACE, NodeDistance.LOCAL);
        this.eventBus.fire((Object)new DistanceEvent(NodeDistance.IGNORED, this.node2));
        pool2Future.complete(pool2);
        ((ChannelPool)Mockito.verify((Object)pool2, (VerificationMode)VERIFY_TIMEOUT)).closeAsync();
        Awaitility.await().untilAsserted(() -> Assertions.assertThat((Map)((DefaultSession)session).getPools()).containsValues((Object[])new ChannelPool[]{pool1, pool3}));
    }

    @Test
    public void should_remove_pool_if_forced_down_while_recreating() {
        Mockito.when((Object)this.node2.getDistance()).thenReturn((Object)NodeDistance.IGNORED);
        ChannelPool pool1 = this.mockPool((Node)this.node1);
        ChannelPool pool2 = this.mockPool((Node)this.node2);
        CompletableFuture<ChannelPool> pool2Future = new CompletableFuture<ChannelPool>();
        ChannelPool pool3 = this.mockPool((Node)this.node3);
        MockChannelPoolFactoryHelper factoryHelper = MockChannelPoolFactoryHelper.builder(this.channelPoolFactory).success((Node)this.node1, KEYSPACE, NodeDistance.LOCAL, pool1).success((Node)this.node3, KEYSPACE, NodeDistance.LOCAL, pool3).pending((Node)this.node2, KEYSPACE, NodeDistance.LOCAL, pool2Future).build();
        CompletionStage<CqlSession> initFuture = this.newSession();
        factoryHelper.waitForCall((Node)this.node1, KEYSPACE, NodeDistance.LOCAL);
        factoryHelper.waitForCall((Node)this.node3, KEYSPACE, NodeDistance.LOCAL);
        Assertions.assertThatStage(initFuture).isSuccess();
        Session session = (Session)CompletableFutures.getCompleted(initFuture.toCompletableFuture());
        Assertions.assertThat((Map)((DefaultSession)session).getPools()).containsValues((Object[])new ChannelPool[]{pool1, pool3});
        this.eventBus.fire((Object)new DistanceEvent(NodeDistance.LOCAL, this.node2));
        factoryHelper.waitForCall((Node)this.node2, KEYSPACE, NodeDistance.LOCAL);
        this.eventBus.fire((Object)NodeStateEvent.changed((NodeState)NodeState.UP, (NodeState)NodeState.FORCED_DOWN, (DefaultNode)this.node2));
        pool2Future.complete(pool2);
        ((ChannelPool)Mockito.verify((Object)pool2, (VerificationMode)VERIFY_TIMEOUT)).closeAsync();
        Awaitility.await().untilAsserted(() -> Assertions.assertThat((Map)((DefaultSession)session).getPools()).containsValues((Object[])new ChannelPool[]{pool1, pool3}));
    }

    @Test
    public void should_close_all_pools_when_closing() {
        ChannelPool pool1 = this.mockPool((Node)this.node1);
        ChannelPool pool2 = this.mockPool((Node)this.node2);
        ChannelPool pool3 = this.mockPool((Node)this.node3);
        MockChannelPoolFactoryHelper factoryHelper = MockChannelPoolFactoryHelper.builder(this.channelPoolFactory).success((Node)this.node1, KEYSPACE, NodeDistance.LOCAL, pool1).success((Node)this.node2, KEYSPACE, NodeDistance.LOCAL, pool2).success((Node)this.node3, KEYSPACE, NodeDistance.LOCAL, pool3).build();
        CompletionStage<CqlSession> initFuture = this.newSession();
        factoryHelper.waitForCall((Node)this.node1, KEYSPACE, NodeDistance.LOCAL);
        factoryHelper.waitForCall((Node)this.node2, KEYSPACE, NodeDistance.LOCAL);
        factoryHelper.waitForCall((Node)this.node3, KEYSPACE, NodeDistance.LOCAL);
        Assertions.assertThatStage(initFuture).isSuccess();
        Session session = (Session)CompletableFutures.getCompleted(initFuture.toCompletableFuture());
        CompletionStage closeFuture = session.closeAsync();
        Assertions.assertThatStage(closeFuture).isSuccess();
        ((ChannelPool)Mockito.verify((Object)pool1, (VerificationMode)VERIFY_TIMEOUT)).closeAsync();
        ((ChannelPool)Mockito.verify((Object)pool2, (VerificationMode)VERIFY_TIMEOUT)).closeAsync();
        ((ChannelPool)Mockito.verify((Object)pool3, (VerificationMode)VERIFY_TIMEOUT)).closeAsync();
    }

    @Test
    public void should_force_close_all_pools_when_force_closing() {
        ChannelPool pool1 = this.mockPool((Node)this.node1);
        ChannelPool pool2 = this.mockPool((Node)this.node2);
        ChannelPool pool3 = this.mockPool((Node)this.node3);
        MockChannelPoolFactoryHelper factoryHelper = MockChannelPoolFactoryHelper.builder(this.channelPoolFactory).success((Node)this.node1, KEYSPACE, NodeDistance.LOCAL, pool1).success((Node)this.node2, KEYSPACE, NodeDistance.LOCAL, pool2).success((Node)this.node3, KEYSPACE, NodeDistance.LOCAL, pool3).build();
        CompletionStage<CqlSession> initFuture = this.newSession();
        factoryHelper.waitForCall((Node)this.node1, KEYSPACE, NodeDistance.LOCAL);
        factoryHelper.waitForCall((Node)this.node2, KEYSPACE, NodeDistance.LOCAL);
        factoryHelper.waitForCall((Node)this.node3, KEYSPACE, NodeDistance.LOCAL);
        Assertions.assertThatStage(initFuture).isSuccess();
        Session session = (Session)CompletableFutures.getCompleted(initFuture.toCompletableFuture());
        CompletionStage closeFuture = session.forceCloseAsync();
        Assertions.assertThatStage(closeFuture).isSuccess();
        ((ChannelPool)Mockito.verify((Object)pool1, (VerificationMode)VERIFY_TIMEOUT)).forceCloseAsync();
        ((ChannelPool)Mockito.verify((Object)pool2, (VerificationMode)VERIFY_TIMEOUT)).forceCloseAsync();
        ((ChannelPool)Mockito.verify((Object)pool3, (VerificationMode)VERIFY_TIMEOUT)).forceCloseAsync();
    }

    @Test
    public void should_close_pool_if_recreated_while_closing() {
        Mockito.when((Object)this.node2.getState()).thenReturn((Object)NodeState.FORCED_DOWN);
        ChannelPool pool1 = this.mockPool((Node)this.node1);
        ChannelPool pool2 = this.mockPool((Node)this.node2);
        CompletableFuture<ChannelPool> pool2Future = new CompletableFuture<ChannelPool>();
        ChannelPool pool3 = this.mockPool((Node)this.node3);
        MockChannelPoolFactoryHelper factoryHelper = MockChannelPoolFactoryHelper.builder(this.channelPoolFactory).success((Node)this.node1, KEYSPACE, NodeDistance.LOCAL, pool1).success((Node)this.node3, KEYSPACE, NodeDistance.LOCAL, pool3).pending((Node)this.node2, KEYSPACE, NodeDistance.LOCAL, pool2Future).build();
        CompletionStage<CqlSession> initFuture = this.newSession();
        factoryHelper.waitForCall((Node)this.node1, KEYSPACE, NodeDistance.LOCAL);
        factoryHelper.waitForCall((Node)this.node3, KEYSPACE, NodeDistance.LOCAL);
        Assertions.assertThatStage(initFuture).isSuccess();
        Session session = (Session)CompletableFutures.getCompleted(initFuture.toCompletableFuture());
        Assertions.assertThat((Map)((DefaultSession)session).getPools()).containsValues((Object[])new ChannelPool[]{pool1, pool3});
        this.eventBus.fire((Object)NodeStateEvent.changed((NodeState)NodeState.FORCED_DOWN, (NodeState)NodeState.UP, (DefaultNode)this.node2));
        factoryHelper.waitForCall((Node)this.node2, KEYSPACE, NodeDistance.LOCAL);
        CompletionStage closeFuture = session.closeAsync();
        Assertions.assertThatStage(closeFuture).isSuccess();
        pool2Future.complete(pool2);
        ((ChannelPool)Mockito.verify((Object)pool2, (VerificationMode)VERIFY_TIMEOUT)).forceCloseAsync();
    }

    @Test
    public void should_set_keyspace_on_all_pools() {
        ChannelPool pool1 = this.mockPool((Node)this.node1);
        ChannelPool pool2 = this.mockPool((Node)this.node2);
        ChannelPool pool3 = this.mockPool((Node)this.node3);
        MockChannelPoolFactoryHelper factoryHelper = MockChannelPoolFactoryHelper.builder(this.channelPoolFactory).success((Node)this.node1, KEYSPACE, NodeDistance.LOCAL, pool1).success((Node)this.node2, KEYSPACE, NodeDistance.LOCAL, pool2).success((Node)this.node3, KEYSPACE, NodeDistance.LOCAL, pool3).build();
        CompletionStage<CqlSession> initFuture = this.newSession();
        factoryHelper.waitForCall((Node)this.node1, KEYSPACE, NodeDistance.LOCAL);
        factoryHelper.waitForCall((Node)this.node2, KEYSPACE, NodeDistance.LOCAL);
        factoryHelper.waitForCall((Node)this.node3, KEYSPACE, NodeDistance.LOCAL);
        Assertions.assertThatStage(initFuture).isSuccess();
        Session session = (Session)CompletableFutures.getCompleted(initFuture.toCompletableFuture());
        CqlIdentifier newKeyspace = CqlIdentifier.fromInternal((String)"newKeyspace");
        ((DefaultSession)session).setKeyspace(newKeyspace);
        ((ChannelPool)Mockito.verify((Object)pool1, (VerificationMode)VERIFY_TIMEOUT)).setKeyspace(newKeyspace);
        ((ChannelPool)Mockito.verify((Object)pool2, (VerificationMode)VERIFY_TIMEOUT)).setKeyspace(newKeyspace);
        ((ChannelPool)Mockito.verify((Object)pool3, (VerificationMode)VERIFY_TIMEOUT)).setKeyspace(newKeyspace);
    }

    @Test
    public void should_set_keyspace_on_pool_if_recreated_while_switching_keyspace() {
        Mockito.when((Object)this.node2.getState()).thenReturn((Object)NodeState.FORCED_DOWN);
        ChannelPool pool1 = this.mockPool((Node)this.node1);
        ChannelPool pool2 = this.mockPool((Node)this.node2);
        CompletableFuture<ChannelPool> pool2Future = new CompletableFuture<ChannelPool>();
        ChannelPool pool3 = this.mockPool((Node)this.node3);
        MockChannelPoolFactoryHelper factoryHelper = MockChannelPoolFactoryHelper.builder(this.channelPoolFactory).success((Node)this.node1, KEYSPACE, NodeDistance.LOCAL, pool1).success((Node)this.node3, KEYSPACE, NodeDistance.LOCAL, pool3).pending((Node)this.node2, KEYSPACE, NodeDistance.LOCAL, pool2Future).build();
        CompletionStage<CqlSession> initFuture = this.newSession();
        factoryHelper.waitForCall((Node)this.node1, KEYSPACE, NodeDistance.LOCAL);
        factoryHelper.waitForCall((Node)this.node3, KEYSPACE, NodeDistance.LOCAL);
        Assertions.assertThatStage(initFuture).isSuccess();
        DefaultSession session = (DefaultSession)CompletableFutures.getCompleted(initFuture.toCompletableFuture());
        Assertions.assertThat((Map)session.getPools()).containsValues((Object[])new ChannelPool[]{pool1, pool3});
        this.eventBus.fire((Object)NodeStateEvent.changed((NodeState)NodeState.FORCED_DOWN, (NodeState)NodeState.UP, (DefaultNode)this.node2));
        factoryHelper.waitForCall((Node)this.node2, KEYSPACE, NodeDistance.LOCAL);
        CqlIdentifier newKeyspace = CqlIdentifier.fromInternal((String)"newKeyspace");
        session.setKeyspace(newKeyspace);
        ((ChannelPool)Mockito.verify((Object)pool1, (VerificationMode)VERIFY_TIMEOUT)).setKeyspace(newKeyspace);
        ((ChannelPool)Mockito.verify((Object)pool3, (VerificationMode)VERIFY_TIMEOUT)).setKeyspace(newKeyspace);
        pool2Future.complete(pool2);
        ((ChannelPool)Mockito.verify((Object)pool2, (VerificationMode)VERIFY_TIMEOUT)).setKeyspace(newKeyspace);
    }

    private ChannelPool mockPool(Node node) {
        ChannelPool pool = (ChannelPool)Mockito.mock(ChannelPool.class);
        Mockito.when((Object)pool.getNode()).thenReturn((Object)node);
        Mockito.when((Object)pool.getInitialKeyspaceName()).thenReturn((Object)KEYSPACE);
        Mockito.when((Object)pool.setKeyspace((CqlIdentifier)ArgumentMatchers.any(CqlIdentifier.class))).thenReturn(CompletableFuture.completedFuture(null));
        CompletableFuture closeFuture = new CompletableFuture();
        Mockito.when((Object)pool.closeFuture()).thenReturn(closeFuture);
        Mockito.when((Object)pool.closeAsync()).then(i -> {
            closeFuture.complete(null);
            return closeFuture;
        });
        Mockito.when((Object)pool.forceCloseAsync()).then(i -> {
            closeFuture.complete(null);
            return closeFuture;
        });
        return pool;
    }

    private CompletionStage<CqlSession> newSession() {
        return DefaultSession.init((InternalDriverContext)this.context, Collections.emptySet(), (CqlIdentifier)KEYSPACE);
    }

    private static DefaultNode mockLocalNode(int i) {
        DefaultNode node = (DefaultNode)Mockito.mock(DefaultNode.class);
        Mockito.when((Object)node.getHostId()).thenReturn((Object)UUID.randomUUID());
        DefaultEndPoint endPoint = TestNodeFactory.newEndPoint(i);
        Mockito.when((Object)node.getEndPoint()).thenReturn((Object)endPoint);
        Mockito.when((Object)node.getBroadcastRpcAddress()).thenReturn(Optional.of(endPoint.resolve()));
        Mockito.when((Object)node.getDistance()).thenReturn((Object)NodeDistance.LOCAL);
        Mockito.when((Object)node.toString()).thenReturn((Object)("node" + i));
        return node;
    }
}

