/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.protocol;

import com.datastax.oss.driver.internal.core.protocol.ByteBufSegmentBuilder;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableList;
import io.netty.channel.ChannelPromise;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;

public class SliceWriteListenerTest {
    private final EmbeddedChannel channel = new EmbeddedChannel();
    private ChannelPromise framePromise;
    private ChannelPromise slicePromise1;
    private ChannelPromise slicePromise2;
    private ChannelPromise slicePromise3;

    @Before
    public void setup() {
        this.framePromise = this.channel.newPromise();
        this.slicePromise1 = this.channel.newPromise();
        this.slicePromise2 = this.channel.newPromise();
        this.slicePromise3 = this.channel.newPromise();
        ByteBufSegmentBuilder.SliceWriteListener listener = new ByteBufSegmentBuilder.SliceWriteListener(this.framePromise, (List)ImmutableList.of((Object)this.slicePromise1, (Object)this.slicePromise2, (Object)this.slicePromise3));
        this.slicePromise1.addListener((GenericFutureListener)listener);
        this.slicePromise2.addListener((GenericFutureListener)listener);
        this.slicePromise3.addListener((GenericFutureListener)listener);
        Assertions.assertThat((boolean)this.framePromise.isDone()).isFalse();
    }

    @Test
    public void should_succeed_frame_if_all_slices_succeed() {
        this.slicePromise1.setSuccess();
        Assertions.assertThat((boolean)this.framePromise.isDone()).isFalse();
        this.slicePromise2.setSuccess();
        Assertions.assertThat((boolean)this.framePromise.isDone()).isFalse();
        this.slicePromise3.setSuccess();
        Assertions.assertThat((boolean)this.framePromise.isSuccess()).isTrue();
    }

    @Test
    public void should_fail_frame_and_cancel_remaining_slices_if_one_slice_fails() {
        this.slicePromise1.setSuccess();
        Assertions.assertThat((boolean)this.framePromise.isDone()).isFalse();
        Exception failure = new Exception("test");
        this.slicePromise2.setFailure((Throwable)failure);
        Assertions.assertThat((boolean)this.framePromise.isDone()).isTrue();
        Assertions.assertThat((boolean)this.framePromise.isSuccess()).isFalse();
        Assertions.assertThat((Throwable)this.framePromise.cause()).isEqualTo((Object)failure);
        Assertions.assertThat((boolean)this.slicePromise3.isCancelled()).isTrue();
    }
}

