/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.protocol;

import com.datastax.oss.driver.internal.core.protocol.ByteBufPrimitiveCodec;
import com.datastax.oss.driver.internal.core.protocol.SegmentToFrameDecoder;
import com.datastax.oss.driver.shaded.guava.common.base.Strings;
import com.datastax.oss.protocol.internal.Compressor;
import com.datastax.oss.protocol.internal.Frame;
import com.datastax.oss.protocol.internal.FrameCodec;
import com.datastax.oss.protocol.internal.Message;
import com.datastax.oss.protocol.internal.PrimitiveCodec;
import com.datastax.oss.protocol.internal.ProtocolV5ClientCodecs;
import com.datastax.oss.protocol.internal.ProtocolV5ServerCodecs;
import com.datastax.oss.protocol.internal.Segment;
import com.datastax.oss.protocol.internal.request.AuthResponse;
import com.datastax.oss.protocol.internal.response.result.Void;
import com.datastax.oss.protocol.internal.util.Bytes;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.UnpooledByteBufAllocator;
import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import java.util.Collections;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;

public class SegmentToFrameDecoderTest {
    private static final FrameCodec<ByteBuf> FRAME_CODEC = new FrameCodec((PrimitiveCodec)new ByteBufPrimitiveCodec((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT), Compressor.none(), new FrameCodec.CodecGroup[]{new ProtocolV5ClientCodecs(), new ProtocolV5ServerCodecs()});
    private EmbeddedChannel channel;

    @Before
    public void setup() {
        this.channel = new EmbeddedChannel();
        this.channel.pipeline().addLast(new ChannelHandler[]{new SegmentToFrameDecoder(FRAME_CODEC, "test")});
    }

    @Test
    public void should_decode_self_contained() {
        ByteBuf payload = UnpooledByteBufAllocator.DEFAULT.buffer();
        payload.writeBytes(SegmentToFrameDecoderTest.encodeFrame((Message)Void.INSTANCE));
        payload.writeBytes(SegmentToFrameDecoderTest.encodeFrame((Message)new AuthResponse(Bytes.fromHexString((String)"0xabcdef"))));
        this.channel.writeInbound(new Object[]{new Segment((Object)payload, true)});
        Frame frame1 = (Frame)this.channel.readInbound();
        Assertions.assertThat((Object)frame1.message).isInstanceOf(Void.class);
        Frame frame2 = (Frame)this.channel.readInbound();
        Assertions.assertThat((Object)frame2.message).isInstanceOf(AuthResponse.class);
    }

    @Test
    public void should_decode_sequence_of_slices() {
        ByteBuf encodedFrame = SegmentToFrameDecoderTest.encodeFrame((Message)new AuthResponse(Bytes.fromHexString((String)("0x" + Strings.repeat((String)"aa", (int)1011)))));
        int sliceLength = 100;
        do {
            ByteBuf payload = encodedFrame.readRetainedSlice(Math.min(sliceLength, encodedFrame.readableBytes()));
            this.channel.writeInbound(new Object[]{new Segment((Object)payload, false)});
        } while (encodedFrame.isReadable());
        Frame frame = (Frame)this.channel.readInbound();
        Assertions.assertThat((Object)frame.message).isInstanceOf(AuthResponse.class);
    }

    private static ByteBuf encodeFrame(Message message) {
        Frame frame = Frame.forResponse((int)5, (int)1, null, Collections.emptyMap(), Collections.emptyList(), (Message)message);
        return (ByteBuf)FRAME_CODEC.encode(frame);
    }
}

