/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.protocol;

import com.datastax.oss.driver.api.core.connection.CrcMismatchException;
import com.datastax.oss.driver.internal.core.protocol.ByteBufPrimitiveCodec;
import com.datastax.oss.driver.internal.core.protocol.BytesToSegmentDecoder;
import com.datastax.oss.driver.internal.core.protocol.Lz4Compressor;
import com.datastax.oss.protocol.internal.Compressor;
import com.datastax.oss.protocol.internal.PrimitiveCodec;
import com.datastax.oss.protocol.internal.Segment;
import com.datastax.oss.protocol.internal.SegmentCodec;
import com.google.common.base.Strings;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.buffer.UnpooledByteBufAllocator;
import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.DecoderException;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class BytesToSegmentDecoderTest {
    private static final ByteBuf REGULAR_HEADER = BytesToSegmentDecoderTest.byteBuf("04000201f9f2");
    private static final ByteBuf REGULAR_PAYLOAD = BytesToSegmentDecoderTest.byteBuf("00000001");
    private static final ByteBuf REGULAR_TRAILER = BytesToSegmentDecoderTest.byteBuf("1fd6022d");
    private static final ByteBuf REGULAR_WRONG_HEADER = BytesToSegmentDecoderTest.byteBuf("04000202f9f2");
    private static final ByteBuf REGULAR_WRONG_TRAILER = BytesToSegmentDecoderTest.byteBuf("1fd6022e");
    private static final ByteBuf MAX_HEADER = BytesToSegmentDecoderTest.byteBuf("ffff03254047");
    private static final ByteBuf MAX_PAYLOAD = BytesToSegmentDecoderTest.byteBuf(Strings.repeat((String)"01", (int)Segment.MAX_PAYLOAD_LENGTH));
    private static final ByteBuf MAX_TRAILER = BytesToSegmentDecoderTest.byteBuf("a05c2f13");
    private static final ByteBuf LZ4_HEADER = BytesToSegmentDecoderTest.byteBuf("120020000491c94f");
    private static final ByteBuf LZ4_PAYLOAD_UNCOMPRESSED = BytesToSegmentDecoderTest.byteBuf("00000001000000010000000100000001");
    private static final ByteBuf LZ4_PAYLOAD_COMPRESSED = BytesToSegmentDecoderTest.byteBuf("f00100000001000000010000000100000001");
    private static final ByteBuf LZ4_TRAILER = BytesToSegmentDecoderTest.byteBuf("2bd67f90");
    private static final Compressor<ByteBuf> LZ4_COMPRESSOR = new Lz4Compressor("test");
    private EmbeddedChannel channel;

    @Before
    public void setup() {
        this.channel = new EmbeddedChannel();
    }

    @Test
    public void should_decode_regular_segment() {
        this.channel.pipeline().addLast(new ChannelHandler[]{this.newDecoder((Compressor<ByteBuf>)Compressor.none())});
        this.channel.writeInbound(new Object[]{Unpooled.wrappedBuffer((ByteBuf[])new ByteBuf[]{REGULAR_HEADER, REGULAR_PAYLOAD, REGULAR_TRAILER})});
        Segment segment = (Segment)this.channel.readInbound();
        Assertions.assertThat((boolean)segment.isSelfContained).isTrue();
        Assertions.assertThat((Comparable)((ByteBuf)segment.payload)).isEqualTo((Object)REGULAR_PAYLOAD);
    }

    @Test
    public void should_decode_max_length_segment() {
        this.channel.pipeline().addLast(new ChannelHandler[]{this.newDecoder((Compressor<ByteBuf>)Compressor.none())});
        this.channel.writeInbound(new Object[]{Unpooled.wrappedBuffer((ByteBuf[])new ByteBuf[]{MAX_HEADER, MAX_PAYLOAD, MAX_TRAILER})});
        Segment segment = (Segment)this.channel.readInbound();
        Assertions.assertThat((boolean)segment.isSelfContained).isTrue();
        Assertions.assertThat((Comparable)((ByteBuf)segment.payload)).isEqualTo((Object)MAX_PAYLOAD);
    }

    @Test
    public void should_decode_segment_from_multiple_incoming_chunks() {
        this.channel.pipeline().addLast(new ChannelHandler[]{this.newDecoder((Compressor<ByteBuf>)Compressor.none())});
        ByteBuf headerStart = REGULAR_HEADER.slice(0, 3);
        ByteBuf headerEnd = REGULAR_HEADER.slice(3, 3);
        this.channel.writeInbound(new Object[]{headerStart});
        this.channel.writeInbound(new Object[]{headerEnd});
        this.channel.writeInbound(new Object[]{REGULAR_PAYLOAD.duplicate()});
        this.channel.writeInbound(new Object[]{REGULAR_TRAILER.duplicate()});
        Segment segment = (Segment)this.channel.readInbound();
        Assertions.assertThat((boolean)segment.isSelfContained).isTrue();
        Assertions.assertThat((Comparable)((ByteBuf)segment.payload)).isEqualTo((Object)REGULAR_PAYLOAD);
    }

    @Test
    public void should_decode_compressed_segment() {
        this.channel.pipeline().addLast(new ChannelHandler[]{this.newDecoder(LZ4_COMPRESSOR)});
        ByteBuf buffer = Unpooled.wrappedBuffer((ByteBuf[])new ByteBuf[]{LZ4_HEADER, LZ4_PAYLOAD_COMPRESSED, LZ4_TRAILER}).copy();
        this.channel.writeInbound(new Object[]{buffer});
        Segment segment = (Segment)this.channel.readInbound();
        Assertions.assertThat((boolean)segment.isSelfContained).isTrue();
        Assertions.assertThat((Comparable)((ByteBuf)segment.payload)).isEqualTo((Object)LZ4_PAYLOAD_UNCOMPRESSED);
    }

    @Test
    public void should_surface_header_crc_mismatch() {
        try {
            this.channel.pipeline().addLast(new ChannelHandler[]{this.newDecoder((Compressor<ByteBuf>)Compressor.none())});
            this.channel.writeInbound(new Object[]{Unpooled.wrappedBuffer((ByteBuf[])new ByteBuf[]{REGULAR_WRONG_HEADER, REGULAR_PAYLOAD, REGULAR_TRAILER})});
            Assertions.fail((String)("Expected a " + DecoderException.class.getSimpleName()));
        }
        catch (DecoderException exception) {
            Assertions.assertThat((Throwable)exception).hasCauseInstanceOf(CrcMismatchException.class);
        }
    }

    @Test
    public void should_surface_trailer_crc_mismatch() {
        try {
            this.channel.pipeline().addLast(new ChannelHandler[]{this.newDecoder((Compressor<ByteBuf>)Compressor.none())});
            this.channel.writeInbound(new Object[]{Unpooled.wrappedBuffer((ByteBuf[])new ByteBuf[]{REGULAR_HEADER, REGULAR_PAYLOAD, REGULAR_WRONG_TRAILER})});
            Assertions.fail((String)("Expected a " + DecoderException.class.getSimpleName()));
        }
        catch (DecoderException exception) {
            Assertions.assertThat((Throwable)exception).hasCauseInstanceOf(CrcMismatchException.class);
        }
    }

    private BytesToSegmentDecoder newDecoder(Compressor<ByteBuf> compressor) {
        return new BytesToSegmentDecoder(new SegmentCodec((PrimitiveCodec)new ByteBufPrimitiveCodec((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT), compressor));
    }

    private static ByteBuf byteBuf(String hex) {
        return Unpooled.unreleasableBuffer((ByteBuf)Unpooled.wrappedBuffer((byte[])ByteBufUtil.decodeHexDump((CharSequence)hex)).asReadOnly());
    }
}

