/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.pool;

import com.datastax.oss.driver.Assertions;
import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.config.DriverOption;
import com.datastax.oss.driver.api.core.connection.ReconnectionPolicy;
import com.datastax.oss.driver.api.core.loadbalancing.NodeDistance;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.internal.core.channel.ChannelEvent;
import com.datastax.oss.driver.internal.core.channel.DriverChannel;
import com.datastax.oss.driver.internal.core.channel.MockChannelFactoryHelper;
import com.datastax.oss.driver.internal.core.context.EventBus;
import com.datastax.oss.driver.internal.core.context.InternalDriverContext;
import com.datastax.oss.driver.internal.core.pool.ChannelPool;
import com.datastax.oss.driver.internal.core.pool.ChannelPoolTestBase;
import io.netty.channel.ChannelPromise;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.awaitility.Awaitility;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class ChannelPoolReconnectTest
extends ChannelPoolTestBase {
    @Test
    public void should_reconnect_when_channel_closes() throws Exception {
        Mockito.when((Object)this.reconnectionSchedule.nextDelay()).thenReturn((Object)Duration.ofNanos(1L));
        Mockito.when((Object)this.defaultProfile.getInt((DriverOption)DefaultDriverOption.CONNECTION_POOL_LOCAL_SIZE)).thenReturn((Object)2);
        DriverChannel channel1 = this.newMockDriverChannel(1);
        DriverChannel channel2 = this.newMockDriverChannel(2);
        DriverChannel channel3 = this.newMockDriverChannel(3);
        CompletableFuture<DriverChannel> channel3Future = new CompletableFuture<DriverChannel>();
        MockChannelFactoryHelper factoryHelper = MockChannelFactoryHelper.builder(this.channelFactory).success((Node)this.node, channel1).success((Node)this.node, channel2).pending((Node)this.node, channel3Future).build();
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.eventBus});
        CompletionStage poolFuture = ChannelPool.init((Node)this.node, null, (NodeDistance)NodeDistance.LOCAL, (InternalDriverContext)this.context, (String)"test");
        factoryHelper.waitForCalls((Node)this.node, 2);
        Assertions.assertThatStage(poolFuture).isSuccess();
        ChannelPool pool = (ChannelPool)poolFuture.toCompletableFuture().get();
        Assertions.assertThat((Iterable)pool.channels).containsOnly((Object[])new DriverChannel[]{channel1, channel2});
        ((EventBus)inOrder.verify((Object)this.eventBus, VERIFY_TIMEOUT.times(2))).fire((Object)ChannelEvent.channelOpened((Node)this.node));
        ((ChannelPromise)channel2.closeFuture()).setFailure((Throwable)new Exception("mock channel init failure"));
        ((EventBus)inOrder.verify((Object)this.eventBus, (VerificationMode)VERIFY_TIMEOUT)).fire((Object)ChannelEvent.channelClosed((Node)this.node));
        ((ReconnectionPolicy.ReconnectionSchedule)Mockito.verify((Object)this.reconnectionSchedule, (VerificationMode)VERIFY_TIMEOUT)).nextDelay();
        ((EventBus)inOrder.verify((Object)this.eventBus, (VerificationMode)VERIFY_TIMEOUT)).fire((Object)ChannelEvent.reconnectionStarted((Node)this.node));
        factoryHelper.waitForCall((Node)this.node);
        channel3Future.complete(channel3);
        ((EventBus)inOrder.verify((Object)this.eventBus, (VerificationMode)VERIFY_TIMEOUT)).fire((Object)ChannelEvent.channelOpened((Node)this.node));
        ((EventBus)Mockito.verify((Object)this.eventBus, (VerificationMode)VERIFY_TIMEOUT)).fire((Object)ChannelEvent.reconnectionStopped((Node)this.node));
        Awaitility.await().untilAsserted(() -> Assertions.assertThat((Iterable)pool.channels).containsOnly((Object[])new DriverChannel[]{channel1, channel3}));
        factoryHelper.verifyNoMoreCalls();
    }

    @Test
    public void should_reconnect_when_channel_starts_graceful_shutdown() throws Exception {
        Mockito.when((Object)this.reconnectionSchedule.nextDelay()).thenReturn((Object)Duration.ofNanos(1L));
        Mockito.when((Object)this.defaultProfile.getInt((DriverOption)DefaultDriverOption.CONNECTION_POOL_LOCAL_SIZE)).thenReturn((Object)2);
        DriverChannel channel1 = this.newMockDriverChannel(1);
        DriverChannel channel2 = this.newMockDriverChannel(2);
        DriverChannel channel3 = this.newMockDriverChannel(3);
        CompletableFuture<DriverChannel> channel3Future = new CompletableFuture<DriverChannel>();
        MockChannelFactoryHelper factoryHelper = MockChannelFactoryHelper.builder(this.channelFactory).success((Node)this.node, channel1).success((Node)this.node, channel2).pending((Node)this.node, channel3Future).build();
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.eventBus});
        CompletionStage poolFuture = ChannelPool.init((Node)this.node, null, (NodeDistance)NodeDistance.LOCAL, (InternalDriverContext)this.context, (String)"test");
        factoryHelper.waitForCalls((Node)this.node, 2);
        Assertions.assertThatStage(poolFuture).isSuccess();
        ChannelPool pool = (ChannelPool)poolFuture.toCompletableFuture().get();
        Assertions.assertThat((Iterable)pool.channels).containsOnly((Object[])new DriverChannel[]{channel1, channel2});
        ((EventBus)inOrder.verify((Object)this.eventBus, VERIFY_TIMEOUT.times(2))).fire((Object)ChannelEvent.channelOpened((Node)this.node));
        ((ChannelPromise)channel2.closeStartedFuture()).setSuccess();
        ((EventBus)inOrder.verify((Object)this.eventBus, (VerificationMode)VERIFY_TIMEOUT)).fire((Object)ChannelEvent.channelClosed((Node)this.node));
        ((ReconnectionPolicy.ReconnectionSchedule)Mockito.verify((Object)this.reconnectionSchedule, (VerificationMode)VERIFY_TIMEOUT)).nextDelay();
        ((EventBus)inOrder.verify((Object)this.eventBus, (VerificationMode)VERIFY_TIMEOUT)).fire((Object)ChannelEvent.reconnectionStarted((Node)this.node));
        factoryHelper.waitForCall((Node)this.node);
        channel3Future.complete(channel3);
        ((EventBus)inOrder.verify((Object)this.eventBus, (VerificationMode)VERIFY_TIMEOUT)).fire((Object)ChannelEvent.channelOpened((Node)this.node));
        ((EventBus)Mockito.verify((Object)this.eventBus, (VerificationMode)VERIFY_TIMEOUT)).fire((Object)ChannelEvent.reconnectionStopped((Node)this.node));
        Awaitility.await().untilAsserted(() -> Assertions.assertThat((Iterable)pool.channels).containsOnly((Object[])new DriverChannel[]{channel1, channel3}));
        factoryHelper.verifyNoMoreCalls();
    }

    @Test
    public void should_let_current_attempt_complete_when_reconnecting_now() throws ExecutionException, InterruptedException {
        Mockito.when((Object)this.reconnectionSchedule.nextDelay()).thenReturn((Object)Duration.ofNanos(1L));
        Mockito.when((Object)this.defaultProfile.getInt((DriverOption)DefaultDriverOption.CONNECTION_POOL_LOCAL_SIZE)).thenReturn((Object)1);
        DriverChannel channel1 = this.newMockDriverChannel(1);
        DriverChannel channel2 = this.newMockDriverChannel(2);
        CompletableFuture<DriverChannel> channel2Future = new CompletableFuture<DriverChannel>();
        MockChannelFactoryHelper factoryHelper = MockChannelFactoryHelper.builder(this.channelFactory).success((Node)this.node, channel1).pending((Node)this.node, channel2Future).build();
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.eventBus});
        CompletionStage poolFuture = ChannelPool.init((Node)this.node, null, (NodeDistance)NodeDistance.LOCAL, (InternalDriverContext)this.context, (String)"test");
        factoryHelper.waitForCalls((Node)this.node, 1);
        Assertions.assertThatStage(poolFuture).isSuccess();
        ChannelPool pool = (ChannelPool)poolFuture.toCompletableFuture().get();
        ((EventBus)inOrder.verify((Object)this.eventBus, VERIFY_TIMEOUT.times(1))).fire((Object)ChannelEvent.channelOpened((Node)this.node));
        ((ChannelPromise)channel1.closeStartedFuture()).setSuccess();
        ((EventBus)inOrder.verify((Object)this.eventBus, (VerificationMode)VERIFY_TIMEOUT)).fire((Object)ChannelEvent.channelClosed((Node)this.node));
        ((EventBus)inOrder.verify((Object)this.eventBus, (VerificationMode)VERIFY_TIMEOUT)).fire((Object)ChannelEvent.reconnectionStarted((Node)this.node));
        ((ReconnectionPolicy.ReconnectionSchedule)Mockito.verify((Object)this.reconnectionSchedule, (VerificationMode)VERIFY_TIMEOUT)).nextDelay();
        factoryHelper.waitForCalls((Node)this.node, 1);
        pool.reconnectNow();
        TimeUnit.MILLISECONDS.sleep(200L);
        factoryHelper.verifyNoMoreCalls();
        ((EventBus)inOrder.verify((Object)this.eventBus, Mockito.never())).fire(ArgumentMatchers.any());
        channel2Future.complete(channel2);
        ((EventBus)inOrder.verify((Object)this.eventBus, (VerificationMode)VERIFY_TIMEOUT)).fire((Object)ChannelEvent.channelOpened((Node)this.node));
        ((EventBus)Mockito.verify((Object)this.eventBus, (VerificationMode)VERIFY_TIMEOUT)).fire((Object)ChannelEvent.reconnectionStopped((Node)this.node));
        Awaitility.await().untilAsserted(() -> Assertions.assertThat((Iterable)pool.channels).containsOnly((Object[])new DriverChannel[]{channel2}));
        factoryHelper.verifyNoMoreCalls();
    }
}

