/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.os;

import com.datastax.oss.driver.internal.core.os.JnrLibc;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class JnrLibcTest {
    @Test
    public void should_be_available() {
        JnrLibc impl = new JnrLibc();
        Assertions.assertThat((boolean)impl.available()).isTrue();
    }

    @Test
    public void should_support_getpid() {
        JnrLibc impl = new JnrLibc();
        Optional val = impl.getpid();
        Assertions.assertThat((Optional)val).isNotEmpty();
        Assertions.assertThat((Integer)((Integer)val.get())).isGreaterThan(1);
    }

    @Test
    public void should_support_gettimeofday() {
        JnrLibc impl = new JnrLibc();
        Optional val = impl.gettimeofday();
        Assertions.assertThat((Optional)val).isNotEmpty();
        Assertions.assertThat((Long)((Long)val.get())).isGreaterThan(0L);
        Instant now = Instant.now();
        Instant rvInstant = Instant.EPOCH.plus((long)((Long)val.get()), ChronoUnit.MICROS);
        Assertions.assertThat((boolean)rvInstant.isAfter(now.minusSeconds(1L))).isTrue();
        Assertions.assertThat((boolean)rvInstant.isBefore(now.plusSeconds(1L))).isTrue();
    }
}

