/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.metrics;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import com.codahale.metrics.MetricRegistry;
import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.config.DriverConfig;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.config.DriverOption;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.api.core.metrics.DefaultNodeMetric;
import com.datastax.oss.driver.api.core.metrics.NodeMetric;
import com.datastax.oss.driver.internal.core.context.InternalDriverContext;
import com.datastax.oss.driver.internal.core.metrics.AbstractMetricUpdater;
import com.datastax.oss.driver.internal.core.metrics.DropwizardNodeMetricUpdater;
import com.datastax.oss.driver.internal.core.util.LoggerTest;
import com.tngtech.java.junit.dataprovider.DataProvider;
import com.tngtech.java.junit.dataprovider.DataProviderRunner;
import com.tngtech.java.junit.dataprovider.UseDataProvider;
import java.time.Duration;
import java.util.Collections;
import java.util.Set;
import java.util.function.Supplier;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=DataProviderRunner.class)
public class DropwizardNodeMetricUpdaterTest {
    @Test
    public void should_log_warning_when_provided_eviction_time_setting_is_too_low() {
        LoggerTest.LoggerSetup logger = LoggerTest.setupTestLogger(AbstractMetricUpdater.class, Level.WARN);
        Node node = (Node)Mockito.mock(Node.class);
        InternalDriverContext context = (InternalDriverContext)Mockito.mock(InternalDriverContext.class);
        DriverExecutionProfile profile = (DriverExecutionProfile)Mockito.mock(DriverExecutionProfile.class);
        DriverConfig config = (DriverConfig)Mockito.mock(DriverConfig.class);
        Set<DefaultNodeMetric> enabledMetrics = Collections.singleton(DefaultNodeMetric.CQL_MESSAGES);
        Duration expireAfter = AbstractMetricUpdater.MIN_EXPIRE_AFTER.minusMinutes(1L);
        Mockito.when((Object)context.getSessionName()).thenReturn((Object)"prefix");
        Mockito.when((Object)context.getConfig()).thenReturn((Object)config);
        Mockito.when((Object)config.getDefaultProfile()).thenReturn((Object)profile);
        Mockito.when((Object)profile.getDuration((DriverOption)DefaultDriverOption.METRICS_NODE_EXPIRE_AFTER)).thenReturn((Object)expireAfter);
        DropwizardNodeMetricUpdater updater = new DropwizardNodeMetricUpdater(node, context, enabledMetrics, new MetricRegistry()){

            protected void initializeGauge(NodeMetric metric, DriverExecutionProfile profile, Supplier<Number> supplier) {
            }

            protected void initializeCounter(NodeMetric metric, DriverExecutionProfile profile) {
            }

            protected void initializeHdrTimer(NodeMetric metric, DriverExecutionProfile profile, DriverOption highestLatency, DriverOption significantDigits, DriverOption interval) {
            }
        };
        Assertions.assertThat((Duration)updater.getExpireAfter()).isEqualTo((Object)AbstractMetricUpdater.MIN_EXPIRE_AFTER);
        ((Appender)Mockito.verify(logger.appender, (VerificationMode)Mockito.timeout((long)500L).times(1))).doAppend((Object)((ILoggingEvent)logger.loggingEventCaptor.capture()));
        Assertions.assertThat((String)((ILoggingEvent)logger.loggingEventCaptor.getValue()).getMessage()).isNotNull();
        Assertions.assertThat((String)((ILoggingEvent)logger.loggingEventCaptor.getValue()).getFormattedMessage()).contains(new CharSequence[]{String.format("[prefix] Value too low for %s: %s. Forcing to %s instead.", DefaultDriverOption.METRICS_NODE_EXPIRE_AFTER.getPath(), expireAfter, AbstractMetricUpdater.MIN_EXPIRE_AFTER)});
    }

    @Test
    @UseDataProvider(value="acceptableEvictionTimes")
    public void should_not_log_warning_when_provided_eviction_time_setting_is_acceptable(Duration expireAfter) {
        LoggerTest.LoggerSetup logger = LoggerTest.setupTestLogger(AbstractMetricUpdater.class, Level.WARN);
        Node node = (Node)Mockito.mock(Node.class);
        InternalDriverContext context = (InternalDriverContext)Mockito.mock(InternalDriverContext.class);
        DriverExecutionProfile profile = (DriverExecutionProfile)Mockito.mock(DriverExecutionProfile.class);
        DriverConfig config = (DriverConfig)Mockito.mock(DriverConfig.class);
        Set<DefaultNodeMetric> enabledMetrics = Collections.singleton(DefaultNodeMetric.CQL_MESSAGES);
        Mockito.when((Object)context.getSessionName()).thenReturn((Object)"prefix");
        Mockito.when((Object)context.getConfig()).thenReturn((Object)config);
        Mockito.when((Object)config.getDefaultProfile()).thenReturn((Object)profile);
        Mockito.when((Object)profile.getDuration((DriverOption)DefaultDriverOption.METRICS_NODE_EXPIRE_AFTER)).thenReturn((Object)expireAfter);
        DropwizardNodeMetricUpdater updater = new DropwizardNodeMetricUpdater(node, context, enabledMetrics, new MetricRegistry()){

            protected void initializeGauge(NodeMetric metric, DriverExecutionProfile profile, Supplier<Number> supplier) {
            }

            protected void initializeCounter(NodeMetric metric, DriverExecutionProfile profile) {
            }

            protected void initializeHdrTimer(NodeMetric metric, DriverExecutionProfile profile, DriverOption highestLatency, DriverOption significantDigits, DriverOption interval) {
            }
        };
        Assertions.assertThat((Duration)updater.getExpireAfter()).isEqualTo((Object)expireAfter);
        ((Appender)Mockito.verify(logger.appender, (VerificationMode)Mockito.timeout((long)500L).times(0))).doAppend((Object)((ILoggingEvent)logger.loggingEventCaptor.capture()));
    }

    @DataProvider
    public static Object[][] acceptableEvictionTimes() {
        return new Object[][]{{AbstractMetricUpdater.MIN_EXPIRE_AFTER}, {AbstractMetricUpdater.MIN_EXPIRE_AFTER.plusMinutes(1L)}};
    }
}

