/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.metadata.schema.queries;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.config.DriverOption;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.internal.core.adminrequest.AdminResult;
import com.datastax.oss.driver.internal.core.adminrequest.AdminRow;
import com.datastax.oss.driver.internal.core.channel.DriverChannel;
import com.datastax.oss.driver.shaded.guava.common.collect.Iterators;
import io.netty.channel.embedded.EmbeddedChannel;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public abstract class SchemaQueriesTest {
    protected static final CqlIdentifier KS_ID = CqlIdentifier.fromInternal((String)"ks");
    protected static final CqlIdentifier KS1_ID = CqlIdentifier.fromInternal((String)"ks1");
    protected static final CqlIdentifier KS2_ID = CqlIdentifier.fromInternal((String)"ks2");
    protected static final CqlIdentifier FOO_ID = CqlIdentifier.fromInternal((String)"foo");
    @Mock
    protected Node node;
    @Mock
    protected DriverExecutionProfile config;
    @Mock
    protected DriverChannel driverChannel;
    protected EmbeddedChannel channel;

    @Before
    public void setup() {
        Mockito.when((Object)this.config.getDuration((DriverOption)DefaultDriverOption.METADATA_SCHEMA_REQUEST_TIMEOUT)).thenReturn((Object)Duration.ZERO);
        Mockito.when((Object)this.config.getInt((DriverOption)DefaultDriverOption.METADATA_SCHEMA_REQUEST_PAGE_SIZE)).thenReturn((Object)5000);
        this.channel = new EmbeddedChannel();
        this.driverChannel = (DriverChannel)Mockito.mock(DriverChannel.class);
        Mockito.when((Object)this.driverChannel.eventLoop()).thenReturn((Object)this.channel.eventLoop());
    }

    protected static AdminRow mockRow(String ... values) {
        AdminRow row = (AdminRow)Mockito.mock(AdminRow.class);
        ((AbstractIntegerAssert)Assertions.assertThat((int)(values.length % 2)).as("Expecting an even number of parameters", new Object[0])).isZero();
        for (int i = 0; i < values.length / 2; ++i) {
            Mockito.when((Object)row.getString(values[i * 2])).thenReturn((Object)values[i * 2 + 1]);
        }
        return row;
    }

    protected static AdminResult mockResult(AdminRow ... rows) {
        return SchemaQueriesTest.mockResult(null, rows);
    }

    protected static AdminResult mockResult(AdminResult next, AdminRow ... rows) {
        AdminResult result = (AdminResult)Mockito.mock(AdminResult.class);
        if (next == null) {
            Mockito.when((Object)result.hasNextPage()).thenReturn((Object)false);
        } else {
            Mockito.when((Object)result.hasNextPage()).thenReturn((Object)true);
            Mockito.when((Object)result.nextPage()).thenReturn(CompletableFuture.completedFuture(next));
        }
        Mockito.when((Object)result.iterator()).thenReturn((Object)Iterators.forArray((Object[])rows));
        return result;
    }

    protected static class Call {
        final String query;
        final CompletableFuture<AdminResult> result;

        Call(String query) {
            this.query = query;
            this.result = new CompletableFuture();
        }
    }
}

