/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.metadata.schema.queries;

import com.datastax.oss.driver.internal.core.metadata.schema.queries.KeyspaceFilter;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class KeyspaceFilterTest {
    private static final ImmutableSet<String> KEYSPACES = ImmutableSet.of((Object)"system", (Object)"inventory_test", (Object)"inventory_prod", (Object)"customers_test", (Object)"customers_prod");

    @Test
    public void should_not_filter_when_no_rules() {
        KeyspaceFilter filter = KeyspaceFilter.newInstance((String)"test", Arrays.asList(new String[0]));
        Assertions.assertThat((String)filter.getWhereClause()).isEmpty();
        Assertions.assertThat(KeyspaceFilterTest.apply(filter, KEYSPACES)).isEqualTo(KEYSPACES);
    }

    @Test
    public void should_filter_on_server_when_only_exact_rules() {
        KeyspaceFilter filter = KeyspaceFilter.newInstance((String)"test", Arrays.asList("inventory_test", "customers_test", "!system"));
        Assertions.assertThat((String)filter.getWhereClause()).isEqualTo(" WHERE keyspace_name IN ('inventory_test','customers_test')");
        Assertions.assertThat(KeyspaceFilterTest.apply(filter, KEYSPACES)).containsOnly((Object[])new String[]{"inventory_test", "customers_test"});
    }

    @Test
    public void should_ignore_exact_exclude_that_collides_with_exact_include() {
        KeyspaceFilter filter = KeyspaceFilter.newInstance((String)"test", Arrays.asList("inventory_test", "!inventory_test"));
        Assertions.assertThat((String)filter.getWhereClause()).isEqualTo(" WHERE keyspace_name IN ('inventory_test')");
        Assertions.assertThat(KeyspaceFilterTest.apply(filter, KEYSPACES)).containsOnly((Object[])new String[]{"inventory_test"});
        filter = KeyspaceFilter.newInstance((String)"test", Arrays.asList("!inventory_test", "inventory_test"));
        Assertions.assertThat((String)filter.getWhereClause()).isEqualTo(" WHERE keyspace_name IN ('inventory_test')");
        Assertions.assertThat(KeyspaceFilterTest.apply(filter, KEYSPACES)).containsOnly((Object[])new String[]{"inventory_test"});
    }

    @Test
    public void should_apply_disjoint_exact_and_regex_rules() {
        KeyspaceFilter filter = KeyspaceFilter.newInstance((String)"test", Arrays.asList("inventory_test", "/^customers.*/"));
        Assertions.assertThat((String)filter.getWhereClause()).isEmpty();
        Assertions.assertThat(KeyspaceFilterTest.apply(filter, KEYSPACES)).containsOnly((Object[])new String[]{"inventory_test", "customers_test", "customers_prod"});
        filter = KeyspaceFilter.newInstance((String)"test", Arrays.asList("!system", "!/^inventory.*/"));
        Assertions.assertThat((String)filter.getWhereClause()).isEmpty();
        Assertions.assertThat(KeyspaceFilterTest.apply(filter, KEYSPACES)).containsOnly((Object[])new String[]{"customers_test", "customers_prod"});
        filter = KeyspaceFilter.newInstance((String)"test", Arrays.asList("!/^customers.*/", "inventory_test"));
        Assertions.assertThat((String)filter.getWhereClause()).isEmpty();
        Assertions.assertThat(KeyspaceFilterTest.apply(filter, KEYSPACES)).containsOnly((Object[])new String[]{"inventory_test", "inventory_prod", "system"});
        filter = KeyspaceFilter.newInstance((String)"test", Arrays.asList("/^customers.*/", "!system"));
        Assertions.assertThat((String)filter.getWhereClause()).isEmpty();
        Assertions.assertThat(KeyspaceFilterTest.apply(filter, KEYSPACES)).containsOnly((Object[])new String[]{"customers_test", "customers_prod"});
    }

    @Test
    public void should_apply_intersecting_exact_and_regex_rules() {
        KeyspaceFilter filter = KeyspaceFilter.newInstance((String)"test", Arrays.asList("/^customers.*/", "!customers_test"));
        Assertions.assertThat((String)filter.getWhereClause()).isEmpty();
        Assertions.assertThat(KeyspaceFilterTest.apply(filter, KEYSPACES)).containsOnly((Object[])new String[]{"customers_prod"});
        filter = KeyspaceFilter.newInstance((String)"test", Arrays.asList("!/^customers.*/", "customers_test"));
        Assertions.assertThat((String)filter.getWhereClause()).isEmpty();
        Assertions.assertThat(KeyspaceFilterTest.apply(filter, KEYSPACES)).containsOnly((Object[])new String[]{"customers_test", "inventory_test", "inventory_prod", "system"});
    }

    @Test
    public void should_apply_intersecting_regex_rules() {
        KeyspaceFilter filter = KeyspaceFilter.newInstance((String)"test", Arrays.asList("/^customers.*/", "!/.*test$/"));
        Assertions.assertThat((String)filter.getWhereClause()).isEmpty();
        Assertions.assertThat(KeyspaceFilterTest.apply(filter, KEYSPACES)).containsOnly((Object[])new String[]{"customers_prod"});
        filter = KeyspaceFilter.newInstance((String)"test", Arrays.asList("inventory_prod", "/^customers.*/", "!/.*test$/"));
        Assertions.assertThat((String)filter.getWhereClause()).isEmpty();
        Assertions.assertThat(KeyspaceFilterTest.apply(filter, KEYSPACES)).containsOnly((Object[])new String[]{"inventory_prod", "customers_prod"});
    }

    @Test
    public void should_skip_malformed_rule() {
        KeyspaceFilter filter = KeyspaceFilter.newInstance((String)"test", Arrays.asList("inventory_test", "customers_test", "//"));
        Assertions.assertThat((String)filter.getWhereClause()).isEqualTo(" WHERE keyspace_name IN ('inventory_test','customers_test')");
        Assertions.assertThat(KeyspaceFilterTest.apply(filter, KEYSPACES)).containsOnly((Object[])new String[]{"inventory_test", "customers_test"});
    }

    @Test
    public void should_skip_invalid_regex() {
        KeyspaceFilter filter = KeyspaceFilter.newInstance((String)"test", Arrays.asList("inventory_test", "customers_test", "/*/"));
        Assertions.assertThat((String)filter.getWhereClause()).isEqualTo(" WHERE keyspace_name IN ('inventory_test','customers_test')");
        Assertions.assertThat(KeyspaceFilterTest.apply(filter, KEYSPACES)).containsOnly((Object[])new String[]{"inventory_test", "customers_test"});
    }

    private static Set<String> apply(KeyspaceFilter filter, Set<String> keyspaces) {
        return keyspaces.stream().filter(arg_0 -> ((KeyspaceFilter)filter).includes(arg_0)).collect(Collectors.toSet());
    }
}

