/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.metadata.schema.queries;

import com.datastax.oss.driver.Assertions;
import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.Version;
import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.config.DriverOption;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.internal.core.adminrequest.AdminResult;
import com.datastax.oss.driver.internal.core.adminrequest.AdminRow;
import com.datastax.oss.driver.internal.core.channel.DriverChannel;
import com.datastax.oss.driver.internal.core.metadata.schema.queries.Cassandra3SchemaQueries;
import com.datastax.oss.driver.internal.core.metadata.schema.queries.SchemaQueriesTest;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableList;
import com.datastax.oss.driver.shaded.guava.common.collect.Multimap;
import java.util.Collections;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.LinkedBlockingDeque;
import org.assertj.core.api.AbstractThrowableAssert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class Cassandra3SchemaQueriesTest
extends SchemaQueriesTest {
    @Override
    @Before
    public void setup() {
        super.setup();
        Mockito.when((Object)this.config.getStringList((DriverOption)DefaultDriverOption.METADATA_SCHEMA_REFRESHED_KEYSPACES, Collections.emptyList())).thenReturn(Collections.emptyList());
        Mockito.when((Object)this.node.getCassandraVersion()).thenReturn((Object)Version.V3_0_0);
    }

    @Test
    public void should_query_without_keyspace_filter() {
        this.should_query_with_where_clause("");
    }

    @Test
    public void should_query_with_keyspace_filter() {
        Mockito.when((Object)this.config.getStringList((DriverOption)DefaultDriverOption.METADATA_SCHEMA_REFRESHED_KEYSPACES, Collections.emptyList())).thenReturn((Object)ImmutableList.of((Object)"ks1", (Object)"ks2"));
        this.should_query_with_where_clause(" WHERE keyspace_name IN ('ks1','ks2')");
    }

    private void should_query_with_where_clause(String whereClause) {
        SchemaQueriesWithMockedChannel queries = new SchemaQueriesWithMockedChannel(this.driverChannel, this.node, this.config, "test");
        CompletionStage result = queries.execute();
        SchemaQueriesTest.Call call = queries.calls.poll();
        Assertions.assertThat((String)call.query).isEqualTo("SELECT * FROM system_schema.keyspaces" + whereClause);
        call.result.complete(Cassandra3SchemaQueriesTest.mockResult(Cassandra3SchemaQueriesTest.mockRow("keyspace_name", "ks1"), Cassandra3SchemaQueriesTest.mockRow("keyspace_name", "ks2")));
        call = queries.calls.poll();
        Assertions.assertThat((String)call.query).isEqualTo("SELECT * FROM system_schema.types" + whereClause);
        call.result.complete(Cassandra3SchemaQueriesTest.mockResult(Cassandra3SchemaQueriesTest.mockRow("keyspace_name", "ks1", "type_name", "type")));
        call = queries.calls.poll();
        Assertions.assertThat((String)call.query).isEqualTo("SELECT * FROM system_schema.tables" + whereClause);
        call.result.complete(Cassandra3SchemaQueriesTest.mockResult(Cassandra3SchemaQueriesTest.mockRow("keyspace_name", "ks1", "table_name", "foo")));
        call = queries.calls.poll();
        Assertions.assertThat((String)call.query).isEqualTo("SELECT * FROM system_schema.columns" + whereClause);
        call.result.complete(Cassandra3SchemaQueriesTest.mockResult(Cassandra3SchemaQueriesTest.mockRow("keyspace_name", "ks1", "table_name", "foo", "column_name", "k")));
        call = queries.calls.poll();
        Assertions.assertThat((String)call.query).isEqualTo("SELECT * FROM system_schema.indexes" + whereClause);
        call.result.complete(Cassandra3SchemaQueriesTest.mockResult(Cassandra3SchemaQueriesTest.mockRow("keyspace_name", "ks1", "table_name", "foo", "index_name", "index")));
        call = queries.calls.poll();
        Assertions.assertThat((String)call.query).isEqualTo("SELECT * FROM system_schema.views" + whereClause);
        call.result.complete(Cassandra3SchemaQueriesTest.mockResult(Cassandra3SchemaQueriesTest.mockRow("keyspace_name", "ks2", "view_name", "foo")));
        call = queries.calls.poll();
        Assertions.assertThat((String)call.query).isEqualTo("SELECT * FROM system_schema.functions" + whereClause);
        call.result.complete(Cassandra3SchemaQueriesTest.mockResult(Cassandra3SchemaQueriesTest.mockRow("keyspace_name", "ks2", "function_name", "add")));
        call = queries.calls.poll();
        Assertions.assertThat((String)call.query).isEqualTo("SELECT * FROM system_schema.aggregates" + whereClause);
        call.result.complete(Cassandra3SchemaQueriesTest.mockResult(Cassandra3SchemaQueriesTest.mockRow("keyspace_name", "ks2", "aggregate_name", "add")));
        this.channel.runPendingTasks();
        Assertions.assertThatStage(result).isSuccess(rows -> {
            Assertions.assertThat((Object)rows.getNode()).isEqualTo((Object)this.node);
            Assertions.assertThat((List)rows.keyspaces()).hasSize(2);
            Assertions.assertThat((String)((AdminRow)rows.keyspaces().get(0)).getString("keyspace_name")).isEqualTo("ks1");
            Assertions.assertThat((String)((AdminRow)rows.keyspaces().get(1)).getString("keyspace_name")).isEqualTo("ks2");
            Assertions.assertThat((Iterable)rows.types().keySet()).containsOnly((Object[])new CqlIdentifier[]{KS1_ID});
            Assertions.assertThat((Iterable)rows.types().get((Object)KS1_ID)).hasSize(1);
            Assertions.assertThat((String)((AdminRow)rows.types().get((Object)KS1_ID).iterator().next()).getString("type_name")).isEqualTo("type");
            Assertions.assertThat((Iterable)rows.tables().keySet()).containsOnly((Object[])new CqlIdentifier[]{KS1_ID});
            Assertions.assertThat((Iterable)rows.tables().get((Object)KS1_ID)).hasSize(1);
            Assertions.assertThat((String)((AdminRow)rows.tables().get((Object)KS1_ID).iterator().next()).getString("table_name")).isEqualTo("foo");
            Assertions.assertThat(rows.columns().keySet()).containsOnly((Object[])new CqlIdentifier[]{KS1_ID});
            Assertions.assertThat((Iterable)((Multimap)rows.columns().get(KS1_ID)).keySet()).containsOnly((Object[])new CqlIdentifier[]{FOO_ID});
            Assertions.assertThat((String)((AdminRow)((Multimap)rows.columns().get(KS1_ID)).get((Object)FOO_ID).iterator().next()).getString("column_name")).isEqualTo("k");
            Assertions.assertThat(rows.indexes().keySet()).containsOnly((Object[])new CqlIdentifier[]{KS1_ID});
            Assertions.assertThat((Iterable)((Multimap)rows.indexes().get(KS1_ID)).keySet()).containsOnly((Object[])new CqlIdentifier[]{FOO_ID});
            Assertions.assertThat((String)((AdminRow)((Multimap)rows.indexes().get(KS1_ID)).get((Object)FOO_ID).iterator().next()).getString("index_name")).isEqualTo("index");
            Assertions.assertThat((Iterable)rows.views().keySet()).containsOnly((Object[])new CqlIdentifier[]{KS2_ID});
            Assertions.assertThat((Iterable)rows.views().get((Object)KS2_ID)).hasSize(1);
            Assertions.assertThat((String)((AdminRow)rows.views().get((Object)KS2_ID).iterator().next()).getString("view_name")).isEqualTo("foo");
            Assertions.assertThat((Iterable)rows.functions().keySet()).containsOnly((Object[])new CqlIdentifier[]{KS2_ID});
            Assertions.assertThat((Iterable)rows.functions().get((Object)KS2_ID)).hasSize(1);
            Assertions.assertThat((String)((AdminRow)rows.functions().get((Object)KS2_ID).iterator().next()).getString("function_name")).isEqualTo("add");
            Assertions.assertThat((Iterable)rows.aggregates().keySet()).containsOnly((Object[])new CqlIdentifier[]{KS2_ID});
            Assertions.assertThat((Iterable)rows.aggregates().get((Object)KS2_ID)).hasSize(1);
            Assertions.assertThat((String)((AdminRow)rows.aggregates().get((Object)KS2_ID).iterator().next()).getString("aggregate_name")).isEqualTo("add");
        });
    }

    @Test
    public void should_query_with_paging() {
        SchemaQueriesWithMockedChannel queries = new SchemaQueriesWithMockedChannel(this.driverChannel, this.node, this.config, "test");
        CompletionStage result = queries.execute();
        SchemaQueriesTest.Call call = queries.calls.poll();
        Assertions.assertThat((String)call.query).isEqualTo("SELECT * FROM system_schema.keyspaces");
        call.result.complete(Cassandra3SchemaQueriesTest.mockResult(Cassandra3SchemaQueriesTest.mockRow("keyspace_name", "ks1")));
        call = queries.calls.poll();
        Assertions.assertThat((String)call.query).isEqualTo("SELECT * FROM system_schema.types");
        call.result.complete(Cassandra3SchemaQueriesTest.mockResult(new AdminRow[0]));
        call = queries.calls.poll();
        Assertions.assertThat((String)call.query).isEqualTo("SELECT * FROM system_schema.tables");
        call.result.complete(Cassandra3SchemaQueriesTest.mockResult(Cassandra3SchemaQueriesTest.mockRow("keyspace_name", "ks1", "table_name", "foo")));
        call = queries.calls.poll();
        Assertions.assertThat((String)call.query).isEqualTo("SELECT * FROM system_schema.columns");
        AdminResult page2 = Cassandra3SchemaQueriesTest.mockResult(Cassandra3SchemaQueriesTest.mockRow("keyspace_name", "ks1", "table_name", "foo", "column_name", "v"));
        AdminResult page1 = Cassandra3SchemaQueriesTest.mockResult(page2, Cassandra3SchemaQueriesTest.mockRow("keyspace_name", "ks1", "table_name", "foo", "column_name", "k"));
        call.result.complete(page1);
        call = queries.calls.poll();
        Assertions.assertThat((String)call.query).isEqualTo("SELECT * FROM system_schema.indexes");
        call.result.complete(Cassandra3SchemaQueriesTest.mockResult(new AdminRow[0]));
        call = queries.calls.poll();
        Assertions.assertThat((String)call.query).isEqualTo("SELECT * FROM system_schema.views");
        call.result.complete(Cassandra3SchemaQueriesTest.mockResult(new AdminRow[0]));
        call = queries.calls.poll();
        Assertions.assertThat((String)call.query).isEqualTo("SELECT * FROM system_schema.functions");
        call.result.complete(Cassandra3SchemaQueriesTest.mockResult(new AdminRow[0]));
        call = queries.calls.poll();
        Assertions.assertThat((String)call.query).isEqualTo("SELECT * FROM system_schema.aggregates");
        call.result.complete(Cassandra3SchemaQueriesTest.mockResult(new AdminRow[0]));
        this.channel.runPendingTasks();
        Assertions.assertThatStage(result).isSuccess(rows -> {
            Assertions.assertThat(rows.columns().keySet()).containsOnly((Object[])new CqlIdentifier[]{KS1_ID});
            Assertions.assertThat((Iterable)((Multimap)rows.columns().get(KS1_ID)).keySet()).containsOnly((Object[])new CqlIdentifier[]{FOO_ID});
            Assertions.assertThat((Iterable)((Multimap)rows.columns().get(KS1_ID)).get((Object)FOO_ID)).extracting(r -> r.getString("column_name")).containsExactly((Object[])new String[]{"k", "v"});
        });
    }

    @Test
    public void should_ignore_malformed_rows() {
        SchemaQueriesWithMockedChannel queries = new SchemaQueriesWithMockedChannel(this.driverChannel, this.node, this.config, "test");
        CompletionStage result = queries.execute();
        SchemaQueriesTest.Call call = queries.calls.poll();
        Assertions.assertThat((String)call.query).isEqualTo("SELECT * FROM system_schema.keyspaces");
        call.result.complete(Cassandra3SchemaQueriesTest.mockResult(Cassandra3SchemaQueriesTest.mockRow("keyspace_name", "ks1")));
        call = queries.calls.poll();
        Assertions.assertThat((String)call.query).isEqualTo("SELECT * FROM system_schema.types");
        call.result.complete(Cassandra3SchemaQueriesTest.mockResult(new AdminRow[0]));
        call = queries.calls.poll();
        Assertions.assertThat((String)call.query).isEqualTo("SELECT * FROM system_schema.tables");
        call.result.complete(Cassandra3SchemaQueriesTest.mockResult(Cassandra3SchemaQueriesTest.mockRow("keyspace_name", "ks", "table_name", "foo"), Cassandra3SchemaQueriesTest.mockRow("table_name", "foo")));
        call = queries.calls.poll();
        call.result.complete(Cassandra3SchemaQueriesTest.mockResult(Cassandra3SchemaQueriesTest.mockRow("keyspace_name", "ks", "table_name", "foo", "column_name", "k"), Cassandra3SchemaQueriesTest.mockRow("table_name", "foo", "column_name", "k"), Cassandra3SchemaQueriesTest.mockRow("keyspace_name", "ks", "column_name", "k")));
        AdminResult page2 = Cassandra3SchemaQueriesTest.mockResult(Cassandra3SchemaQueriesTest.mockRow("keyspace_name", "ks1", "table_name", "foo", "column_name", "v"));
        AdminResult page1 = Cassandra3SchemaQueriesTest.mockResult(page2, Cassandra3SchemaQueriesTest.mockRow("keyspace_name", "ks1", "table_name", "foo", "column_name", "k"));
        call.result.complete(page1);
        call = queries.calls.poll();
        Assertions.assertThat((String)call.query).isEqualTo("SELECT * FROM system_schema.indexes");
        call.result.complete(Cassandra3SchemaQueriesTest.mockResult(new AdminRow[0]));
        call = queries.calls.poll();
        Assertions.assertThat((String)call.query).isEqualTo("SELECT * FROM system_schema.views");
        call.result.complete(Cassandra3SchemaQueriesTest.mockResult(new AdminRow[0]));
        call = queries.calls.poll();
        Assertions.assertThat((String)call.query).isEqualTo("SELECT * FROM system_schema.functions");
        call.result.complete(Cassandra3SchemaQueriesTest.mockResult(new AdminRow[0]));
        call = queries.calls.poll();
        Assertions.assertThat((String)call.query).isEqualTo("SELECT * FROM system_schema.aggregates");
        call.result.complete(Cassandra3SchemaQueriesTest.mockResult(new AdminRow[0]));
        this.channel.runPendingTasks();
        Assertions.assertThatStage(result).isSuccess(rows -> {
            Assertions.assertThat((Iterable)rows.tables().keySet()).containsOnly((Object[])new CqlIdentifier[]{KS_ID});
            Assertions.assertThat((Iterable)rows.tables().get((Object)KS_ID)).hasSize(1);
            Assertions.assertThat((String)((AdminRow)rows.tables().get((Object)KS_ID).iterator().next()).getString("table_name")).isEqualTo("foo");
            Assertions.assertThat(rows.columns().keySet()).containsOnly((Object[])new CqlIdentifier[]{KS_ID});
            Assertions.assertThat((Iterable)((Multimap)rows.columns().get(KS_ID)).keySet()).containsOnly((Object[])new CqlIdentifier[]{FOO_ID});
            Assertions.assertThat((String)((AdminRow)((Multimap)rows.columns().get(KS_ID)).get((Object)FOO_ID).iterator().next()).getString("column_name")).isEqualTo("k");
        });
    }

    @Test
    public void should_abort_if_query_fails() {
        SchemaQueriesWithMockedChannel queries = new SchemaQueriesWithMockedChannel(this.driverChannel, this.node, this.config, "test");
        CompletionStage result = queries.execute();
        Exception mockQueryError = new Exception("mock query error");
        SchemaQueriesTest.Call call = queries.calls.poll();
        Assertions.assertThat((String)call.query).isEqualTo("SELECT * FROM system_schema.keyspaces");
        call.result.completeExceptionally(mockQueryError);
        this.channel.runPendingTasks();
        Assertions.assertThatStage(result).isFailed(throwable -> {
            AbstractThrowableAssert cfr_ignored_0 = (AbstractThrowableAssert)Assertions.assertThat((Throwable)throwable).isEqualTo((Object)mockQueryError);
        });
    }

    static class SchemaQueriesWithMockedChannel
    extends Cassandra3SchemaQueries {
        final Queue<SchemaQueriesTest.Call> calls = new LinkedBlockingDeque<SchemaQueriesTest.Call>();

        SchemaQueriesWithMockedChannel(DriverChannel channel, Node node, DriverExecutionProfile config, String logPrefix) {
            super(channel, node, config, logPrefix);
        }

        protected CompletionStage<AdminResult> query(String query) {
            SchemaQueriesTest.Call call = new SchemaQueriesTest.Call(query);
            this.calls.add(call);
            return call.result;
        }
    }
}

