/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.metadata.schema.parsing;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.Version;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.internal.core.adminrequest.AdminRow;
import com.datastax.oss.driver.internal.core.context.InternalDriverContext;
import com.datastax.oss.driver.internal.core.metadata.DefaultMetadata;
import com.datastax.oss.driver.internal.core.metadata.schema.parsing.RelationParser;
import com.datastax.oss.driver.internal.core.metadata.schema.queries.KeyspaceFilter;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableMap;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableSet;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.Silent.class)
public abstract class SchemaParserTestBase {
    protected static final Node NODE_2_2 = SchemaParserTestBase.mockNode(Version.V2_2_0);
    protected static final Node NODE_3_0 = SchemaParserTestBase.mockNode(Version.V3_0_0);
    protected static final CqlIdentifier KEYSPACE_ID = CqlIdentifier.fromInternal((String)"ks");
    @Mock
    protected DefaultMetadata currentMetadata;
    @Mock
    protected InternalDriverContext context;
    @Mock
    protected KeyspaceFilter keyspaceFilter;

    @Before
    public void setup() {
        Mockito.when((Object)this.keyspaceFilter.includes(ArgumentMatchers.anyString())).thenReturn((Object)true);
    }

    protected static AdminRow mockFunctionRow(String keyspace, String name, List<String> argumentNames, List<String> argumentTypes, String body, boolean calledOnNullInput, String language, String returnType) {
        AdminRow row = (AdminRow)Mockito.mock(AdminRow.class);
        Mockito.when((Object)row.contains("keyspace_name")).thenReturn((Object)true);
        Mockito.when((Object)row.contains("function_name")).thenReturn((Object)true);
        Mockito.when((Object)row.contains("argument_names")).thenReturn((Object)true);
        Mockito.when((Object)row.contains("argument_types")).thenReturn((Object)true);
        Mockito.when((Object)row.contains("body")).thenReturn((Object)true);
        Mockito.when((Object)row.contains("called_on_null_input")).thenReturn((Object)true);
        Mockito.when((Object)row.contains("language")).thenReturn((Object)true);
        Mockito.when((Object)row.contains("return_type")).thenReturn((Object)true);
        Mockito.when((Object)row.getString("keyspace_name")).thenReturn((Object)keyspace);
        Mockito.when((Object)row.getString("function_name")).thenReturn((Object)name);
        Mockito.when((Object)row.getListOfString("argument_names")).thenReturn(argumentNames);
        Mockito.when((Object)row.getListOfString("argument_types")).thenReturn(argumentTypes);
        Mockito.when((Object)row.getString("body")).thenReturn((Object)body);
        Mockito.when((Object)row.getBoolean("called_on_null_input")).thenReturn((Object)calledOnNullInput);
        Mockito.when((Object)row.getString("language")).thenReturn((Object)language);
        Mockito.when((Object)row.getString("return_type")).thenReturn((Object)returnType);
        return row;
    }

    protected static AdminRow mockAggregateRow(String keyspace, String name, List<String> argumentTypes, String stateFunc, String stateType, String finalFunc, String returnType, Object initCond) {
        AdminRow row = (AdminRow)Mockito.mock(AdminRow.class);
        Mockito.when((Object)row.contains("keyspace_name")).thenReturn((Object)true);
        Mockito.when((Object)row.contains("aggregate_name")).thenReturn((Object)true);
        Mockito.when((Object)row.contains("argument_types")).thenReturn((Object)true);
        Mockito.when((Object)row.contains("state_func")).thenReturn((Object)true);
        Mockito.when((Object)row.contains("state_type")).thenReturn((Object)true);
        Mockito.when((Object)row.contains("final_func")).thenReturn((Object)true);
        Mockito.when((Object)row.contains("return_type")).thenReturn((Object)true);
        Mockito.when((Object)row.contains("initcond")).thenReturn((Object)true);
        Mockito.when((Object)row.getString("keyspace_name")).thenReturn((Object)keyspace);
        Mockito.when((Object)row.getString("aggregate_name")).thenReturn((Object)name);
        Mockito.when((Object)row.getListOfString("argument_types")).thenReturn(argumentTypes);
        Mockito.when((Object)row.getString("state_func")).thenReturn((Object)stateFunc);
        Mockito.when((Object)row.getString("state_type")).thenReturn((Object)stateType);
        Mockito.when((Object)row.getString("final_func")).thenReturn((Object)finalFunc);
        Mockito.when((Object)row.getString("return_type")).thenReturn((Object)returnType);
        if (initCond instanceof ByteBuffer) {
            Mockito.when((Object)row.isString("initcond")).thenReturn((Object)false);
            Mockito.when((Object)row.getByteBuffer("initcond")).thenReturn((Object)((ByteBuffer)initCond));
        } else if (initCond instanceof String) {
            Mockito.when((Object)row.isString("initcond")).thenReturn((Object)true);
            Mockito.when((Object)row.getString("initcond")).thenReturn((Object)((String)initCond));
        } else {
            Assertions.fail((String)("Unsupported initcond type" + initCond.getClass()));
        }
        return row;
    }

    protected static AdminRow mockTypeRow(String keyspace, String name, List<String> fieldNames, List<String> fieldTypes) {
        AdminRow row = (AdminRow)Mockito.mock(AdminRow.class);
        Mockito.when((Object)row.getString("keyspace_name")).thenReturn((Object)keyspace);
        Mockito.when((Object)row.getString("type_name")).thenReturn((Object)name);
        Mockito.when((Object)row.getListOfString("field_names")).thenReturn(fieldNames);
        Mockito.when((Object)row.getListOfString("field_types")).thenReturn(fieldTypes);
        return row;
    }

    protected static AdminRow mockLegacyTableRow(String keyspace, String name, String comparator) {
        AdminRow row = (AdminRow)Mockito.mock(AdminRow.class);
        Mockito.when((Object)row.contains("table_name")).thenReturn((Object)false);
        Mockito.when((Object)row.getString("keyspace_name")).thenReturn((Object)keyspace);
        Mockito.when((Object)row.getString("columnfamily_name")).thenReturn((Object)name);
        Mockito.when((Object)row.getBoolean("is_dense")).thenReturn((Object)false);
        Mockito.when((Object)row.getString("comparator")).thenReturn((Object)comparator);
        Mockito.when((Object)row.isString("caching")).thenReturn((Object)true);
        Mockito.when((Object)row.getString("caching")).thenReturn((Object)"{\"keys\":\"ALL\", \"rows_per_partition\":\"NONE\"}");
        Mockito.when((Object)row.getString("compaction_strategy_class")).thenReturn((Object)"org.apache.cassandra.db.compaction.SizeTieredCompactionStrategy");
        Mockito.when((Object)row.getString("compaction_strategy_options")).thenReturn((Object)"{\"mock_option\":\"1\"}");
        return row;
    }

    protected static AdminRow mockLegacyColumnRow(String keyspaceName, String tableName, String name, String kind, String dataType, Integer position) {
        return SchemaParserTestBase.mockLegacyColumnRow(keyspaceName, tableName, name, kind, dataType, position, null, null, null);
    }

    protected static AdminRow mockLegacyColumnRow(String keyspaceName, String tableName, String name, String kind, String dataType, int position, String indexName, String indexType, String indexOptions) {
        AdminRow row = (AdminRow)Mockito.mock(AdminRow.class);
        Mockito.when((Object)row.contains("validator")).thenReturn((Object)true);
        Mockito.when((Object)row.getString("keyspace_name")).thenReturn((Object)keyspaceName);
        Mockito.when((Object)row.getString("columnfamily_name")).thenReturn((Object)tableName);
        Mockito.when((Object)row.getString("column_name")).thenReturn((Object)name);
        Mockito.when((Object)row.getString("type")).thenReturn((Object)kind);
        Mockito.when((Object)row.getString("validator")).thenReturn((Object)dataType);
        Mockito.when((Object)row.getInteger("component_index")).thenReturn((Object)position);
        Mockito.when((Object)row.getString("index_name")).thenReturn((Object)indexName);
        Mockito.when((Object)row.getString("index_type")).thenReturn((Object)indexType);
        Mockito.when((Object)row.getString("index_options")).thenReturn((Object)indexOptions);
        return row;
    }

    protected static AdminRow mockModernTableRow(String keyspace, String name) {
        AdminRow row = (AdminRow)Mockito.mock(AdminRow.class);
        Mockito.when((Object)row.contains("flags")).thenReturn((Object)true);
        Mockito.when((Object)row.contains("table_name")).thenReturn((Object)true);
        Mockito.when((Object)row.getString("keyspace_name")).thenReturn((Object)keyspace);
        Mockito.when((Object)row.getString("table_name")).thenReturn((Object)name);
        Mockito.when((Object)row.getSetOfString("flags")).thenReturn((Object)ImmutableSet.of((Object)"compound"));
        Mockito.when((Object)row.isString("caching")).thenReturn((Object)false);
        Mockito.when((Object)((Map)row.get("caching", RelationParser.MAP_OF_TEXT_TO_TEXT))).thenReturn((Object)ImmutableMap.of((Object)"keys", (Object)"ALL", (Object)"rows_per_partition", (Object)"NONE"));
        Mockito.when((Object)((Map)row.get("compaction", RelationParser.MAP_OF_TEXT_TO_TEXT))).thenReturn((Object)ImmutableMap.of((Object)"class", (Object)"org.apache.cassandra.db.compaction.SizeTieredCompactionStrategy", (Object)"mock_option", (Object)"1"));
        return row;
    }

    protected static AdminRow mockModernColumnRow(String keyspaceName, String tableName, String name, String kind, String dataType, String clusteringOrder, Integer position) {
        AdminRow row = (AdminRow)Mockito.mock(AdminRow.class);
        Mockito.when((Object)row.contains("kind")).thenReturn((Object)true);
        Mockito.when((Object)row.contains("position")).thenReturn((Object)true);
        Mockito.when((Object)row.contains("clustering_order")).thenReturn((Object)true);
        Mockito.when((Object)row.getString("keyspace_name")).thenReturn((Object)keyspaceName);
        Mockito.when((Object)row.getString("table_name")).thenReturn((Object)tableName);
        Mockito.when((Object)row.getString("column_name")).thenReturn((Object)name);
        Mockito.when((Object)row.getString("kind")).thenReturn((Object)kind);
        Mockito.when((Object)row.getString("type")).thenReturn((Object)dataType);
        Mockito.when((Object)row.getInteger("position")).thenReturn((Object)position);
        Mockito.when((Object)row.getString("clustering_order")).thenReturn((Object)clusteringOrder);
        return row;
    }

    protected static AdminRow mockIndexRow(String keyspaceName, String tableName, String name, String kind, ImmutableMap<String, String> options) {
        AdminRow row = (AdminRow)Mockito.mock(AdminRow.class);
        Mockito.when((Object)row.getString("keyspace_name")).thenReturn((Object)keyspaceName);
        Mockito.when((Object)row.getString("table_name")).thenReturn((Object)tableName);
        Mockito.when((Object)row.getString("index_name")).thenReturn((Object)name);
        Mockito.when((Object)row.getString("kind")).thenReturn((Object)kind);
        Mockito.when((Object)row.getMapOfStringToString("options")).thenReturn(options);
        return row;
    }

    protected static AdminRow mockViewRow(String keyspaceName, String viewName, String baseTableName, boolean includeAllColumns, String whereClause) {
        AdminRow row = (AdminRow)Mockito.mock(AdminRow.class);
        Mockito.when((Object)row.getString("keyspace_name")).thenReturn((Object)keyspaceName);
        Mockito.when((Object)row.getString("view_name")).thenReturn((Object)viewName);
        Mockito.when((Object)row.getString("base_table_name")).thenReturn((Object)baseTableName);
        Mockito.when((Object)row.getBoolean("include_all_columns")).thenReturn((Object)includeAllColumns);
        Mockito.when((Object)row.getString("where_clause")).thenReturn((Object)whereClause);
        return row;
    }

    protected static AdminRow mockModernKeyspaceRow(String keyspaceName) {
        AdminRow row = (AdminRow)Mockito.mock(AdminRow.class);
        Mockito.when((Object)row.getString("keyspace_name")).thenReturn((Object)keyspaceName);
        Mockito.when((Object)row.getBoolean("durable_writes")).thenReturn((Object)true);
        Mockito.when((Object)row.contains("strategy_class")).thenReturn((Object)false);
        Mockito.when((Object)row.getMapOfStringToString("replication")).thenReturn((Object)ImmutableMap.of((Object)"class", (Object)"org.apache.cassandra.locator.SimpleStrategy", (Object)"replication_factor", (Object)"1"));
        return row;
    }

    protected static AdminRow mockLegacyKeyspaceRow(String keyspaceName) {
        AdminRow row = (AdminRow)Mockito.mock(AdminRow.class);
        Mockito.when((Object)row.getString("keyspace_name")).thenReturn((Object)keyspaceName);
        Mockito.when((Object)row.getBoolean("durable_writes")).thenReturn((Object)true);
        Mockito.when((Object)row.contains("strategy_class")).thenReturn((Object)true);
        Mockito.when((Object)row.getString("strategy_class")).thenReturn((Object)"org.apache.cassandra.locator.SimpleStrategy");
        Mockito.when((Object)row.getString("strategy_options")).thenReturn((Object)"{\"replication_factor\":\"1\"}");
        return row;
    }

    private static Node mockNode(Version version) {
        Node node = (Node)Mockito.mock(Node.class);
        Mockito.when((Object)node.getExtras()).thenReturn(Collections.emptyMap());
        Mockito.when((Object)node.getCassandraVersion()).thenReturn((Object)version);
        return node;
    }
}

