/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.metadata.schema.parsing;

import com.datastax.oss.driver.Assertions;
import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.metadata.schema.FunctionSignature;
import com.datastax.oss.driver.api.core.metadata.schema.KeyspaceMetadata;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.DataTypes;
import com.datastax.oss.driver.api.core.type.codec.registry.CodecRegistry;
import com.datastax.oss.driver.internal.core.metadata.MetadataRefresh;
import com.datastax.oss.driver.internal.core.metadata.schema.parsing.AggregateParserTest;
import com.datastax.oss.driver.internal.core.metadata.schema.parsing.CassandraSchemaParser;
import com.datastax.oss.driver.internal.core.metadata.schema.parsing.FunctionParserTest;
import com.datastax.oss.driver.internal.core.metadata.schema.parsing.SchemaParserTestBase;
import com.datastax.oss.driver.internal.core.metadata.schema.parsing.TableParserTest;
import com.datastax.oss.driver.internal.core.metadata.schema.parsing.ViewParserTest;
import com.datastax.oss.driver.internal.core.metadata.schema.queries.CassandraSchemaRows;
import com.datastax.oss.driver.internal.core.metadata.schema.queries.SchemaRows;
import com.datastax.oss.driver.internal.core.metadata.schema.refresh.SchemaRefresh;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.assertj.core.api.MapAssert;
import org.junit.Test;
import org.mockito.Mockito;

public class SchemaParserTest
extends SchemaParserTestBase {
    @Test
    public void should_parse_modern_keyspace_row() {
        SchemaRefresh refresh = (SchemaRefresh)this.parse(rows -> rows.withKeyspaces((Iterable)ImmutableList.of((Object)SchemaParserTest.mockModernKeyspaceRow("ks"))));
        Assertions.assertThat((Map)refresh.newKeyspaces).hasSize(1);
        KeyspaceMetadata keyspace = (KeyspaceMetadata)refresh.newKeyspaces.values().iterator().next();
        this.checkKeyspace(keyspace);
    }

    @Test
    public void should_parse_legacy_keyspace_row() {
        SchemaRefresh refresh = (SchemaRefresh)this.parse(rows -> rows.withKeyspaces((Iterable)ImmutableList.of((Object)SchemaParserTest.mockLegacyKeyspaceRow("ks"))));
        Assertions.assertThat((Map)refresh.newKeyspaces).hasSize(1);
        KeyspaceMetadata keyspace = (KeyspaceMetadata)refresh.newKeyspaces.values().iterator().next();
        this.checkKeyspace(keyspace);
    }

    @Test
    public void should_parse_keyspace_with_all_children() {
        Mockito.when((Object)this.context.getCodecRegistry()).thenReturn((Object)CodecRegistry.DEFAULT);
        SchemaRefresh refresh = (SchemaRefresh)this.parse(rows -> rows.withKeyspaces((Iterable)ImmutableList.of((Object)SchemaParserTest.mockModernKeyspaceRow("ks"))).withTypes((Iterable)ImmutableList.of((Object)SchemaParserTest.mockTypeRow("ks", "t", (List<String>)ImmutableList.of((Object)"i"), (List<String>)ImmutableList.of((Object)"int")))).withTables((Iterable)ImmutableList.of((Object)TableParserTest.TABLE_ROW_3_0)).withColumns(TableParserTest.COLUMN_ROWS_3_0).withIndexes(TableParserTest.INDEX_ROWS_3_0).withViews((Iterable)ImmutableList.of((Object)ViewParserTest.VIEW_ROW_3_0)).withColumns(ViewParserTest.COLUMN_ROWS_3_0).withFunctions((Iterable)ImmutableList.of((Object)FunctionParserTest.ID_ROW_3_0)).withAggregates((Iterable)ImmutableList.of((Object)AggregateParserTest.SUM_AND_TO_STRING_ROW_3_0)));
        Assertions.assertThat((Map)refresh.newKeyspaces).hasSize(1);
        KeyspaceMetadata keyspace = (KeyspaceMetadata)refresh.newKeyspaces.values().iterator().next();
        this.checkKeyspace(keyspace);
        ((MapAssert)Assertions.assertThat((Map)keyspace.getUserDefinedTypes()).hasSize(1)).containsKey((Object)CqlIdentifier.fromInternal((String)"t"));
        ((MapAssert)Assertions.assertThat((Map)keyspace.getTables()).hasSize(1)).containsKey((Object)CqlIdentifier.fromInternal((String)"foo"));
        ((MapAssert)Assertions.assertThat((Map)keyspace.getViews()).hasSize(1)).containsKey((Object)CqlIdentifier.fromInternal((String)"alltimehigh"));
        ((MapAssert)Assertions.assertThat((Map)keyspace.getFunctions()).hasSize(1)).containsKey((Object)new FunctionSignature(CqlIdentifier.fromInternal((String)"id"), new DataType[]{DataTypes.INT}));
        ((MapAssert)Assertions.assertThat((Map)keyspace.getAggregates()).hasSize(1)).containsKey((Object)new FunctionSignature(CqlIdentifier.fromInternal((String)"sum_and_to_string"), new DataType[]{DataTypes.INT}));
    }

    private void checkKeyspace(KeyspaceMetadata keyspace) {
        Assertions.assertThat((String)keyspace.getName().asInternal()).isEqualTo("ks");
        Assertions.assertThat((boolean)keyspace.isDurableWrites()).isTrue();
        ((MapAssert)((MapAssert)Assertions.assertThat((Map)keyspace.getReplication()).hasSize(2)).containsEntry((Object)"class", (Object)"org.apache.cassandra.locator.SimpleStrategy")).containsEntry((Object)"replication_factor", (Object)"1");
    }

    @Test
    public void should_parse_multiple_keyspaces() {
        SchemaRefresh refresh = (SchemaRefresh)this.parse(rows -> rows.withKeyspaces((Iterable)ImmutableList.of((Object)SchemaParserTest.mockModernKeyspaceRow("ks1"), (Object)SchemaParserTest.mockModernKeyspaceRow("ks2"))).withTypes((Iterable)ImmutableList.of((Object)SchemaParserTest.mockTypeRow("ks1", "t1", (List<String>)ImmutableList.of((Object)"i"), (List<String>)ImmutableList.of((Object)"int")), (Object)SchemaParserTest.mockTypeRow("ks2", "t2", (List<String>)ImmutableList.of((Object)"i"), (List<String>)ImmutableList.of((Object)"int")))));
        Map keyspaces = refresh.newKeyspaces;
        Assertions.assertThat((Map)keyspaces).hasSize(2);
        KeyspaceMetadata ks1 = (KeyspaceMetadata)keyspaces.get(CqlIdentifier.fromInternal((String)"ks1"));
        KeyspaceMetadata ks2 = (KeyspaceMetadata)keyspaces.get(CqlIdentifier.fromInternal((String)"ks2"));
        Assertions.assertThat((String)ks1.getName().asInternal()).isEqualTo("ks1");
        ((MapAssert)Assertions.assertThat((Map)ks1.getUserDefinedTypes()).hasSize(1)).containsKey((Object)CqlIdentifier.fromInternal((String)"t1"));
        Assertions.assertThat((String)ks2.getName().asInternal()).isEqualTo("ks2");
        ((MapAssert)Assertions.assertThat((Map)ks2.getUserDefinedTypes()).hasSize(1)).containsKey((Object)CqlIdentifier.fromInternal((String)"t2"));
    }

    private MetadataRefresh parse(Consumer<CassandraSchemaRows.Builder> builderConfig) {
        CassandraSchemaRows.Builder builder = new CassandraSchemaRows.Builder(NODE_3_0, this.keyspaceFilter, "test");
        builderConfig.accept(builder);
        CassandraSchemaRows rows = builder.build();
        return new CassandraSchemaParser((SchemaRows)rows, this.context).parse();
    }
}

