/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.metadata.schema.parsing;

import com.datastax.oss.driver.Assertions;
import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.metadata.schema.FunctionMetadata;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.DataTypes;
import com.datastax.oss.driver.internal.core.adminrequest.AdminRow;
import com.datastax.oss.driver.internal.core.metadata.schema.parsing.DataTypeClassNameParser;
import com.datastax.oss.driver.internal.core.metadata.schema.parsing.DataTypeCqlNameParser;
import com.datastax.oss.driver.internal.core.metadata.schema.parsing.DataTypeParser;
import com.datastax.oss.driver.internal.core.metadata.schema.parsing.FunctionParser;
import com.datastax.oss.driver.internal.core.metadata.schema.parsing.SchemaParserTestBase;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import org.junit.Test;

public class FunctionParserTest
extends SchemaParserTestBase {
    private static final AdminRow ID_ROW_2_2 = FunctionParserTest.mockFunctionRow("ks", "id", (List<String>)ImmutableList.of((Object)"i"), (List<String>)ImmutableList.of((Object)"org.apache.cassandra.db.marshal.Int32Type"), "return i;", false, "java", "org.apache.cassandra.db.marshal.Int32Type");
    static final AdminRow ID_ROW_3_0 = FunctionParserTest.mockFunctionRow("ks", "id", (List<String>)ImmutableList.of((Object)"i"), (List<String>)ImmutableList.of((Object)"int"), "return i;", false, "java", "int");

    @Test
    public void should_parse_modern_table() {
        FunctionParser parser = new FunctionParser((DataTypeParser)new DataTypeCqlNameParser(), this.context);
        FunctionMetadata function = parser.parseFunction(ID_ROW_3_0, KEYSPACE_ID, Collections.emptyMap());
        Assertions.assertThat((String)function.getKeyspace().asInternal()).isEqualTo("ks");
        Assertions.assertThat((String)function.getSignature().getName().asInternal()).isEqualTo("id");
        Assertions.assertThat((List)function.getSignature().getParameterTypes()).containsExactly((Object[])new DataType[]{DataTypes.INT});
        Assertions.assertThat((List)function.getParameterNames()).containsExactly((Object[])new CqlIdentifier[]{CqlIdentifier.fromInternal((String)"i")});
        Assertions.assertThat((String)function.getBody()).isEqualTo("return i;");
        Assertions.assertThat((boolean)function.isCalledOnNullInput()).isFalse();
        Assertions.assertThat((String)function.getLanguage()).isEqualTo("java");
        Assertions.assertThat((Object)function.getReturnType()).isEqualTo((Object)DataTypes.INT);
    }

    @Test
    public void should_parse_legacy_table() {
        FunctionParser parser = new FunctionParser((DataTypeParser)new DataTypeClassNameParser(), this.context);
        FunctionMetadata function = parser.parseFunction(ID_ROW_2_2, KEYSPACE_ID, Collections.emptyMap());
        Assertions.assertThat((String)function.getKeyspace().asInternal()).isEqualTo("ks");
        Assertions.assertThat((String)function.getSignature().getName().asInternal()).isEqualTo("id");
        Assertions.assertThat((List)function.getSignature().getParameterTypes()).containsExactly((Object[])new DataType[]{DataTypes.INT});
        Assertions.assertThat((List)function.getParameterNames()).containsExactly((Object[])new CqlIdentifier[]{CqlIdentifier.fromInternal((String)"i")});
        Assertions.assertThat((String)function.getBody()).isEqualTo("return i;");
        Assertions.assertThat((boolean)function.isCalledOnNullInput()).isFalse();
        Assertions.assertThat((String)function.getLanguage()).isEqualTo("java");
        Assertions.assertThat((Object)function.getReturnType()).isEqualTo((Object)DataTypes.INT);
    }
}

