/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.metadata;

import com.datastax.oss.driver.Assertions;
import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.config.DriverConfig;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.config.DriverOption;
import com.datastax.oss.driver.api.core.metadata.EndPoint;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.internal.core.context.EventBus;
import com.datastax.oss.driver.internal.core.context.InternalDriverContext;
import com.datastax.oss.driver.internal.core.context.NettyOptions;
import com.datastax.oss.driver.internal.core.control.ControlConnection;
import com.datastax.oss.driver.internal.core.metadata.AddNodeRefresh;
import com.datastax.oss.driver.internal.core.metadata.DefaultNode;
import com.datastax.oss.driver.internal.core.metadata.FullNodeListRefresh;
import com.datastax.oss.driver.internal.core.metadata.InitialNodeListRefresh;
import com.datastax.oss.driver.internal.core.metadata.MetadataManager;
import com.datastax.oss.driver.internal.core.metadata.MetadataRefresh;
import com.datastax.oss.driver.internal.core.metadata.NodeInfo;
import com.datastax.oss.driver.internal.core.metadata.RemoveNodeRefresh;
import com.datastax.oss.driver.internal.core.metadata.TestNodeFactory;
import com.datastax.oss.driver.internal.core.metadata.TopologyMonitor;
import com.datastax.oss.driver.internal.core.metadata.schema.parsing.SchemaParserFactory;
import com.datastax.oss.driver.internal.core.metadata.schema.queries.SchemaQueriesFactory;
import com.datastax.oss.driver.internal.core.metrics.MetricsFactory;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableList;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableSet;
import io.netty.channel.DefaultEventLoopGroup;
import java.net.InetSocketAddress;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.AbstractThrowableAssert;
import org.awaitility.Awaitility;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;

public class MetadataManagerTest {
    private static final EndPoint END_POINT2 = TestNodeFactory.newEndPoint(2);
    private static final EndPoint END_POINT3 = TestNodeFactory.newEndPoint(3);
    @Mock
    private InternalDriverContext context;
    @Mock
    private NettyOptions nettyOptions;
    @Mock
    private ControlConnection controlConnection;
    @Mock
    private TopologyMonitor topologyMonitor;
    @Mock
    private DriverConfig config;
    @Mock
    private DriverExecutionProfile defaultProfile;
    @Mock
    private EventBus eventBus;
    @Mock
    private SchemaQueriesFactory schemaQueriesFactory;
    @Mock
    private SchemaParserFactory schemaParserFactory;
    @Mock
    protected MetricsFactory metricsFactory;
    private DefaultEventLoopGroup adminEventLoopGroup;
    private TestMetadataManager metadataManager;

    @Before
    public void setup() {
        MockitoAnnotations.initMocks((Object)this);
        this.adminEventLoopGroup = new DefaultEventLoopGroup(1);
        Mockito.when((Object)this.nettyOptions.adminEventExecutorGroup()).thenReturn((Object)this.adminEventLoopGroup);
        Mockito.when((Object)this.context.getNettyOptions()).thenReturn((Object)this.nettyOptions);
        Mockito.when((Object)this.context.getTopologyMonitor()).thenReturn((Object)this.topologyMonitor);
        Mockito.when((Object)this.context.getControlConnection()).thenReturn((Object)this.controlConnection);
        Mockito.when((Object)this.defaultProfile.getDuration((DriverOption)DefaultDriverOption.METADATA_SCHEMA_WINDOW)).thenReturn((Object)Duration.ZERO);
        Mockito.when((Object)this.defaultProfile.getInt((DriverOption)DefaultDriverOption.METADATA_SCHEMA_MAX_EVENTS)).thenReturn((Object)1);
        Mockito.when((Object)this.config.getDefaultProfile()).thenReturn((Object)this.defaultProfile);
        Mockito.when((Object)this.context.getConfig()).thenReturn((Object)this.config);
        Mockito.when((Object)this.context.getEventBus()).thenReturn((Object)this.eventBus);
        Mockito.when((Object)this.context.getSchemaQueriesFactory()).thenReturn((Object)this.schemaQueriesFactory);
        Mockito.when((Object)this.context.getSchemaParserFactory()).thenReturn((Object)this.schemaParserFactory);
        Mockito.when((Object)this.context.getMetricsFactory()).thenReturn((Object)this.metricsFactory);
        this.metadataManager = new TestMetadataManager(this.context);
    }

    @After
    public void teardown() {
        this.adminEventLoopGroup.shutdownGracefully(100L, 200L, TimeUnit.MILLISECONDS);
    }

    @Test
    public void should_add_contact_points() {
        this.metadataManager.addContactPoints((Set)ImmutableSet.of((Object)END_POINT2));
        Assertions.assertThat((Iterable)this.metadataManager.getContactPoints()).extracting(Node::getEndPoint).containsOnly((Object[])new EndPoint[]{END_POINT2});
        Assertions.assertThat((boolean)this.metadataManager.wasImplicitContactPoint()).isFalse();
    }

    @Test
    public void should_use_default_if_no_contact_points_provided() {
        this.metadataManager.addContactPoints(Collections.emptySet());
        Assertions.assertThat((Iterable)this.metadataManager.getContactPoints()).extracting(Node::getEndPoint).containsOnly((Object[])new EndPoint[]{MetadataManager.DEFAULT_CONTACT_POINT});
        Assertions.assertThat((boolean)this.metadataManager.wasImplicitContactPoint()).isTrue();
    }

    @Test
    public void should_copy_contact_points_on_refresh_of_all_nodes() {
        this.should_use_default_if_no_contact_points_provided();
        NodeInfo info1 = (NodeInfo)Mockito.mock(NodeInfo.class);
        NodeInfo info2 = (NodeInfo)Mockito.mock(NodeInfo.class);
        ImmutableList infos = ImmutableList.of((Object)info1, (Object)info2);
        Mockito.when((Object)this.topologyMonitor.refreshNodeList()).thenReturn(CompletableFuture.completedFuture(infos));
        CompletionStage refreshNodesFuture = this.metadataManager.refreshNodes();
        this.waitForPendingAdminTasks(() -> this.metadataManager.refreshes.size() == 1);
        Assertions.assertThatStage(refreshNodesFuture).isSuccess();
        Assertions.assertThat((List)this.metadataManager.refreshes).hasSize(1);
        InitialNodeListRefresh refresh = (InitialNodeListRefresh)this.metadataManager.refreshes.get(0);
        Assertions.assertThat((Iterable)refresh.contactPoints).extracting(Node::getEndPoint).containsOnly((Object[])new EndPoint[]{MetadataManager.DEFAULT_CONTACT_POINT});
        Assertions.assertThat((Iterable)refresh.nodeInfos).containsExactlyInAnyOrder((Object[])new NodeInfo[]{info1, info2});
    }

    @Test
    public void should_refresh_all_nodes() {
        this.should_copy_contact_points_on_refresh_of_all_nodes();
        this.metadataManager.refreshes.clear();
        NodeInfo info1 = (NodeInfo)Mockito.mock(NodeInfo.class);
        NodeInfo info2 = (NodeInfo)Mockito.mock(NodeInfo.class);
        ImmutableList infos = ImmutableList.of((Object)info1, (Object)info2);
        Mockito.when((Object)this.topologyMonitor.refreshNodeList()).thenReturn(CompletableFuture.completedFuture(infos));
        CompletionStage refreshNodesFuture = this.metadataManager.refreshNodes();
        this.waitForPendingAdminTasks(() -> this.metadataManager.refreshes.size() == 1);
        Assertions.assertThatStage(refreshNodesFuture).isSuccess();
        Assertions.assertThat((List)this.metadataManager.refreshes).hasSize(1);
        FullNodeListRefresh refresh = (FullNodeListRefresh)this.metadataManager.refreshes.get(0);
        Assertions.assertThat((Iterable)refresh.nodeInfos).containsExactlyInAnyOrder((Object[])new NodeInfo[]{info1, info2});
    }

    @Test
    public void should_refresh_single_node() {
        DefaultNode node = TestNodeFactory.newNode(2, this.context);
        NodeInfo info = (NodeInfo)Mockito.mock(NodeInfo.class);
        Mockito.when((Object)info.getDatacenter()).thenReturn((Object)"dc1");
        Mockito.when((Object)info.getHostId()).thenReturn((Object)UUID.randomUUID());
        Mockito.when((Object)info.getEndPoint()).thenReturn((Object)node.getEndPoint());
        Mockito.when((Object)this.topologyMonitor.refreshNode((Node)node)).thenReturn(CompletableFuture.completedFuture(Optional.of(info)));
        CompletionStage refreshNodeFuture = this.metadataManager.refreshNode((Node)node);
        Assertions.assertThatStage(refreshNodeFuture).isSuccess();
        ((NodeInfo)Mockito.verify((Object)info, (VerificationMode)Mockito.timeout((long)500L))).getDatacenter();
        Assertions.assertThat((String)node.getDatacenter()).isEqualTo("dc1");
    }

    @Test
    public void should_ignore_node_refresh_if_topology_monitor_does_not_have_info() {
        Node node = (Node)Mockito.mock(Node.class);
        Mockito.when((Object)this.topologyMonitor.refreshNode(node)).thenReturn(CompletableFuture.completedFuture(Optional.empty()));
        CompletionStage refreshNodeFuture = this.metadataManager.refreshNode(node);
        Assertions.assertThatStage(refreshNodeFuture).isSuccess();
    }

    @Test
    public void should_add_node() {
        InetSocketAddress broadcastRpcAddress = (InetSocketAddress)END_POINT2.resolve();
        NodeInfo info = (NodeInfo)Mockito.mock(NodeInfo.class);
        Mockito.when((Object)info.getBroadcastRpcAddress()).thenReturn(Optional.of(broadcastRpcAddress));
        Mockito.when((Object)this.topologyMonitor.getNewNodeInfo(broadcastRpcAddress)).thenReturn(CompletableFuture.completedFuture(Optional.of(info)));
        this.metadataManager.addNode(broadcastRpcAddress);
        this.waitForPendingAdminTasks(() -> this.metadataManager.addNodeCount == 1);
        Assertions.assertThat((List)this.metadataManager.refreshes).hasSize(1);
        AddNodeRefresh refresh = (AddNodeRefresh)this.metadataManager.refreshes.get(0);
        Assertions.assertThat((Object)refresh.newNodeInfo).isEqualTo((Object)info);
    }

    @Test
    public void should_not_add_node_if_broadcast_rpc_address_does_not_match() {
        InetSocketAddress broadcastRpcAddress2 = (InetSocketAddress)END_POINT2.resolve();
        InetSocketAddress broadcastRpcAddress3 = (InetSocketAddress)END_POINT3.resolve();
        NodeInfo info = (NodeInfo)Mockito.mock(NodeInfo.class);
        Mockito.when((Object)this.topologyMonitor.getNewNodeInfo(broadcastRpcAddress2)).thenReturn(CompletableFuture.completedFuture(Optional.of(info)));
        Mockito.when((Object)info.getBroadcastRpcAddress()).thenReturn(Optional.of(broadcastRpcAddress3));
        this.metadataManager.addNode(broadcastRpcAddress2);
        this.waitForPendingAdminTasks(() -> this.metadataManager.addNodeCount == 1);
        Assertions.assertThat((List)this.metadataManager.refreshes).isEmpty();
    }

    @Test
    public void should_not_add_node_if_topology_monitor_does_not_have_info() {
        InetSocketAddress broadcastRpcAddress2 = (InetSocketAddress)END_POINT2.resolve();
        Mockito.when((Object)this.topologyMonitor.getNewNodeInfo(broadcastRpcAddress2)).thenReturn(CompletableFuture.completedFuture(Optional.empty()));
        this.metadataManager.addNode(broadcastRpcAddress2);
        this.waitForPendingAdminTasks(() -> this.metadataManager.addNodeCount == 1);
        Assertions.assertThat((List)this.metadataManager.refreshes).isEmpty();
    }

    @Test
    public void should_remove_node() {
        InetSocketAddress broadcastRpcAddress2 = (InetSocketAddress)END_POINT2.resolve();
        this.metadataManager.removeNode(broadcastRpcAddress2);
        this.waitForPendingAdminTasks(() -> this.metadataManager.removeNodeCount == 1);
        Assertions.assertThat((List)this.metadataManager.refreshes).hasSize(1);
        RemoveNodeRefresh refresh = (RemoveNodeRefresh)this.metadataManager.refreshes.get(0);
        Assertions.assertThat((Object)refresh.broadcastRpcAddressToRemove).isEqualTo((Object)broadcastRpcAddress2);
    }

    @Test
    public void refreshSchema_should_work() {
        IllegalStateException expectedException = new IllegalStateException("Error we're testing");
        Mockito.when((Object)this.schemaQueriesFactory.newInstance()).thenThrow(new Throwable[]{expectedException});
        Mockito.when((Object)this.topologyMonitor.refreshNodeList()).thenReturn(CompletableFuture.completedFuture(ImmutableList.of((Object)((NodeInfo)Mockito.mock(NodeInfo.class)))));
        Mockito.when((Object)this.topologyMonitor.checkSchemaAgreement()).thenReturn(CompletableFuture.completedFuture(Boolean.TRUE));
        Mockito.when((Object)this.controlConnection.init(ArgumentMatchers.anyBoolean(), ArgumentMatchers.anyBoolean(), ArgumentMatchers.anyBoolean())).thenReturn(CompletableFuture.completedFuture(null));
        this.metadataManager.refreshNodes();
        this.waitForPendingAdminTasks(() -> this.metadataManager.refreshes.size() == 1);
        CompletionStage result = this.metadataManager.refreshSchema("foo", true, true);
        this.waitForPendingAdminTasks(() -> result.toCompletableFuture().isDone());
        Assertions.assertThatStage(result).isFailed(t -> {
            AbstractThrowableAssert cfr_ignored_0 = (AbstractThrowableAssert)Assertions.assertThat((Throwable)t).isEqualTo((Object)expectedException);
        });
    }

    private void waitForPendingAdminTasks(Callable<Boolean> condition) {
        Awaitility.await().atMost(500L, TimeUnit.MILLISECONDS).until(condition);
    }

    private static class TestMetadataManager
    extends MetadataManager {
        private List<MetadataRefresh> refreshes = new CopyOnWriteArrayList<MetadataRefresh>();
        private volatile int addNodeCount = 0;
        private volatile int removeNodeCount = 0;

        public TestMetadataManager(InternalDriverContext context) {
            super(context);
        }

        Void apply(MetadataRefresh refresh) {
            this.refreshes.add(refresh);
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addNode(InetSocketAddress broadcastRpcAddress) {
            TestMetadataManager testMetadataManager = this;
            synchronized (testMetadataManager) {
                ++this.addNodeCount;
            }
            super.addNode(broadcastRpcAddress);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeNode(InetSocketAddress broadcastRpcAddress) {
            TestMetadataManager testMetadataManager = this;
            synchronized (testMetadataManager) {
                ++this.removeNodeCount;
            }
            super.removeNode(broadcastRpcAddress);
        }
    }
}

