/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.metadata;

import com.datastax.oss.driver.Assertions;
import com.datastax.oss.driver.api.core.metadata.EndPoint;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.internal.core.channel.ChannelFactory;
import com.datastax.oss.driver.internal.core.context.InternalDriverContext;
import com.datastax.oss.driver.internal.core.metadata.DefaultMetadata;
import com.datastax.oss.driver.internal.core.metadata.DefaultNode;
import com.datastax.oss.driver.internal.core.metadata.DefaultNodeInfo;
import com.datastax.oss.driver.internal.core.metadata.InitialNodeListRefresh;
import com.datastax.oss.driver.internal.core.metadata.MetadataRefresh;
import com.datastax.oss.driver.internal.core.metadata.TestNodeFactory;
import com.datastax.oss.driver.internal.core.metrics.MetricsFactory;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableList;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class InitialNodeListRefreshTest {
    @Mock
    private InternalDriverContext context;
    @Mock
    protected MetricsFactory metricsFactory;
    @Mock
    private ChannelFactory channelFactory;
    private DefaultNode contactPoint1;
    private DefaultNode contactPoint2;
    private EndPoint endPoint3;
    private UUID hostId1;
    private UUID hostId2;
    private UUID hostId3;

    @Before
    public void setup() {
        Mockito.when((Object)this.context.getMetricsFactory()).thenReturn((Object)this.metricsFactory);
        Mockito.when((Object)this.context.getChannelFactory()).thenReturn((Object)this.channelFactory);
        this.contactPoint1 = TestNodeFactory.newContactPoint(1, this.context);
        this.contactPoint2 = TestNodeFactory.newContactPoint(2, this.context);
        this.endPoint3 = TestNodeFactory.newEndPoint(3);
        this.hostId1 = UUID.randomUUID();
        this.hostId2 = UUID.randomUUID();
        this.hostId3 = UUID.randomUUID();
    }

    @Test
    public void should_copy_contact_points() {
        ImmutableList newInfos = ImmutableList.of((Object)DefaultNodeInfo.builder().withEndPoint(this.contactPoint1.getEndPoint()).withHostId(this.hostId1).build(), (Object)DefaultNodeInfo.builder().withEndPoint(this.contactPoint2.getEndPoint()).withHostId(this.hostId2).build());
        InitialNodeListRefresh refresh = new InitialNodeListRefresh((Iterable)newInfos, (Set)ImmutableSet.of((Object)this.contactPoint1, (Object)this.contactPoint2));
        MetadataRefresh.Result result = refresh.compute(DefaultMetadata.EMPTY, false, this.context);
        Map newNodes = result.newMetadata.getNodes();
        Assertions.assertThat((Map)newNodes).containsOnlyKeys((Object[])new UUID[]{this.hostId1, this.hostId2});
        Assertions.assertThat((Object)((Node)newNodes.get(this.hostId1))).isEqualTo((Object)this.contactPoint1);
        Assertions.assertThat((Comparable)this.contactPoint1.getHostId()).isEqualTo((Object)this.hostId1);
        Assertions.assertThat((Object)((Node)newNodes.get(this.hostId2))).isEqualTo((Object)this.contactPoint2);
        Assertions.assertThat((Comparable)this.contactPoint2.getHostId()).isEqualTo((Object)this.hostId2);
    }

    @Test
    public void should_add_other_nodes() {
        ImmutableList newInfos = ImmutableList.of((Object)DefaultNodeInfo.builder().withEndPoint(this.contactPoint1.getEndPoint()).withHostId(this.hostId1).build(), (Object)DefaultNodeInfo.builder().withEndPoint(this.contactPoint2.getEndPoint()).withHostId(this.hostId2).build(), (Object)DefaultNodeInfo.builder().withEndPoint(this.endPoint3).withHostId(this.hostId3).build());
        InitialNodeListRefresh refresh = new InitialNodeListRefresh((Iterable)newInfos, (Set)ImmutableSet.of((Object)this.contactPoint1, (Object)this.contactPoint2));
        MetadataRefresh.Result result = refresh.compute(DefaultMetadata.EMPTY, false, this.context);
        Map newNodes = result.newMetadata.getNodes();
        Assertions.assertThat((Map)newNodes).containsOnlyKeys((Object[])new UUID[]{this.hostId1, this.hostId2, this.hostId3});
        Node node3 = (Node)newNodes.get(this.hostId3);
        Assertions.assertThat((Object)node3.getEndPoint()).isEqualTo((Object)this.endPoint3);
        Assertions.assertThat((Comparable)node3.getHostId()).isEqualTo((Object)this.hostId3);
    }

    @Test
    public void should_ignore_duplicate_host_ids() {
        ImmutableList newInfos = ImmutableList.of((Object)DefaultNodeInfo.builder().withEndPoint(this.contactPoint1.getEndPoint()).withHostId(this.hostId1).withDatacenter("dc1").build(), (Object)DefaultNodeInfo.builder().withEndPoint(this.contactPoint1.getEndPoint()).withDatacenter("dc2").withHostId(this.hostId1).build());
        InitialNodeListRefresh refresh = new InitialNodeListRefresh((Iterable)newInfos, (Set)ImmutableSet.of((Object)this.contactPoint1));
        MetadataRefresh.Result result = refresh.compute(DefaultMetadata.EMPTY, false, this.context);
        Map newNodes = result.newMetadata.getNodes();
        Assertions.assertThat((Map)newNodes).containsOnlyKeys((Object[])new UUID[]{this.hostId1});
        Assertions.assertThat((Object)((Node)newNodes.get(this.hostId1))).isEqualTo((Object)this.contactPoint1);
        Assertions.assertThat((Comparable)this.contactPoint1.getHostId()).isEqualTo((Object)this.hostId1);
        Assertions.assertThat((String)this.contactPoint1.getDatacenter()).isEqualTo("dc1");
    }
}

