/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.metadata;

import com.datastax.oss.driver.Assertions;
import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.api.core.metadata.TokenMap;
import com.datastax.oss.driver.api.core.metadata.schema.KeyspaceMetadata;
import com.datastax.oss.driver.internal.core.channel.ChannelFactory;
import com.datastax.oss.driver.internal.core.context.InternalDriverContext;
import com.datastax.oss.driver.internal.core.metadata.DefaultMetadata;
import com.datastax.oss.driver.internal.core.metadata.DefaultNode;
import com.datastax.oss.driver.internal.core.metadata.token.DefaultReplicationStrategyFactory;
import com.datastax.oss.driver.internal.core.metadata.token.Murmur3TokenFactory;
import com.datastax.oss.driver.internal.core.metadata.token.TokenFactory;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableMap;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class DefaultMetadataTokenMapTest {
    private static final String TOKEN1 = "-9000000000000000000";
    private static final String TOKEN2 = "9000000000000000000";
    private static final Node NODE1 = DefaultMetadataTokenMapTest.mockNode("-9000000000000000000");
    private static final Node NODE2 = DefaultMetadataTokenMapTest.mockNode("9000000000000000000");
    private static final CqlIdentifier KEYSPACE_NAME = CqlIdentifier.fromInternal((String)"ks");
    private static final KeyspaceMetadata KEYSPACE = DefaultMetadataTokenMapTest.mockKeyspace(KEYSPACE_NAME, (Map<String, String>)ImmutableMap.of((Object)"class", (Object)"org.apache.cassandra.locator.SimpleStrategy", (Object)"replication_factor", (Object)"1"));
    @Mock
    private InternalDriverContext context;
    @Mock
    private ChannelFactory channelFactory;

    @Before
    public void setup() {
        Mockito.when((Object)this.context.getChannelFactory()).thenReturn((Object)this.channelFactory);
        DefaultReplicationStrategyFactory replicationStrategyFactory = new DefaultReplicationStrategyFactory(this.context);
        Mockito.when((Object)this.context.getReplicationStrategyFactory()).thenReturn((Object)replicationStrategyFactory);
    }

    @Test
    public void should_not_build_token_map_when_initializing_with_contact_points() {
        DefaultMetadata contactPointsMetadata = new DefaultMetadata((Map)ImmutableMap.of((Object)NODE1.getHostId(), (Object)NODE1), Collections.emptyMap(), null, null);
        Assertions.assertThat((Optional)contactPointsMetadata.getTokenMap()).isNotPresent();
    }

    @Test
    public void should_build_minimal_token_map_on_first_refresh() {
        DefaultMetadata contactPointsMetadata = new DefaultMetadata((Map)ImmutableMap.of((Object)NODE1.getHostId(), (Object)NODE1), Collections.emptyMap(), null, null);
        DefaultMetadata firstRefreshMetadata = contactPointsMetadata.withNodes((Map)ImmutableMap.of((Object)NODE1.getHostId(), (Object)NODE1), true, true, (TokenFactory)new Murmur3TokenFactory(), this.context);
        Assertions.assertThat((Iterable)((TokenMap)firstRefreshMetadata.getTokenMap().get()).getTokenRanges()).hasSize(1);
    }

    @Test
    public void should_not_build_token_map_when_disabled() {
        DefaultMetadata contactPointsMetadata = new DefaultMetadata((Map)ImmutableMap.of((Object)NODE1.getHostId(), (Object)NODE1), Collections.emptyMap(), null, null);
        DefaultMetadata firstRefreshMetadata = contactPointsMetadata.withNodes((Map)ImmutableMap.of((Object)NODE1.getHostId(), (Object)NODE1), false, true, (TokenFactory)new Murmur3TokenFactory(), this.context);
        Assertions.assertThat((Optional)firstRefreshMetadata.getTokenMap()).isNotPresent();
    }

    @Test
    public void should_stay_empty_on_first_refresh_if_partitioner_missing() {
        DefaultMetadata contactPointsMetadata = new DefaultMetadata((Map)ImmutableMap.of((Object)NODE1.getHostId(), (Object)NODE1), Collections.emptyMap(), null, null);
        DefaultMetadata firstRefreshMetadata = contactPointsMetadata.withNodes((Map)ImmutableMap.of((Object)NODE1.getHostId(), (Object)NODE1), true, true, null, this.context);
        Assertions.assertThat((Optional)firstRefreshMetadata.getTokenMap()).isNotPresent();
    }

    @Test
    public void should_update_minimal_token_map_if_new_node_and_still_no_schema() {
        DefaultMetadata contactPointsMetadata = new DefaultMetadata((Map)ImmutableMap.of((Object)NODE1.getHostId(), (Object)NODE1), Collections.emptyMap(), null, null);
        DefaultMetadata firstRefreshMetadata = contactPointsMetadata.withNodes((Map)ImmutableMap.of((Object)NODE1.getHostId(), (Object)NODE1), true, true, (TokenFactory)new Murmur3TokenFactory(), this.context);
        DefaultMetadata secondRefreshMetadata = firstRefreshMetadata.withNodes((Map)ImmutableMap.of((Object)NODE1.getHostId(), (Object)NODE1, (Object)NODE2.getHostId(), (Object)NODE2), true, false, null, this.context);
        Assertions.assertThat((Iterable)((TokenMap)secondRefreshMetadata.getTokenMap().get()).getTokenRanges()).hasSize(2);
    }

    @Test
    public void should_update_token_map_when_schema_changes() {
        DefaultMetadata contactPointsMetadata = new DefaultMetadata((Map)ImmutableMap.of((Object)NODE1.getHostId(), (Object)NODE1), Collections.emptyMap(), null, null);
        DefaultMetadata firstRefreshMetadata = contactPointsMetadata.withNodes((Map)ImmutableMap.of((Object)NODE1.getHostId(), (Object)NODE1), true, true, (TokenFactory)new Murmur3TokenFactory(), this.context);
        DefaultMetadata schemaRefreshMetadata = firstRefreshMetadata.withSchema((Map)ImmutableMap.of((Object)KEYSPACE_NAME, (Object)KEYSPACE), true, this.context);
        Assertions.assertThat((Iterable)((TokenMap)schemaRefreshMetadata.getTokenMap().get()).getTokenRanges(KEYSPACE_NAME, NODE1)).isNotEmpty();
    }

    private static DefaultNode mockNode(String token) {
        DefaultNode node = (DefaultNode)Mockito.mock(DefaultNode.class);
        Mockito.when((Object)node.getHostId()).thenReturn((Object)UUID.randomUUID());
        Mockito.when((Object)node.getRawTokens()).thenReturn((Object)ImmutableSet.of((Object)token));
        return node;
    }

    private static KeyspaceMetadata mockKeyspace(CqlIdentifier name, Map<String, String> replicationConfig) {
        KeyspaceMetadata keyspace = (KeyspaceMetadata)Mockito.mock(KeyspaceMetadata.class);
        Mockito.when((Object)keyspace.getName()).thenReturn((Object)name);
        Mockito.when((Object)keyspace.getReplication()).thenReturn(replicationConfig);
        return keyspace;
    }
}

