/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.loadbalancing.nodeset;

import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.internal.core.loadbalancing.nodeset.SingleDcNodeSet;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.mockito.Mockito;

public class SingleDcNodeSetTest {
    @Test
    public void should_add_node() {
        SingleDcNodeSet set = new SingleDcNodeSet("dc1");
        Node node1 = this.mockNode("dc1");
        Assertions.assertThat((boolean)set.add(node1)).isTrue();
        Assertions.assertThat((boolean)set.add(node1)).isFalse();
        Node node2 = this.mockNode("dc2");
        Assertions.assertThat((boolean)set.add(node2)).isFalse();
    }

    @Test
    public void should_remove_node() {
        SingleDcNodeSet set = new SingleDcNodeSet("dc1");
        Node node = this.mockNode("dc1");
        set.add(node);
        Assertions.assertThat((boolean)set.remove(node)).isTrue();
        Assertions.assertThat((boolean)set.remove(node)).isFalse();
    }

    @Test
    public void should_return_all_nodes_if_local_dc() {
        SingleDcNodeSet set = new SingleDcNodeSet("dc1");
        Node node1 = this.mockNode("dc1");
        set.add(node1);
        Node node2 = this.mockNode("dc1");
        set.add(node2);
        Node node3 = this.mockNode("dc2");
        set.add(node3);
        Assertions.assertThat((Iterable)set.dc("dc1")).contains((Object[])new Node[]{node1, node2});
        Assertions.assertThat((Iterable)set.dc("dc2")).isEmpty();
        Assertions.assertThat((Iterable)set.dc(null)).isEmpty();
    }

    @Test
    public void should_return_only_local_dc() {
        SingleDcNodeSet set = new SingleDcNodeSet("dc1");
        Assertions.assertThat((Iterable)set.dcs()).contains((Object[])new String[]{"dc1"});
    }

    private Node mockNode(String dc) {
        Node node = (Node)Mockito.mock(Node.class);
        Mockito.when((Object)node.getDatacenter()).thenReturn((Object)dc);
        return node;
    }
}

