/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.loadbalancing;

import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.config.DriverOption;
import com.datastax.oss.driver.api.core.context.DriverContext;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.api.core.session.Session;
import com.datastax.oss.driver.internal.core.loadbalancing.BasicLoadBalancingPolicy;
import com.datastax.oss.driver.internal.core.loadbalancing.BasicLoadBalancingPolicyDcFailoverTest;
import com.datastax.oss.driver.internal.core.metadata.DefaultNode;
import com.datastax.oss.driver.internal.core.session.DefaultSession;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableList;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableMap;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableSet;
import java.util.Map;
import java.util.UUID;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class BasicLoadBalancingPolicyPreferredRemoteDcsTest
extends BasicLoadBalancingPolicyDcFailoverTest {
    @Mock
    protected DefaultNode node10;
    @Mock
    protected DefaultNode node11;
    @Mock
    protected DefaultNode node12;
    @Mock
    protected DefaultNode node13;
    @Mock
    protected DefaultNode node14;

    @Override
    @Test
    public void should_prioritize_single_replica() {
        Mockito.when((Object)this.request.getRoutingKeyspace()).thenReturn((Object)KEYSPACE);
        Mockito.when((Object)this.request.getRoutingKey()).thenReturn((Object)ROUTING_KEY);
        Mockito.when((Object)this.tokenMap.getReplicas(KEYSPACE, ROUTING_KEY)).thenReturn((Object)ImmutableSet.of((Object)this.node3));
        Assertions.assertThat((Iterable)this.policy.newQueryPlan(this.request, (Session)this.session)).containsExactly((Object[])new Node[]{this.node3, this.node1, this.node2, this.node4, this.node5, this.node9, this.node10, this.node6, this.node7, this.node12, this.node13});
        Assertions.assertThat((Iterable)this.policy.newQueryPlan(this.request, (Session)this.session)).containsExactly((Object[])new Node[]{this.node3, this.node2, this.node4, this.node5, this.node1, this.node9, this.node10, this.node6, this.node7, this.node12, this.node13});
        Assertions.assertThat((Iterable)this.policy.newQueryPlan(this.request, (Session)this.session)).containsExactly((Object[])new Node[]{this.node3, this.node4, this.node5, this.node1, this.node2, this.node9, this.node10, this.node6, this.node7, this.node12, this.node13});
        Assertions.assertThat((Iterable)this.policy.newQueryPlan(this.request, (Session)this.session)).containsExactly((Object[])new Node[]{this.node3, this.node5, this.node1, this.node2, this.node4, this.node9, this.node10, this.node6, this.node7, this.node12, this.node13});
        ((BasicLoadBalancingPolicy)Mockito.verify((Object)this.policy, (VerificationMode)Mockito.never())).shuffleHead((Object[])ArgumentMatchers.any(), ArgumentMatchers.eq((int)1));
        ((BasicLoadBalancingPolicy)Mockito.verify((Object)this.policy, (VerificationMode)Mockito.times((int)12))).shuffleHead((Object[])ArgumentMatchers.any(), ArgumentMatchers.eq((int)2));
    }

    @Override
    @Test
    public void should_prioritize_and_shuffle_replicas() {
        Mockito.when((Object)this.request.getRoutingKeyspace()).thenReturn((Object)KEYSPACE);
        Mockito.when((Object)this.request.getRoutingKey()).thenReturn((Object)ROUTING_KEY);
        Mockito.when((Object)this.tokenMap.getReplicas(KEYSPACE, ROUTING_KEY)).thenReturn((Object)ImmutableSet.of((Object)this.node1, (Object)this.node2, (Object)this.node3, (Object)this.node6, (Object)this.node9));
        Assertions.assertThat((Iterable)this.policy.newQueryPlan(this.request, (Session)this.session)).containsExactly((Object[])new Node[]{this.node1, this.node2, this.node3, this.node4, this.node5, this.node9, this.node10, this.node6, this.node7, this.node12, this.node13});
        Assertions.assertThat((Iterable)this.policy.newQueryPlan(this.request, (Session)this.session)).containsExactly((Object[])new Node[]{this.node1, this.node2, this.node3, this.node5, this.node4, this.node9, this.node10, this.node6, this.node7, this.node12, this.node13});
        ((BasicLoadBalancingPolicy)Mockito.verify((Object)this.policy, (VerificationMode)Mockito.times((int)2))).shuffleHead((Object[])ArgumentMatchers.any(), ArgumentMatchers.eq((int)3));
        ((BasicLoadBalancingPolicy)Mockito.verify((Object)this.policy, (VerificationMode)Mockito.times((int)6))).shuffleHead((Object[])ArgumentMatchers.any(), ArgumentMatchers.eq((int)2));
        ((DefaultSession)Mockito.verify((Object)this.session, (VerificationMode)Mockito.never())).getPools();
    }

    @Override
    protected void assertRoundRobinQueryPlans() {
        for (int i = 0; i < 3; ++i) {
            Assertions.assertThat((Iterable)this.policy.newQueryPlan(this.request, (Session)this.session)).containsExactly((Object[])new Node[]{this.node1, this.node2, this.node3, this.node4, this.node5, this.node9, this.node10, this.node6, this.node7, this.node12, this.node13});
            Assertions.assertThat((Iterable)this.policy.newQueryPlan(this.request, (Session)this.session)).containsExactly((Object[])new Node[]{this.node2, this.node3, this.node4, this.node5, this.node1, this.node9, this.node10, this.node6, this.node7, this.node12, this.node13});
            Assertions.assertThat((Iterable)this.policy.newQueryPlan(this.request, (Session)this.session)).containsExactly((Object[])new Node[]{this.node3, this.node4, this.node5, this.node1, this.node2, this.node9, this.node10, this.node6, this.node7, this.node12, this.node13});
            Assertions.assertThat((Iterable)this.policy.newQueryPlan(this.request, (Session)this.session)).containsExactly((Object[])new Node[]{this.node4, this.node5, this.node1, this.node2, this.node3, this.node9, this.node10, this.node6, this.node7, this.node12, this.node13});
            Assertions.assertThat((Iterable)this.policy.newQueryPlan(this.request, (Session)this.session)).containsExactly((Object[])new Node[]{this.node5, this.node1, this.node2, this.node3, this.node4, this.node9, this.node10, this.node6, this.node7, this.node12, this.node13});
        }
        ((BasicLoadBalancingPolicy)Mockito.verify((Object)this.policy, (VerificationMode)Mockito.atLeast((int)15))).shuffleHead((Object[])ArgumentMatchers.any(), ArgumentMatchers.eq((int)2));
    }

    @Override
    protected BasicLoadBalancingPolicy createAndInitPolicy() {
        Mockito.when((Object)this.node4.getDatacenter()).thenReturn((Object)"dc1");
        Mockito.when((Object)this.node5.getDatacenter()).thenReturn((Object)"dc1");
        Mockito.when((Object)this.node6.getDatacenter()).thenReturn((Object)"dc2");
        Mockito.when((Object)this.node7.getDatacenter()).thenReturn((Object)"dc2");
        Mockito.when((Object)this.node8.getDatacenter()).thenReturn((Object)"dc2");
        Mockito.when((Object)this.node9.getDatacenter()).thenReturn((Object)"dc3");
        Mockito.when((Object)this.node10.getDatacenter()).thenReturn((Object)"dc3");
        Mockito.when((Object)this.node11.getDatacenter()).thenReturn((Object)"dc3");
        Mockito.when((Object)this.node12.getDatacenter()).thenReturn((Object)"dc4");
        Mockito.when((Object)this.node13.getDatacenter()).thenReturn((Object)"dc4");
        Mockito.when((Object)this.node14.getDatacenter()).thenReturn((Object)"dc4");
        Mockito.when((Object)this.defaultProfile.getInt((DriverOption)DefaultDriverOption.LOAD_BALANCING_DC_FAILOVER_MAX_NODES_PER_REMOTE_DC)).thenReturn((Object)2);
        Mockito.when((Object)this.defaultProfile.getBoolean((DriverOption)DefaultDriverOption.LOAD_BALANCING_DC_FAILOVER_ALLOW_FOR_LOCAL_CONSISTENCY_LEVELS)).thenReturn((Object)false);
        Mockito.when((Object)this.defaultProfile.getStringList((DriverOption)DefaultDriverOption.LOAD_BALANCING_DC_FAILOVER_PREFERRED_REMOTE_DCS)).thenReturn((Object)ImmutableList.of((Object)"dc3", (Object)"dc2"));
        BasicLoadBalancingPolicy policy = (BasicLoadBalancingPolicy)Mockito.spy((Object)new BasicLoadBalancingPolicy((DriverContext)this.context, "default"){

            protected void shuffleHead(Object[] currentNodes, int headLength) {
            }
        });
        ImmutableMap nodes = ImmutableMap.builder().put((Object)UUID.randomUUID(), (Object)this.node1).put((Object)UUID.randomUUID(), (Object)this.node2).put((Object)UUID.randomUUID(), (Object)this.node3).put((Object)UUID.randomUUID(), (Object)this.node4).put((Object)UUID.randomUUID(), (Object)this.node5).put((Object)UUID.randomUUID(), (Object)this.node6).put((Object)UUID.randomUUID(), (Object)this.node7).put((Object)UUID.randomUUID(), (Object)this.node8).put((Object)UUID.randomUUID(), (Object)this.node9).put((Object)UUID.randomUUID(), (Object)this.node10).put((Object)UUID.randomUUID(), (Object)this.node11).put((Object)UUID.randomUUID(), (Object)this.node12).put((Object)UUID.randomUUID(), (Object)this.node13).put((Object)UUID.randomUUID(), (Object)this.node14).build();
        policy.init((Map)nodes, this.distanceReporter);
        Assertions.assertThat((Iterable)policy.getLiveNodes().dc("dc1")).containsExactly((Object[])new Node[]{this.node1, this.node2, this.node3, this.node4, this.node5});
        Assertions.assertThat((Iterable)policy.getLiveNodes().dc("dc2")).containsExactly((Object[])new Node[]{this.node6, this.node7});
        Assertions.assertThat((Iterable)policy.getLiveNodes().dc("dc3")).containsExactly((Object[])new Node[]{this.node9, this.node10});
        Assertions.assertThat((Iterable)policy.getLiveNodes().dc("dc4")).containsExactly((Object[])new Node[]{this.node12, this.node13});
        return policy;
    }
}

