/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.data;

import com.datastax.oss.driver.api.core.data.TupleValue;
import com.datastax.oss.driver.api.core.detach.AttachmentPoint;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.DataTypes;
import com.datastax.oss.driver.api.core.type.TupleType;
import com.datastax.oss.driver.api.core.type.codec.TypeCodecs;
import com.datastax.oss.driver.internal.SerializationHelper;
import com.datastax.oss.driver.internal.core.data.AccessibleByIndexTestBase;
import com.datastax.oss.driver.internal.core.type.DefaultTupleType;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableList;
import com.datastax.oss.protocol.internal.util.Bytes;
import java.nio.ByteBuffer;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.mockito.Mockito;

public class DefaultTupleValueTest
extends AccessibleByIndexTestBase<TupleValue> {
    @Override
    protected TupleValue newInstance(List<DataType> dataTypes, AttachmentPoint attachmentPoint) {
        DefaultTupleType type = new DefaultTupleType(dataTypes, attachmentPoint);
        return type.newValue();
    }

    @Override
    protected TupleValue newInstance(List<DataType> dataTypes, List<Object> values, AttachmentPoint attachmentPoint) {
        DefaultTupleType type = new DefaultTupleType(dataTypes, attachmentPoint);
        return type.newValue(values.toArray());
    }

    @Test
    public void should_serialize_and_deserialize() {
        DefaultTupleType type = new DefaultTupleType((List)ImmutableList.of((Object)DataTypes.INT, (Object)DataTypes.TEXT), this.attachmentPoint);
        TupleValue in = type.newValue();
        in = (TupleValue)in.setBytesUnsafe(0, Bytes.fromHexString((String)"0x00000001"));
        in = (TupleValue)in.setBytesUnsafe(1, Bytes.fromHexString((String)"0x61"));
        TupleValue out = SerializationHelper.serializeAndDeserialize(in);
        Assertions.assertThat((Object)out.getType()).isEqualTo((Object)in.getType());
        Assertions.assertThat((boolean)out.getType().isDetached()).isTrue();
        Assertions.assertThat((String)Bytes.toHexString((ByteBuffer)out.getBytesUnsafe(0))).isEqualTo("0x00000001");
        Assertions.assertThat((String)Bytes.toHexString((ByteBuffer)out.getBytesUnsafe(1))).isEqualTo("0x61");
    }

    @Test
    public void should_support_null_items_when_setting_in_bulk() {
        DefaultTupleType type = new DefaultTupleType((List)ImmutableList.of((Object)DataTypes.INT, (Object)DataTypes.TEXT), this.attachmentPoint);
        Mockito.when((Object)this.codecRegistry.codecFor(DataTypes.INT)).thenReturn((Object)TypeCodecs.INT);
        Mockito.when((Object)this.codecRegistry.codecFor(DataTypes.TEXT, (Object)"foo")).thenReturn((Object)TypeCodecs.TEXT);
        TupleValue value = type.newValue(new Object[]{null, "foo"});
        Assertions.assertThat((boolean)value.isNull(0)).isTrue();
        Assertions.assertThat((String)value.getString(1)).isEqualTo("foo");
    }

    @Test
    public void should_equate_instances_with_same_values_but_different_binary_representations() {
        TupleType tupleType = DataTypes.tupleOf((DataType[])new DataType[]{DataTypes.VARINT});
        TupleValue tuple1 = (TupleValue)tupleType.newValue().setBytesUnsafe(0, Bytes.fromHexString((String)"0x01"));
        TupleValue tuple2 = (TupleValue)tupleType.newValue().setBytesUnsafe(0, Bytes.fromHexString((String)"0x0001"));
        Assertions.assertThat((Object)tuple1).isEqualTo((Object)tuple2);
        Assertions.assertThat((int)tuple1.hashCode()).isEqualTo(tuple2.hashCode());
    }

    @Test
    public void should_not_equate_instances_with_same_binary_representation_but_different_types() {
        TupleType tupleType1 = DataTypes.tupleOf((DataType[])new DataType[]{DataTypes.INT});
        TupleType tupleType2 = DataTypes.tupleOf((DataType[])new DataType[]{DataTypes.VARINT});
        TupleValue tuple1 = (TupleValue)tupleType1.newValue().setBytesUnsafe(0, Bytes.fromHexString((String)"0x00000001"));
        TupleValue tuple2 = (TupleValue)tupleType2.newValue().setBytesUnsafe(0, Bytes.fromHexString((String)"0x00000001"));
        Assertions.assertThat((Object)tuple1).isNotEqualTo((Object)tuple2);
    }

    @Test
    public void should_equate_instances_with_different_protocol_versions() {
        TupleType tupleType1 = DataTypes.tupleOf((DataType[])new DataType[]{DataTypes.TEXT});
        tupleType1.attach(this.attachmentPoint);
        TupleType tupleType2 = DataTypes.tupleOf((DataType[])new DataType[]{DataTypes.TEXT});
        tupleType2.attach(this.v3AttachmentPoint);
        TupleValue tuple1 = (TupleValue)tupleType1.newValue().setBytesUnsafe(0, Bytes.fromHexString((String)"0x01"));
        TupleValue tuple2 = (TupleValue)tupleType2.newValue().setBytesUnsafe(0, Bytes.fromHexString((String)"0x01"));
        Assertions.assertThat((Object)tuple1).isEqualTo((Object)tuple2);
    }
}

