/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.cql;

import com.datastax.oss.driver.Assertions;
import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.DefaultProtocolVersion;
import com.datastax.oss.driver.api.core.cql.ColumnDefinition;
import com.datastax.oss.driver.api.core.cql.ColumnDefinitions;
import com.datastax.oss.driver.api.core.cql.ExecutionInfo;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.core.type.DataTypes;
import com.datastax.oss.driver.api.core.type.codec.TypeCodecs;
import com.datastax.oss.driver.api.core.type.codec.registry.CodecRegistry;
import com.datastax.oss.driver.internal.core.context.InternalDriverContext;
import com.datastax.oss.driver.internal.core.cql.DefaultAsyncResultSet;
import com.datastax.oss.driver.shaded.guava.common.collect.Lists;
import com.datastax.oss.protocol.internal.util.Bytes;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class DefaultAsyncResultSetTest {
    @Mock
    private ColumnDefinitions columnDefinitions;
    @Mock
    private ExecutionInfo executionInfo;
    @Mock
    private Statement<?> statement;
    @Mock
    private CqlSession session;
    @Mock
    private InternalDriverContext context;

    @Before
    public void setup() {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.executionInfo.getRequest()).thenAnswer(invocation -> this.statement);
        Mockito.when((Object)this.context.getCodecRegistry()).thenReturn((Object)CodecRegistry.DEFAULT);
        Mockito.when((Object)this.context.getProtocolVersion()).thenReturn((Object)DefaultProtocolVersion.DEFAULT);
    }

    @Test(expected=IllegalStateException.class)
    public void should_fail_to_fetch_next_page_if_last() {
        Mockito.when((Object)this.executionInfo.getPagingState()).thenReturn(null);
        DefaultAsyncResultSet resultSet = new DefaultAsyncResultSet(this.columnDefinitions, this.executionInfo, new ArrayDeque(), this.session, this.context);
        Assertions.assertThat((boolean)resultSet.hasMorePages()).isFalse();
        resultSet.fetchNextPage();
    }

    @Test
    public void should_invoke_session_to_fetch_next_page() {
        ByteBuffer mockPagingState = ByteBuffer.allocate(0);
        Mockito.when((Object)this.executionInfo.getPagingState()).thenReturn((Object)mockPagingState);
        Statement mockNextStatement = (Statement)Mockito.mock(Statement.class);
        Mockito.when((Object)this.statement.copy(mockPagingState)).thenReturn((Object)mockNextStatement);
        CompletableFuture mockResultFuture = new CompletableFuture();
        Mockito.when((Object)this.session.executeAsync((Statement)Mockito.any(Statement.class))).thenAnswer(invocation -> mockResultFuture);
        DefaultAsyncResultSet resultSet = new DefaultAsyncResultSet(this.columnDefinitions, this.executionInfo, new ArrayDeque(), this.session, this.context);
        Assertions.assertThat((boolean)resultSet.hasMorePages()).isTrue();
        CompletionStage nextPageFuture = resultSet.fetchNextPage();
        ((Statement)Mockito.verify(this.statement)).copy(mockPagingState);
        ((CqlSession)Mockito.verify((Object)this.session)).executeAsync(mockNextStatement);
        Assertions.assertThatStage(nextPageFuture).isEqualTo(mockResultFuture);
    }

    @Test
    public void should_report_applied_if_column_not_present_and_empty() {
        Mockito.when((Object)this.columnDefinitions.contains("[applied]")).thenReturn((Object)false);
        DefaultAsyncResultSet resultSet = new DefaultAsyncResultSet(this.columnDefinitions, this.executionInfo, new ArrayDeque(), this.session, this.context);
        Assertions.assertThat((boolean)resultSet.wasApplied()).isTrue();
    }

    @Test
    public void should_report_applied_if_column_not_present_and_not_empty() {
        Mockito.when((Object)this.columnDefinitions.contains("[applied]")).thenReturn((Object)false);
        ArrayDeque<ArrayList> data = new ArrayDeque<ArrayList>();
        data.add(Lists.newArrayList((Object[])new ByteBuffer[]{Bytes.fromHexString((String)"0xffff")}));
        DefaultAsyncResultSet resultSet = new DefaultAsyncResultSet(this.columnDefinitions, this.executionInfo, data, this.session, this.context);
        Assertions.assertThat((boolean)resultSet.wasApplied()).isTrue();
    }

    @Test
    public void should_report_not_applied_if_column_present_and_false() {
        Mockito.when((Object)this.columnDefinitions.contains("[applied]")).thenReturn((Object)true);
        ColumnDefinition columnDefinition = (ColumnDefinition)Mockito.mock(ColumnDefinition.class);
        Mockito.when((Object)columnDefinition.getType()).thenReturn((Object)DataTypes.BOOLEAN);
        Mockito.when((Object)this.columnDefinitions.get("[applied]")).thenReturn((Object)columnDefinition);
        Mockito.when((Object)this.columnDefinitions.firstIndexOf("[applied]")).thenReturn((Object)0);
        Mockito.when((Object)this.columnDefinitions.get(0)).thenReturn((Object)columnDefinition);
        ArrayDeque<ArrayList> data = new ArrayDeque<ArrayList>();
        data.add(Lists.newArrayList((Object[])new ByteBuffer[]{TypeCodecs.BOOLEAN.encode(Boolean.valueOf(false), DefaultProtocolVersion.DEFAULT)}));
        DefaultAsyncResultSet resultSet = new DefaultAsyncResultSet(this.columnDefinitions, this.executionInfo, data, this.session, this.context);
        Assertions.assertThat((boolean)resultSet.wasApplied()).isFalse();
    }

    @Test
    public void should_report_not_applied_if_column_present_and_true() {
        Mockito.when((Object)this.columnDefinitions.contains("[applied]")).thenReturn((Object)true);
        ColumnDefinition columnDefinition = (ColumnDefinition)Mockito.mock(ColumnDefinition.class);
        Mockito.when((Object)columnDefinition.getType()).thenReturn((Object)DataTypes.BOOLEAN);
        Mockito.when((Object)this.columnDefinitions.get("[applied]")).thenReturn((Object)columnDefinition);
        Mockito.when((Object)this.columnDefinitions.firstIndexOf("[applied]")).thenReturn((Object)0);
        Mockito.when((Object)this.columnDefinitions.get(0)).thenReturn((Object)columnDefinition);
        ArrayDeque<ArrayList> data = new ArrayDeque<ArrayList>();
        data.add(Lists.newArrayList((Object[])new ByteBuffer[]{TypeCodecs.BOOLEAN.encode(Boolean.valueOf(true), DefaultProtocolVersion.DEFAULT)}));
        DefaultAsyncResultSet resultSet = new DefaultAsyncResultSet(this.columnDefinitions, this.executionInfo, data, this.session, this.context);
        Assertions.assertThat((boolean)resultSet.wasApplied()).isTrue();
    }

    @Test(expected=IllegalStateException.class)
    public void should_fail_to_report_if_applied_if_column_present_but_empty() {
        Mockito.when((Object)this.columnDefinitions.contains("[applied]")).thenReturn((Object)true);
        ColumnDefinition columnDefinition = (ColumnDefinition)Mockito.mock(ColumnDefinition.class);
        Mockito.when((Object)columnDefinition.getType()).thenReturn((Object)DataTypes.BOOLEAN);
        Mockito.when((Object)this.columnDefinitions.get("[applied]")).thenReturn((Object)columnDefinition);
        DefaultAsyncResultSet resultSet = new DefaultAsyncResultSet(this.columnDefinitions, this.executionInfo, new ArrayDeque(), this.session, this.context);
        resultSet.wasApplied();
    }
}

